/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.basedao.dao;

import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.jndi.JNDIManager;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;

public class BaseDAO {
    protected static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$basedao$dao$BaseDAO == null ? (class$gov$epa$cdx$commons$basedao$dao$BaseDAO = BaseDAO.class$("gov.epa.cdx.commons.basedao.dao.BaseDAO")) : class$gov$epa$cdx$commons$basedao$dao$BaseDAO).getName());
    private static final String DATABASEACCESS_CATEGORY_KEY = "DatabaseAccess";
    static /* synthetic */ Class class$gov$epa$cdx$commons$basedao$dao$BaseDAO;

    public static Connection getConnection(String jndiName) throws CDXException {
        Connection conn = null;
        try {
            DataSource ds = (DataSource)JNDIManager.getObject(jndiName);
            conn = ds.getConnection();
        }
        catch (SQLException sqlEx) {
            log.fatal("Couldn't open connection.", sqlEx);
            throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)sqlEx);
        }
        catch (Exception e) {
            log.fatal("Couldn't open connection.", e);
            throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
        }
        return conn;
    }

    public static Connection getConnection() throws CDXException {
        return BaseDAO.getConnection(CDXPropertyManager.getProperty(DATABASEACCESS_CATEGORY_KEY, "DefaultDataSource", "datasource.CDXDataSource"));
    }

    public static void closeConnection(Connection connection) throws CDXException {
        try {
            connection.close();
        }
        catch (Exception e) {
            log.error("Couldn't close connection.", e);
        }
    }

    public static void rollback(Connection con) {
        try {
            con.rollback();
        }
        catch (Exception ex) {
            log.error("Couldn't rollback.", ex);
        }
    }

    public static String truncate(String inValue, int maxLength) {
        String outValue = inValue;
        if (inValue != null && inValue.length() > maxLength) {
            StringBuffer sbuff = new StringBuffer(inValue);
            sbuff.setLength(maxLength);
            outValue = sbuff.toString();
        }
        if (outValue == null) {
            outValue = "";
        }
        return outValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

