/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.basedao.dao.wrapper;

import gov.epa.cdx.commons.basedao.dao.wrapper.BlobInterface;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.DynamicLoader;
import java.sql.Blob;
import java.sql.Connection;

public class BlobManager {
    private static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$basedao$dao$wrapper$BlobManager == null ? (class$gov$epa$cdx$commons$basedao$dao$wrapper$BlobManager = BlobManager.class$("gov.epa.cdx.commons.basedao.dao.wrapper.BlobManager")) : class$gov$epa$cdx$commons$basedao$dao$wrapper$BlobManager).getName());
    private static final String propertyCat = "BLOB.Wrapper";
    private static final String propertyKey = "ImplementationClassName";
    static /* synthetic */ Class class$gov$epa$cdx$commons$basedao$dao$wrapper$BlobManager;

    public static Blob createBlob(Connection conn) throws CDXException {
        return BlobManager.createBlob(conn, null);
    }

    public static Blob createBlob(Connection conn, byte[] data) throws CDXException {
        BlobInterface blobImp = BlobManager.getWrapperImplementation();
        return blobImp.createBlob(conn, data);
    }

    private static BlobInterface getWrapperImplementation() throws CDXException {
        String className = CDXPropertyManager.getProperty(propertyCat, propertyKey, null);
        BlobInterface blobImp = null;
        if (className == null) {
            Exception ex = new Exception("Could n't find property for category:BLOB.Wrapper and key:ImplementationClassName");
            log.fatal("Could n't load Vendor/Database specific Blob implementation.", ex);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
        }
        try {
            Class impClass = DynamicLoader.loadClass(className);
            blobImp = (BlobInterface)impClass.newInstance();
        }
        catch (Exception e) {
            log.fatal("Could n't load class:" + className, e);
            throw new CDXException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
        }
        return blobImp;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

