/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.exception;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.HashMap;

public class CDXErrorCode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int id;
    private String description;
    public static HashMap table = new HashMap();
    public static final CDXErrorCode INTERNAL_SERVER_ERROR = new CDXErrorCode(1, "Internal Server Error");
    public static final CDXErrorCode DATABASE_FAILURE = new CDXErrorCode(2, "Database Failure");
    public static final CDXErrorCode VALIDATION_ERROR = new CDXErrorCode(3, "Validation Error");
    public static final CDXErrorCode VERSION_ERROR = new CDXErrorCode(4, "Wrong Version is provided.");
    public static final CDXErrorCode EXTERNAL_SERVER_ERROR = new CDXErrorCode(5, "External Server Error");
    public static final CDXErrorCode RUNTIME_ERROR = new CDXErrorCode(6, "Runtime Error");
    public static final CDXErrorCode RUNTIME_SQL_ERROR = new CDXErrorCode(7, "Runtime SQL Error");
    public static final CDXErrorCode RESTORED_EXCEPTION = new CDXErrorCode(8, "Current Exception was restored from Database.");
    public static final CDXErrorCode NULL_VALUE_EXCEPTION = new CDXErrorCode(9, "Value has not be NULL.");
    public static final CDXErrorCode PROPERTY_EXCEPTION = new CDXErrorCode(92, "Property not found in configuration database.  Add key and value to via Node Mgr.");
    public static final CDXErrorCode HTTP_URL_ERROR = new CDXErrorCode(10, "Malformed URL.");
    public static final CDXErrorCode HTTP_URL_BIND_ERROR = new CDXErrorCode(11, "Cannot Bind URL to Web Service");
    public static final CDXErrorCode HTTP_CONNECTION_FAILURE = new CDXErrorCode(12, "Could not open connection to HTTP Server.");
    public static final CDXErrorCode CONFIRM_PASSWORD_ERROR = new CDXErrorCode(15, "User password and confirmation password must be the same.");
    public static final CDXErrorCode INVALID_USER_OR_NOT_ADMINISTRATOR = new CDXErrorCode(16, "Either the user is not an administrator or the user name or password is invalid.");
    public static final CDXErrorCode AUTHENTICATION_AUTHORIZATION_ERROR = new CDXErrorCode(20, "Authentication/Authorization Error.");
    public static final CDXErrorCode INVALID_USER_OR_PASSWORD = new CDXErrorCode(21, "The user name or password is invalid.");
    public static final CDXErrorCode SECURITY_TOKEN_EXPIRED = new CDXErrorCode(22, "The security token has expired.");
    public static final CDXErrorCode SECURITY_TOKEN_INVALID = new CDXErrorCode(23, "The security token has invalid.");
    public static final CDXErrorCode SECURITY_WRONG_AUTH_METHOD = new CDXErrorCode(24, "The Authentication method is not supported.");
    public static final CDXErrorCode SECURITY_ACCESS_DENIED = new CDXErrorCode(25, "Access denied.");
    public static final CDXErrorCode LACK_OF_PRIVILEGE = new CDXErrorCode(26, "The operation could not be performed due to lack of privilege");
    public static final CDXErrorCode NO_STATE_AFFILIATION = new CDXErrorCode(27, "The user submission is not affiliated with any state");
    public static final CDXErrorCode NO_LEGACY_ID = new CDXErrorCode(28, "CDX Web Id could not be retrieved for user");
    public static final CDXErrorCode DOCUMENT_NAME_INVALID = new CDXErrorCode(29, "Specified document name could not be found.");
    public static final CDXErrorCode DOCUMENT_NAME_IS_NOT_SPECIFIED = new CDXErrorCode(30, "Document name is not specified");
    public static final CDXErrorCode INVALID_DOCUMENT_LIST = new CDXErrorCode(31, "Invalid Document List is Passed. The list contains zero Documents");
    public static final CDXErrorCode DUPLICATE_DOCUMENT_NAMES = new CDXErrorCode(32, "The List Contains documents with same names. Can not store Documents with Non Unique names");
    public static final CDXErrorCode DATA_FLOW_TYPE_MISSMATCH = new CDXErrorCode(33, "DataFlow Type of Requested Document does not match Data Flow Type of stored Dcoument");
    public static final CDXErrorCode DOCUMENT_TYPE_MISSMATCH = new CDXErrorCode(34, "Document Type of Requested Document does not match Document Type of stored Document");
    public static final CDXErrorCode DOCUMENT_TYPE_AND_DATA_FLOW_TYPE_MISSMATCH = new CDXErrorCode(35, "Data Flow Type of Requested Document and Document Type does not match Data Flow type and Document Type of stored Document");
    public static final CDXErrorCode INVALID_TRANSACTION_FOR_DOCUMENT = new CDXErrorCode(36, "Combination of Transaction Id and Name passed in is invalid");
    public static final CDXErrorCode INVALID_TRANSACTION_FOR_DOCUMENT_STORAGE = new CDXErrorCode(37, "Passed transaction is not valid and cannot be associated with the documents. Documents cannot be stored");
    public static final CDXErrorCode INVALID_TRANSACTION_FOR_DOCUMENT_RETRIEVAL = new CDXErrorCode(38, "Passed transaction is not valid and cannot be associated with the documents. Documents cannot be retrieved");
    public static final CDXErrorCode INVALID_DOCUMENT_ID = new CDXErrorCode(39, "Document ID is invalid");
    public static final CDXErrorCode INVALID_DATA_FLOW_TYPE = new CDXErrorCode(40, "Invalid Data Flow Type Specified");
    public static final CDXErrorCode INVALID_DOCUMENT_TYPE = new CDXErrorCode(41, "Invalid Document Type Specified");
    public static final CDXErrorCode INVALID_TRANSACTION_ID = new CDXErrorCode(42, "Invalid Transaction ID.");
    public static final CDXErrorCode INVALID_SERVICE_REQUEST_NAME = new CDXErrorCode(43, "Invalid Service Request Name.");
    public static final CDXErrorCode NODE_NOT_FOUND = new CDXErrorCode(44, "Sorry, Your server or client has to be registered within CDX Node Server to perform current Service");
    public static final CDXErrorCode INVALID_DOCUMENT_SIZE = new CDXErrorCode(45, "Size of the documents, you are trying to download, exceed recommended limits (80MB). ");
    public static final CDXErrorCode INVALID_NODE_ID = new CDXErrorCode(46, "Node ID is invalid. ");
    public static final CDXErrorCode INVALID_TASK_ID = new CDXErrorCode(47, "Task ID is invalid. ");
    public static final CDXErrorCode DOCUMENT_COULD_NOT_BE_UNZIPPED = new CDXErrorCode(48, "Unable to open and parse ZIP file. ");
    public static final CDXErrorCode DOCUMENT_COULD_NOT_BE_ZIPPED = new CDXErrorCode(49, "Unable to create ZIP file. ");
    public static final CDXErrorCode DOCUMENT_ZERO_BYTE_SIZE = new CDXErrorCode(50, "One of the documents is 0 bytes in size. ");
    public static final CDXErrorCode DOCUMENT_COULD_NOT_BE_WRITTEN_TO_DISK = new CDXErrorCode(51, "Unable to store file on disk. ");
    public static final CDXErrorCode INVALID_ZIP_FILE_ENTRIES = new CDXErrorCode(52, "Too many entries in ZIP file.  Only one entry allowed. ");
    public static final CDXErrorCode INVALID_NUMBER_OF_DOCUMENTS = new CDXErrorCode(53, "Number of documents in the submission is greater then allowed by the dataflow.");
    public static final CDXErrorCode DOCUMENT_HEADER_IS_REQUIRED = new CDXErrorCode(54, "Submitted document is missing the required Exchange Network Header.");
    public static final CDXErrorCode INVALID_DOCUMENT_HEADER = new CDXErrorCode(91, "Exchange Network Header in submitted document is either invalid XML or required values are missing.");
    public static final CDXErrorCode INVLALID_NUMBER_OF_PAYLOADS = new CDXErrorCode(55, "Number of payloads in the Exchange Network Header Document exceeds what is allowed by the the dataflow.");
    public static final CDXErrorCode INVALID_PAYLOAD_OPERATION_TYPE = new CDXErrorCode(56, "Payload operation type is not allowed by this dataflow.");
    public static final CDXErrorCode REQUESTOR_QUERY_SERVICE_ERROR = new CDXErrorCode(60, "Unable to Perform Query Web Service");
    public static final CDXErrorCode REQUESTOR_SUBMIT_SERVICE_ERROR = new CDXErrorCode(61, "Unable to Perform Submit Web Service");
    public static final CDXErrorCode REQUESTOR_WRONG_TYPE_ERROR = new CDXErrorCode(62, "The type of request is wrong.");
    public static final CDXErrorCode REQUESTOR_DOWNLOAD_SERVICE_ERROR = new CDXErrorCode(63, "Unable to Perform Download Web Service");
    public static final CDXErrorCode REQUESTOR_NOTIFY_SERVICE_ERROR = new CDXErrorCode(66, "Unable to Perform Notify Web Service");
    public static final CDXErrorCode INVALID_QUERY_PARAMETERS_ERROR = new CDXErrorCode(64, "Wrong or not sufficient query parameters");
    public static final CDXErrorCode FILE_TOO_LARGE_FOR_SYNCH_QUERY_ERROR = new CDXErrorCode(65, "The file is too large for synchronous query");
    public static final CDXErrorCode REQUESTOR_SOLICIT_SERVICE_ERROR = new CDXErrorCode(67, "Unable to Perform Solicit Web Service");
    public static final CDXErrorCode STATUSPROVIDER_FOR_SERVICE_NOT_DEFINED = new CDXErrorCode(70, "Status Provider implementation for provided dataflow not defined or misconfigured.");
    public static final CDXErrorCode STATUSPROVIDER_FOR_SERVICE_COULD_NOT_BE_LOADED = new CDXErrorCode(71, "Status Provider implementation for dataflow could not be loaded.");
    public static final CDXErrorCode STATUSPROVIDER_REMOTE_CALL_FAILED = new CDXErrorCode(72, "Remote Status Provider call failed.");
    public static final CDXErrorCode STATUSNOTIFIER_FOR_SERVICE_NOT_DEFINED = new CDXErrorCode(73, "Status Notifier implementation for provided dataflow not defined or misconfigured.");
    public static final CDXErrorCode STATUSNOTIFIER_FOR_SERVICE_COULD_NOT_BE_LOADED = new CDXErrorCode(74, "Status Notifier implementation for dataflow could not be loaded.");
    public static final CDXErrorCode STATUSNOTIFIER_REMOTE_CALL_FAILED = new CDXErrorCode(75, "Remote Status Notifier call failed.");
    public static final CDXErrorCode DISTRIBUTOR_FOR_DATAFLOW_NOT_DEFINED = new CDXErrorCode(76, "Distributor for provided dataflow not defined or misconfigured.");
    public static final CDXErrorCode DISTRIBUTOR_FOR_DATAFLOW_COULD_NOT_BE_LOADED = new CDXErrorCode(77, "Distributor for provided dataflow could not be loaded.");
    public static final CDXErrorCode DISTRIBUTOR_DELIVERY_ERROR = new CDXErrorCode(78, "Delivery to dataflow failed.");
    public static final CDXErrorCode SERVICEPROVIDER_FOR_SERVICE_NOT_DEFINED = new CDXErrorCode(80, "Service Provider implementation for provided service name not defined or misconfigured.");
    public static final CDXErrorCode SERVICEPROVIDER_FOR_SERVICE_COULD_NOT_BE_LOADED = new CDXErrorCode(81, "Service Provider implementation for provided service name could not be loaded.");
    public static final CDXErrorCode SERVICEPROVIDER_REMOTE_CALL_FAILED = new CDXErrorCode(82, "Remote Service Provider call failed.");
    public static final CDXErrorCode ERROR_READING_NOTIFICATION_REPORT = new CDXErrorCode(83, "Unable to parse report during notification.");
    public static final CDXErrorCode ERROR_CONFIRMING_DELIVERY = new CDXErrorCode(84, "Unable to confirm distribution.");
    public static final CDXErrorCode INVALID_TRANSACTION_FOR_NOTIFICATION = new CDXErrorCode(85, "Notification failed for provided transaction.");
    public static final CDXErrorCode INVALID_STATUS_FOR_NOTIFICATION = new CDXErrorCode(86, "Notification failed due to invalid status message.");
    public static final CDXErrorCode INVALID_DATAFLOW_FOR_NOTIFICATION = new CDXErrorCode(87, "Notification failed due to invalid data flow type.");
    public static final CDXErrorCode ERROR_STORING_NOTIFICATION_REPORT = new CDXErrorCode(88, "Unable to store report during notification.");
    public static final CDXErrorCode ERROR_UPDATING_DISTRIBUTION_STATUS = new CDXErrorCode(89, "Unable to update distribution status.");
    public static final CDXErrorCode INVALID_AUDIT_ID = new CDXErrorCode(90, "Specified audit id could not be found. Please, check the number and try again.");
    public static final CDXErrorCode FEATURE_UNSUPPORTED = new CDXErrorCode(100, "Feature Unsupported at this time.");
    public static final CDXErrorCode SCHEDULER_ERROR = new CDXErrorCode(110, "Scheduler Error.");
    public static final CDXErrorCode SCHEDULER_CAN_NOT_FIND_TRIGGER = new CDXErrorCode(111, "Scheduler Couldnt not find trigger.");
    public static final CDXErrorCode SCHEDULER_NO_MORE_FIRE_TIMES = new CDXErrorCode(112, "This task does not have any more fire times.");
    public static final CDXErrorCode PROVIDER_IS_NOT_READY_WITH_DOCUMENTS = new CDXErrorCode(113, "Provider Is Not Ready With Documents");
    public static final CDXErrorCode COULD_NOT_SEND_EMAIL = new CDXErrorCode(120, "Could not send email");

    public CDXErrorCode(int anID, String errorDescription) {
        this.id = anID;
        this.description = errorDescription;
        Object test = table.get(new Integer(anID));
        if (test != null) {
            throw new RuntimeException("CDXErrorCode duplicate! ID=" + anID);
        }
        table.put(new Integer(this.id), this);
    }

    public int getErrrorCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        CDXErrorCode otherErrorCode = (CDXErrorCode)obj;
        return this.id == otherErrorCode.getErrrorCode();
    }

    public String getErrorDescription() {
        return this.description;
    }

    public static CDXErrorCode getCDXErrorCodeById(int typeId) {
        return (CDXErrorCode)table.get(new Integer(typeId));
    }

    private Object readResolve() throws ObjectStreamException {
        return CDXErrorCode.getCDXErrorCodeById(this.id);
    }
}

