/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.exception;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class CDXException
extends Exception {
    private static final long serialVersionUID = 1L;
    private CDXErrorCode cdxErrorCode = null;
    private Throwable nestedException = null;

    public CDXException(CDXErrorCode errorCode) {
        this(errorCode, null);
    }

    public CDXException(CDXErrorCode errorCode, Throwable nestedException) {
        super(errorCode.getErrorDescription());
        this.cdxErrorCode = errorCode;
        this.nestedException = nestedException;
    }

    public CDXErrorCode getCDXErrorCode() {
        return this.cdxErrorCode;
    }

    public String getErrorCodeDescription() {
        return this.cdxErrorCode.getErrorDescription();
    }

    public void setErrorCode(CDXErrorCode errorCode) {
        this.cdxErrorCode = errorCode;
    }

    public Throwable getNestedException() {
        return this.nestedException;
    }

    public void setNestedException(Throwable nestedException) {
        this.nestedException = nestedException;
    }

    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    public void printStackTrace(PrintWriter s) {
        StringBuffer outString = null;
        try {
            outString = new StringBuffer();
            this.printThrowble(outString);
            s.print(outString);
            s.flush();
        }
        catch (Exception ex) {
            System.out.println("!!! Error happens when execute: CDXException.printStackTrace(). " + ex);
        }
    }

    public void printStackTrace(PrintStream s) {
        StringBuffer outString = null;
        try {
            outString = new StringBuffer();
            this.printThrowble(outString);
            s.print(outString);
            s.flush();
        }
        catch (Exception ex) {
            System.out.println("!!! Error happens when execute: CDXException.printStackTrace(). " + ex);
        }
    }

    public String getMessage() {
        String message = "Error Code: " + this.getCDXErrorCode().getErrrorCode() + " Error Description: " + this.getErrorCodeDescription();
        return message;
    }

    public void printThrowble(StringBuffer out) {
        StringWriter sw = new StringWriter();
        PrintWriter w = new PrintWriter(sw);
        out.append("    CDXException: " + this.getMessage() + "\n");
        out.append("    CDXException Error Code: " + this.getCDXErrorCode().getErrrorCode() + "\n");
        out.append("    StackTrace: ");
        super.printStackTrace(w);
        w.flush();
        out.append(sw.toString());
        w.close();
        Throwable nextExp = this.getNestedException();
        if (nextExp != null) {
            out.append("----- Nested Exception is: \n");
            if (nextExp instanceof CDXException) {
                CDXException ex = (CDXException)nextExp;
                ex.printThrowble(out);
            } else {
                sw = new StringWriter();
                w = new PrintWriter(sw);
                nextExp.printStackTrace(w);
                w.flush();
                out.append(sw.toString());
                w.close();
            }
        }
    }
}

