/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.jms;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.jndi.JNDIManager;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import java.io.Serializable;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.naming.InitialContext;

public class JMSManager {
    private static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$jms$JMSManager == null ? (class$gov$epa$cdx$commons$jms$JMSManager = JMSManager.class$("gov.epa.cdx.commons.jms.JMSManager")) : class$gov$epa$cdx$commons$jms$JMSManager).getName());
    private static String JMS_FACTORY = "weblogic.jws.jms.QueueConnectionFactory";
    private static int MESSAGE_TYPE_EMPTY = 0;
    private static int MESSAGE_TYPE_STRING = 1;
    private static int MESSAGE_TYPE_OBJECT = 2;
    static /* synthetic */ Class class$gov$epa$cdx$commons$jms$JMSManager;

    public static void sendMessage(String inJMSName) throws CDXException {
        JMSManager.sendMessage(inJMSName, null, MESSAGE_TYPE_EMPTY);
    }

    public static void sendMessage(String inJMSName, String inMessageObject) throws CDXException {
        JMSManager.sendMessage(inJMSName, inMessageObject, MESSAGE_TYPE_STRING);
    }

    public static void sendMessage(String inJMSName, Serializable inMessageObject) throws CDXException {
        JMSManager.sendMessage(inJMSName, inMessageObject, MESSAGE_TYPE_OBJECT);
    }

    /*
     * Loose catch block
     */
    private static void sendMessage(String inJMSName, Object inMessageObject, int inMessageType) throws CDXException {
        block19: {
            InitialContext ctx = null;
            QueueConnectionFactory qconFactory = null;
            QueueConnection qcon = null;
            QueueSession qsession = null;
            QueueSender qsender = null;
            Queue queue = null;
            Message msg = null;
            ctx = JNDIManager.getContext();
            String overrideFactory = CDXPropertyManager.getProperty("JMS", "DefaultConnectionFactory");
            if (overrideFactory != null) {
                JMS_FACTORY = overrideFactory;
            }
            qconFactory = (QueueConnectionFactory)ctx.lookup(JMS_FACTORY);
            qcon = qconFactory.createQueueConnection();
            qsession = qcon.createQueueSession(false, 1);
            queue = (Queue)ctx.lookup(inJMSName);
            qsender = qsession.createSender(queue);
            if (inMessageType == MESSAGE_TYPE_EMPTY) {
                msg = qsession.createMessage();
            } else if (inMessageType == MESSAGE_TYPE_STRING) {
                msg = qsession.createTextMessage((String)inMessageObject);
            }
            if (inMessageType == MESSAGE_TYPE_OBJECT) {
                msg = qsession.createObjectMessage((Serializable)inMessageObject);
            }
            qcon.start();
            qsender.send(msg);
            Object var12_13 = null;
            try {
                if (qsender != null) {
                    qsender.close();
                }
                if (qsession != null) {
                    qsession.close();
                }
                if (qcon != null) {
                    qcon.close();
                }
                break block19;
            }
            catch (Exception ex) {
                log.error("JMS Exception form finally block.", ex);
            }
            break block19;
            {
                catch (CDXException cdxEx) {
                    throw cdxEx;
                }
                catch (Exception ex) {
                    log.fatal("Faild to send JMS message.", ex);
                    throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable throwable) {
                Object var12_14 = null;
                try {
                    if (qsender != null) {
                        qsender.close();
                    }
                    if (qsession != null) {
                        qsession.close();
                    }
                    if (qcon != null) {
                        qcon.close();
                    }
                }
                catch (Exception ex) {
                    log.error("JMS Exception form finally block.", ex);
                }
                throw throwable;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

