/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.jndi;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.FileManager;
import java.io.FileInputStream;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.InitialContext;

public class JNDIManager {
    private static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$jndi$JNDIManager == null ? (class$gov$epa$cdx$commons$jndi$JNDIManager = JNDIManager.class$("gov.epa.cdx.commons.jndi.JNDIManager")) : class$gov$epa$cdx$commons$jndi$JNDIManager).getName());
    private static final String FILE_NAME = "cdx_jndi.properties";
    private static final String DEFAULT_INITIAL_CONTEXT_FACTORY = "weblogic.jndi.WLInitialContextFactory";
    private static final String DEFAULT_PROVIDER_URL = "t3://localhost:80";
    private static final String KEY_LOCATION = "current.file.location";
    private static final String KEY_FACTORY = "INITIAL_CONTEXT_FACTORY";
    private static final String KEY_URL = "PROVIDER_URL";
    private static Boolean isItServer = null;
    private static Hashtable intEnv = null;
    static /* synthetic */ Class class$gov$epa$cdx$commons$jndi$JNDIManager;

    private JNDIManager() {
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Object getObject(String inJNDIName) throws CDXException {
        Object obj = null;
        InitialContext ctx = JNDIManager.getContext();
        obj = ctx.lookup(inJNDIName);
        Object var5_3 = null;
        if (ctx == null) return obj;
        try {
            ctx.close();
            return obj;
        }
        catch (Exception e) {
            log.error("Failed to close context (in finally block) due to:", e);
        }
        return obj;
        {
            catch (Exception ex) {
                log.fatal("Could not execute ctx.lookup(" + inJNDIName + ")", ex);
                throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
            }
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (ctx == null) throw throwable;
            try {
                ctx.close();
                throw throwable;
            }
            catch (Exception e) {
                log.error("Failed to close context (in finally block) due to:", e);
            }
            throw throwable;
        }
    }

    public static InitialContext getContext() throws CDXException {
        InitialContext ctx = null;
        if (isItServer == null) {
            JNDIManager.loadInitParameters();
        }
        try {
            ctx = isItServer.booleanValue() ? new InitialContext() : new InitialContext(intEnv);
        }
        catch (AuthenticationException e) {
            log.fatal("You've specified an invalid user name or password", e);
            throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
        }
        catch (CommunicationException e) {
            log.fatal("Failed to contact server. PROVIDER URL is wrong.", e);
            throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
        }
        catch (Exception e) {
            log.fatal("An unexpected exception occurred.", e);
            throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
        }
        return ctx;
    }

    private static void loadInitParameters() throws CDXException {
        Properties prop = new Properties();
        FileInputStream in = null;
        String value = "";
        try {
            if (FileManager.isFileExists(FILE_NAME)) {
                in = new FileInputStream(FILE_NAME);
                prop.load(in);
                if (!prop.isEmpty()) {
                    value = prop.getProperty(KEY_LOCATION, "server");
                    if (value.trim().equalsIgnoreCase("server")) {
                        isItServer = new Boolean(true);
                        intEnv = new Hashtable();
                    } else {
                        isItServer = new Boolean(false);
                        intEnv = new Hashtable();
                        intEnv.put("java.naming.factory.initial", prop.getProperty(KEY_FACTORY, DEFAULT_INITIAL_CONTEXT_FACTORY));
                        intEnv.put("java.naming.provider.url", prop.getProperty(KEY_URL, DEFAULT_PROVIDER_URL));
                    }
                } else {
                    isItServer = new Boolean(true);
                    intEnv = new Hashtable();
                    log.warn("##!!!! cdx_jndi.properties is empty!!!");
                }
            } else {
                isItServer = new Boolean(true);
                intEnv = new Hashtable();
            }
        }
        catch (CDXException cdxEx) {
            log.fatal("Couldn't read Initial Parameters for JNDI Context.", cdxEx);
            isItServer = new Boolean(true);
            intEnv = new Hashtable();
            throw cdxEx;
        }
        catch (Exception ex) {
            log.fatal("Couldn't read Initial Parameters for JNDI Context.", ex);
            isItServer = new Boolean(true);
            intEnv = new Hashtable();
            throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

