/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.jndi;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.jndi.JNDIManager;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.ejb.EJBHome;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

public class ServiceLocator {
    private static ServiceLocator me;
    private static LogInterface log;
    InitialContext context = JNDIManager.getContext();
    static /* synthetic */ Class class$gov$epa$cdx$commons$jndi$ServiceLocator;

    private ServiceLocator() throws CDXException {
    }

    public static ServiceLocator getInstance() throws CDXException {
        if (me == null) {
            me = new ServiceLocator();
        }
        return me;
    }

    public EJBHome getHome(String jndiName, Class clazz) throws CDXException {
        EJBHome home = null;
        try {
            Object objref = this.context.lookup(jndiName);
            home = (EJBHome)PortableRemoteObject.narrow((Object)objref, (Class)clazz);
        }
        catch (NamingException ex) {
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return home;
    }

    public Object getRemote(String jndiName, Class clazz) throws CDXException {
        Object remoteObject = null;
        try {
            EJBHome home = this.getHome(jndiName, clazz);
            Class[] noParams = new Class[]{};
            Method method = clazz.getMethod("create", noParams);
            Object[] params = new Object[]{};
            remoteObject = method.invoke((Object)home, params);
        }
        catch (IllegalAccessException e) {
            log.fatal("ServiceLocator. Unable to get a handle on the remote object.", e);
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            log.fatal("ServiceLocator. On reflection, intended method was not found.", e);
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            log.fatal("ServiceLocator. On reflection, unable to invoke intended method.", e);
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
        return remoteObject;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        log = LogFactory.getLog((class$gov$epa$cdx$commons$jndi$ServiceLocator == null ? (class$gov$epa$cdx$commons$jndi$ServiceLocator = ServiceLocator.class$("gov.epa.cdx.commons.jndi.ServiceLocator")) : class$gov$epa$cdx$commons$jndi$ServiceLocator).getName());
    }
}

