/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.log;

import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.mail.CDXMailAlertsManager;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class BasicLog
implements LogInterface {
    protected String className = "";
    protected static SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd_HH:mm:ss:SSS");

    public void fatal(Object object) {
        this.fatal(object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        String alarm = CDXPropertyManager.getProperty("Alarms", "Alarm");
        if (Boolean.valueOf(alarm).booleanValue()) {
            StringBuffer sb = null;
            try {
                sb = this.getPrintableString(object, throwable, "FATAL");
                CDXMailAlertsManager.sendFatalServerAlert(object, throwable, sb.toString());
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    protected StringBuffer getPrintableString(Object object, Throwable throwable, String level) {
        StringBuffer sb = new StringBuffer();
        int l = 0;
        try {
            sb.append("\n*** [" + level + "]");
            sb.append("[When: " + formatter.format(new Date()));
            sb.append("] Where: " + this.className + "\n");
            l = sb.length();
            sb.append("    Message: " + object + "\n");
            if (throwable != null) {
                StringWriter sw = new StringWriter();
                PrintWriter w = new PrintWriter(sw);
                throwable.printStackTrace(w);
                w.flush();
                sb.append(sw.toString());
            }
            for (int i = 0; i < l; ++i) {
                sb.append("*");
            }
            sb.append("\n");
        }
        catch (Exception ex) {
            System.out.println("!!!!!!!! LOG FAILED !!!!!! logImpl:" + this.getClass().getName());
            ex.printStackTrace();
        }
        return sb;
    }
}

