/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.log;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.helpers.LogLog;
import org.apache.log4j.spi.LoggingEvent;

public class DailyRollingFileAppender
extends FileAppender {
    public static final String DEFAULT_DATE_PATTERN = "'-'yyyy-MM-dd'.log'";
    private static final int TOP_OF_TROUBLE = -1;
    private static final int TOP_OF_MINUTE = 0;
    private static final int TOP_OF_HOUR = 1;
    private static final int HALF_DAY = 2;
    private static final int TOP_OF_DAY = 3;
    private static final int TOP_OF_WEEK = 4;
    private static final int TOP_OF_MONTH = 5;
    static final TimeZone gmtTimeZone = TimeZone.getTimeZone("GMT");
    private String datePattern = "'-'yyyy-MM-dd'.log'";
    private String rootFileName;
    private long nextCheck;
    private Date now = new Date();
    private SimpleDateFormat sdf;
    private RollingCalendar rc = new RollingCalendar();
    private int checkPeriod = -1;

    public DailyRollingFileAppender() {
        this.now = new Date();
        this.nextCheck = this.now.getTime() - 1L;
    }

    public DailyRollingFileAppender(Layout layout, String filename, String datePattern) throws IOException {
        this();
        this.layout = layout;
        this.datePattern = datePattern;
        this.activateOptions();
    }

    public void setDatePattern(String pattern) {
        this.datePattern = pattern;
    }

    public String getDatePattern() {
        return this.datePattern;
    }

    public void activateOptions() {
        if (this.datePattern == null) {
            LogLog.error((String)("DatePattern option is not set for appender [" + this.name + "]."));
        } else if (this.fileName == null) {
            LogLog.error((String)("File  options is not set for appender [" + this.name + "]."));
        } else {
            this.now.setTime(System.currentTimeMillis());
            this.sdf = new SimpleDateFormat(this.datePattern);
            int type = this.computeCheckPeriod();
            this.printPeriodicity(type);
            this.rc.setType(type);
            this.rootFileName = this.fileName;
            this.fileName = this.createFileName(this.now);
        }
        super.activateOptions();
    }

    void printPeriodicity(int type) {
        switch (type) {
            case 0: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled every minute."));
                break;
            }
            case 1: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled on top of every hour."));
                break;
            }
            case 2: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midday and midnight."));
                break;
            }
            case 3: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at midnight."));
                break;
            }
            case 4: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of week."));
                break;
            }
            case 5: {
                LogLog.debug((String)("Appender [" + this.name + "] to be rolled at start of every month."));
                break;
            }
            default: {
                LogLog.warn((String)("Unknown periodicity for appender [" + this.name + "]."));
            }
        }
    }

    private int computeCheckPeriod() {
        RollingCalendar rollingCalendar = new RollingCalendar(gmtTimeZone, Locale.ENGLISH);
        Date epoch = new Date(0L);
        if (this.datePattern != null) {
            for (int i = 0; i <= 5; ++i) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat(this.datePattern);
                simpleDateFormat.setTimeZone(gmtTimeZone);
                String r0 = simpleDateFormat.format(epoch);
                rollingCalendar.setType(i);
                Date next = new Date(rollingCalendar.getNextCheckMillis(epoch));
                String r1 = simpleDateFormat.format(next);
                if (r0 == null || r1 == null || r0.equals(r1)) continue;
                return i;
            }
        }
        return -1;
    }

    private String createFileName(Date when) {
        int slashPos = this.rootFileName.lastIndexOf(92);
        String path = null;
        boolean noLogDir = false;
        File logDir = null;
        if (slashPos != -1) {
            path = this.rootFileName.substring(0, slashPos);
        } else {
            slashPos = this.rootFileName.lastIndexOf(47);
            if (slashPos != -1) {
                path = this.rootFileName.substring(0, slashPos);
            } else {
                noLogDir = true;
            }
        }
        if (!(noLogDir || (logDir = new File(path)).exists() || logDir.mkdirs())) {
            LogLog.error((String)"Log directory could not be create. ");
            String defaultLog = "cdx_logs";
            File defaultLogDir = new File(defaultLog);
            if (defaultLogDir.mkdirs()) {
                LogLog.error((String)"A default log directory was created instead.");
            }
            this.rootFileName = defaultLog + File.separator + this.rootFileName.substring(slashPos + 1);
        }
        return this.rootFileName + this.sdf.format(when);
    }

    private synchronized void rollOver() throws IOException {
        if (this.datePattern == null) {
            this.errorHandler.error("Missing DatePattern option in rollOver().");
            return;
        }
        String datedFileName = this.createFileName(this.now);
        if (this.fileName.compareTo(datedFileName) >= 0) {
            return;
        }
        LogLog.debug((String)("ROLLOVER: closing '" + this.fileName + " in favor of '" + datedFileName + "'"));
        this.closeFile();
        Exception err = null;
        try {
            LogLog.debug((String)("ROLLOVER: opening new file '" + datedFileName));
            this.setFile(datedFileName, true, this.bufferedIO, this.bufferSize);
            this.fileName = datedFileName;
        }
        catch (Exception e) {
            LogLog.error((String)("setFile(" + datedFileName + ", true) call failed."));
            err = e;
        }
        if (err != null) {
            LogLog.warn((String)("setFile(" + this.fileName + ", true) trying to use old file."));
            try {
                this.setFile(this.fileName, true, this.bufferedIO, this.bufferSize);
                LogLog.debug((String)("setFile(" + this.fileName + ", true) (old file) in use."));
            }
            catch (IOException x) {
                LogLog.error((String)("setFile(" + this.fileName + ", true) call failed, appender died."));
                this.errorHandler.error("setFile(" + datedFileName + ", true) call failed.");
            }
        }
    }

    protected void subAppend(LoggingEvent event) {
        long n = System.currentTimeMillis();
        if (n >= this.nextCheck) {
            this.now.setTime(n);
            this.nextCheck = this.rc.getNextCheckMillis(this.now);
            try {
                this.rollOver();
            }
            catch (IOException ioe) {
                LogLog.error((String)"rollOver() failed.", (Throwable)ioe);
            }
        }
        super.subAppend(event);
    }

    class RollingCalendar
    extends GregorianCalendar {
        int type = -1;

        RollingCalendar() {
        }

        RollingCalendar(TimeZone tz, Locale locale) {
            super(tz, locale);
        }

        void setType(int type) {
            this.type = type;
        }

        public long getNextCheckMillis(Date now) {
            return this.getNextCheckDate(now).getTime();
        }

        public Date getNextCheckDate(Date now) {
            this.setTime(now);
            switch (this.type) {
                case 0: {
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(12, 1);
                    break;
                }
                case 1: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(11, 1);
                    break;
                }
                case 2: {
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    int hour = this.get(11);
                    if (hour < 12) {
                        this.set(11, 12);
                        break;
                    }
                    this.set(11, 0);
                    this.add(5, 1);
                    break;
                }
                case 3: {
                    this.set(11, 0);
                    this.set(12, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(5, 1);
                    break;
                }
                case 4: {
                    this.set(7, this.getFirstDayOfWeek());
                    this.set(11, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(3, 1);
                    break;
                }
                case 5: {
                    this.set(5, 1);
                    this.set(11, 0);
                    this.set(13, 0);
                    this.set(14, 0);
                    this.add(2, 1);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown periodicity type.");
                }
            }
            return this.getTime();
        }
    }
}

