/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.mail;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.mail.CDXMailManager;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.CDXSystemManager;
import java.util.Hashtable;

public class CDXMailAlertsManager {
    protected static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$mail$CDXMailAlertsManager == null ? (class$gov$epa$cdx$commons$mail$CDXMailAlertsManager = CDXMailAlertsManager.class$("gov.epa.cdx.commons.mail.CDXMailAlertsManager")) : class$gov$epa$cdx$commons$mail$CDXMailAlertsManager).getName());
    private static String subject = null;
    private static Hashtable sentFatalAlerts = new Hashtable();
    static /* synthetic */ Class class$gov$epa$cdx$commons$mail$CDXMailAlertsManager;

    private CDXMailAlertsManager() {
    }

    public static void sendAlert(String message) throws CDXException {
        CDXMailAlertsManager.sendAlert(null, message);
    }

    public static void sendAlert(String subject, String message) throws CDXException {
        String alertsFrom = CDXPropertyManager.getProperty("Alarms", "MailFrom");
        String sendTo = CDXPropertyManager.getProperty("Alarms", "MailTo");
        CDXMailManager.sendMail(alertsFrom, sendTo, subject == null ? CDXMailAlertsManager.getSubject() : subject, message);
    }

    public static void sendFatalServerAlert(Object object, Throwable throwable, String message) {
        try {
            if (CDXMailAlertsManager.shouldBeSend(CDXMailAlertsManager.getAlertKey(object, throwable))) {
                CDXMailAlertsManager.sendAlert(CDXMailAlertsManager.getSubject(), message);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean shouldBeSend(String alertKey) {
        boolean shouldSend = true;
        Object alertTime = sentFatalAlerts.get(alertKey);
        if (alertTime == null) {
            sentFatalAlerts.put(alertKey, new Long(System.currentTimeMillis()));
        } else {
            String timeoutString;
            long fatalAlertsTimeOut;
            long st = (Long)alertTime;
            long delta = System.currentTimeMillis() - st;
            if (delta < (fatalAlertsTimeOut = Long.parseLong(timeoutString = CDXPropertyManager.getProperty("Alarms", "Timeout")))) {
                shouldSend = false;
            } else {
                sentFatalAlerts.put(alertKey, new Long(System.currentTimeMillis()));
            }
        }
        return shouldSend;
    }

    private static String getSubject() {
        if (subject == null) {
            try {
                subject = "CDXServerAlerts (IP:" + CDXSystemManager.getCurrentServerPrivateIP() + ") had FATAL Exception.";
            }
            catch (CDXException ex) {
                subject = null;
                return "CDXServerAlerts (IP:unknown) had FATAL Exception.";
            }
        }
        return subject;
    }

    private static String getAlertKey(Object object, Throwable throwable) {
        StringBuffer value = new StringBuffer();
        value.append(object);
        value.append("_");
        if (throwable == null) {
            value.append("null");
        } else {
            value.append(throwable.getMessage());
        }
        return value.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

