/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.mail;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class CDXMailManager {
    protected static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$mail$CDXMailManager == null ? (class$gov$epa$cdx$commons$mail$CDXMailManager = CDXMailManager.class$("gov.epa.cdx.commons.mail.CDXMailManager")) : class$gov$epa$cdx$commons$mail$CDXMailManager).getName());
    private static String defaultSubject = "Message from CDXServer.";
    private static String defaultFrom = "CDXServer";
    private static String defaultMessage = defaultSubject;
    public static final String KEY_FROM = "mail.from";
    public static final String KEY_SERVER = "mail.smtp.host";
    public static final String KEY_PROTOCOL = "mail.transport.protocol";
    private static Properties mailProp = null;
    static /* synthetic */ Class class$gov$epa$cdx$commons$mail$CDXMailManager;

    private CDXMailManager() {
    }

    public static void sendMail(String to, String subject, String message) throws CDXException {
        CDXMailManager.sendMail(null, to, subject, message);
    }

    public static void sendMail(String from, String to, String subject, String message) throws CDXException {
        Session session = null;
        Object props = null;
        MimeMessage msg = null;
        MimeBodyPart mbp = null;
        MimeMultipart mp = null;
        try {
            if (to == null || to.trim().equalsIgnoreCase("")) {
                throw new CDXValidationException(CDXErrorCode.RUNTIME_ERROR, (Throwable)new Exception("e-mail address doesn't provided."));
            }
            session = Session.getInstance((Properties)CDXMailManager.getInitProperties());
            msg = new MimeMessage(session);
            if (from != null) {
                try {
                    InternetAddress inAd = new InternetAddress(from);
                    msg.setFrom((Address)inAd);
                }
                catch (Exception ex) {
                    log.error("From address is wrong (" + from + ")", ex);
                    msg.setFrom();
                }
            } else {
                msg.setFrom();
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            msg.setSubject(CDXMailManager.getSubject(subject));
            msg.setSentDate(new Date());
            mbp = new MimeBodyPart();
            mbp.setText(CDXMailManager.getMessage(message));
            mp = new MimeMultipart();
            mp.addBodyPart((BodyPart)mbp);
            msg.setContent((Multipart)mp);
            session.getTransport();
            Transport.send((Message)msg);
        }
        catch (CDXException cdxEx) {
            throw cdxEx;
        }
        catch (Exception ex) {
            log.error("", ex);
            throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
        }
    }

    private static String getMessage(String message) {
        return message == null ? defaultMessage : message;
    }

    private static String getSubject(String subject) {
        return subject == null ? defaultSubject : subject;
    }

    public static Properties getInitProperties() {
        if (mailProp == null) {
            mailProp = CDXMailManager.loadProperties();
        }
        return mailProp;
    }

    private static Properties loadProperties() {
        Properties prop = new Properties();
        prop.setProperty(KEY_FROM, CDXPropertyManager.getProperty("Mail", KEY_FROM));
        prop.setProperty(KEY_SERVER, CDXPropertyManager.getProperty("Mail", KEY_SERVER));
        prop.setProperty(KEY_PROTOCOL, CDXPropertyManager.getProperty("Mail", KEY_PROTOCOL));
        return prop;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

