/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.property;

import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.EncoderDecoder;
import java.util.HashMap;
import java.util.Map;
import org.jconfig.Configuration;
import org.jconfig.ConfigurationManager;
import org.jconfig.ConfigurationManagerException;
import org.jconfig.handler.ConfigurationHandler;
import org.jconfig.handler.InputStreamHandler;
import org.jconfig.handler.XMLFileHandler;

public class CDXPropertyManager {
    private static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$property$CDXPropertyManager == null ? (class$gov$epa$cdx$commons$property$CDXPropertyManager = CDXPropertyManager.class$("gov.epa.cdx.commons.property.CDXPropertyManager")) : class$gov$epa$cdx$commons$property$CDXPropertyManager).getName());
    private static final String DEFAULT_CONFIG_KEY = "global";
    private static final String USER_CONFIG_KEY = "user";
    public static String GLOBAL_CONFIG_FILE = "cdx_properties.xml";
    public static String USER_CONFIG_FILE = "user_properties.xml";
    private static final String GLOBAL_CATEGORY_KEY = "global";
    private static Configuration GlobalConfig;
    private static Configuration UserConfig;
    private static InputStreamHandler globalConfigStream;
    private static InputStreamHandler userConfigStream;
    static /* synthetic */ Class class$gov$epa$cdx$commons$property$CDXPropertyManager;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void init(String globalConfigName, String userConfigName) {
        String string = GLOBAL_CONFIG_FILE;
        synchronized (string) {
            GLOBAL_CONFIG_FILE = globalConfigName;
        }
        string = USER_CONFIG_FILE;
        synchronized (string) {
            USER_CONFIG_FILE = userConfigName;
        }
    }

    public static void init(InputStreamHandler globalConfigStreamIn) {
        globalConfigStream = globalConfigStreamIn;
    }

    public static void init(InputStreamHandler globalConfigStreamIn, InputStreamHandler userConfigStreamIn) {
        globalConfigStream = globalConfigStreamIn;
        userConfigStream = userConfigStreamIn;
    }

    public static void loadProperties() {
        try {
            GlobalConfig = CDXPropertyManager.getGlobalConfig();
        }
        catch (Exception ex) {
            GlobalConfig = null;
            log.error("Can't load global properties. Will use caller supplied defaults.", ex);
        }
        try {
            UserConfig = CDXPropertyManager.getUserConfig();
        }
        catch (Exception ex) {
            log.info("Can't load user properties. Will use global properties.", ex);
        }
    }

    private static Configuration getGlobalConfig() throws ConfigurationManagerException {
        if (GlobalConfig == null) {
            try {
                if (globalConfigStream == null) {
                    ConfigurationManager.getInstance().load((ConfigurationHandler)new InputStreamHandler(GLOBAL_CONFIG_FILE), "global");
                } else {
                    ConfigurationManager.getInstance().load((ConfigurationHandler)globalConfigStream, "global");
                }
                GlobalConfig = ConfigurationManager.getConfiguration((String)"global");
            }
            catch (ConfigurationManagerException e) {
                GlobalConfig = null;
                throw e;
            }
        }
        return GlobalConfig;
    }

    private static Configuration getUserConfig() throws ConfigurationManagerException {
        if (UserConfig == null) {
            try {
                if (userConfigStream == null) {
                    ConfigurationManager.getInstance().load((ConfigurationHandler)new XMLFileHandler(USER_CONFIG_FILE), USER_CONFIG_KEY);
                } else {
                    ConfigurationManager.getInstance().load((ConfigurationHandler)userConfigStream, USER_CONFIG_KEY);
                }
                UserConfig = ConfigurationManager.getConfiguration((String)USER_CONFIG_KEY);
            }
            catch (ConfigurationManagerException e) {
                UserConfig = null;
                throw e;
            }
        }
        return UserConfig;
    }

    public static String getProperty(String category, String propertyKey) {
        return CDXPropertyManager.getProperty(category, propertyKey, null);
    }

    public static Map getAllProperties(String category) {
        int i;
        String[] userProps = null;
        String[] globalProps = null;
        Configuration userConfig = null;
        Configuration globalConfig = null;
        try {
            userConfig = CDXPropertyManager.getUserConfig();
            userProps = userConfig.getPropertyNames(category);
        }
        catch (Throwable e) {
            log.info("[getAllProperties] Category '" + category + "' was  not found in the User config file.");
        }
        try {
            globalConfig = CDXPropertyManager.getGlobalConfig();
            if (globalConfig != null) {
                globalProps = globalConfig.getPropertyNames(category);
            }
        }
        catch (Throwable e) {
            log.warn("[getAllProperties] Category '" + category + "' was  not found in the Global config file.");
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (globalProps != null) {
            for (i = 0; i < globalProps.length; ++i) {
                map.put(globalProps[i], globalConfig.getProperty(globalProps[i], null, category));
            }
        }
        if (userProps != null) {
            for (i = 0; i < userProps.length; ++i) {
                map.put(userProps[i], userConfig.getProperty(userProps[i], null, category));
            }
        }
        return map;
    }

    public static Map getAllUniqueProperties(String category) {
        int i;
        String[] userProps = null;
        String[] globalProps = null;
        Configuration userConfig = null;
        Configuration globalConfig = null;
        try {
            userConfig = CDXPropertyManager.getUserConfig();
            userProps = userConfig.getPropertyNames(category);
        }
        catch (Throwable e) {
            log.info("[getAllProperties] Category '" + category + "' was  not found in the User config file.");
        }
        try {
            globalConfig = CDXPropertyManager.getGlobalConfig();
            if (globalConfig != null) {
                globalProps = globalConfig.getPropertyNames(category);
            }
        }
        catch (Throwable e) {
            log.warn("[getAllProperties] Category '" + category + "' was  not found in the Global config file.");
        }
        HashMap<String, String> map = null;
        if (globalProps != null) {
            map = new HashMap<String, String>();
            for (i = 0; i < globalProps.length; ++i) {
                map.put(globalProps[i], globalConfig.getProperty(globalProps[i], null, category));
            }
        }
        if (userProps != null) {
            map = new HashMap();
            for (i = 0; i < userProps.length; ++i) {
                map.put(userProps[i], userConfig.getProperty(userProps[i], null, category));
            }
        }
        return map;
    }

    public static String getProperty(String category, String propertyKey, String defaultValue) {
        String propertyValue = null;
        if (category == null) {
            category = "global";
        }
        try {
            propertyValue = CDXPropertyManager.getUserConfig().getProperty(propertyKey, null, category);
        }
        catch (Throwable e) {
            // empty catch block
        }
        if (propertyValue == null) {
            try {
                propertyValue = CDXPropertyManager.getGlobalConfig().getProperty(propertyKey, defaultValue, category);
            }
            catch (Throwable e) {
                log.warn("[getProperty] Property key '" + propertyKey + "' was  not found in the Global config file.");
                propertyValue = defaultValue;
            }
        }
        return propertyValue;
    }

    public static String getGlobalProperty(String property, String defaultValue) {
        return CDXPropertyManager.getProperty(null, property, defaultValue);
    }

    public static String getGlobalProperty(String property) {
        return CDXPropertyManager.getProperty(null, property, null);
    }

    public static String getEncryptedProperty(String category, String propertyKey) {
        return CDXPropertyManager.getEncryptedProperty(category, propertyKey, null);
    }

    public static String getEncryptedProperty(String category, String propertyKey, String defaultValue) {
        String value = null;
        value = CDXPropertyManager.getProperty(category, propertyKey, defaultValue);
        if (value != null && value.trim().length() > 0) {
            value = EncoderDecoder.decode(value);
        }
        return value;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        globalConfigStream = null;
        userConfigStream = null;
    }
}

