/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.util;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.FileManager;
import java.io.FileInputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.TimeZone;

public class CDXSystemManager {
    protected static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$util$CDXSystemManager == null ? (class$gov$epa$cdx$commons$util$CDXSystemManager = CDXSystemManager.class$("gov.epa.cdx.commons.util.CDXSystemManager")) : class$gov$epa$cdx$commons$util$CDXSystemManager).getName());
    public static final String SERVER_IP_KEY = "PUBLIC_IP";
    public static final String SERVER_IP_FILE_NAME = "ServerIP.properties";
    private static String publicIP = null;
    static /* synthetic */ Class class$gov$epa$cdx$commons$util$CDXSystemManager;

    public static void restartServer() throws CDXException {
        try {
            Runtime run = Runtime.getRuntime();
            Process process = run.exec("cmd.exe /c start RestartWeblogic.cmd");
        }
        catch (Exception ex) {
            log.error("", ex);
            throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
        }
    }

    public static String getCurrentServerPrivateIP() throws CDXException {
        String host = "";
        InetAddress address = null;
        try {
            address = InetAddress.getLocalHost();
            host = address.getHostAddress();
            log.debug("getCurrentServerPrivateIP:" + host);
        }
        catch (UnknownHostException ex) {
            log.error("", ex);
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return host;
    }

    public static String getCurrentServerIP() throws CDXException {
        try {
            if (publicIP == null) {
                if (FileManager.isFileExists(SERVER_IP_FILE_NAME)) {
                    FileInputStream in = new FileInputStream(SERVER_IP_FILE_NAME);
                    Properties prop = new Properties();
                    prop.load(in);
                    publicIP = prop.getProperty(SERVER_IP_KEY);
                    log.debug("getPublicServerIP:" + publicIP);
                } else {
                    publicIP = CDXSystemManager.getCurrentServerPrivateIP();
                    log.debug("getPublicServerIP: couldn't found file. Try to retrieve private IP:" + publicIP);
                }
            }
        }
        catch (Exception ex) {
            log.error("", ex);
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return publicIP;
    }

    public static String getServerIPByName(String name) throws CDXException {
        String host = "";
        InetAddress address = null;
        try {
            address = InetAddress.getByName(name);
            host = address.getHostAddress();
        }
        catch (UnknownHostException ex) {
            log.error("", ex);
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return host;
    }

    public static String getServerIPsByName(String name) throws CDXException {
        String host = "";
        InetAddress[] address = null;
        try {
            address = InetAddress.getAllByName(name);
            for (int i = 0; i < address.length; ++i) {
                host = address[i].getHostAddress();
            }
        }
        catch (UnknownHostException ex) {
            log.error("", ex);
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return host;
    }

    public static String getCurrentTime(String format) throws CDXException {
        Date today = new Date();
        SimpleDateFormat formatter = new SimpleDateFormat(format);
        formatter.setTimeZone(TimeZone.getTimeZone("EST"));
        String datenewformat = formatter.format(today);
        return datenewformat;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

