/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.util;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.spec.InvalidKeySpecException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CipherEngine {
    public static Map getSecurityProviders() {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Provider[] providers = Security.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            Provider provider = providers[i];
            Set<Map.Entry<Object, Object>> entries = provider.entrySet();
            String providerName = provider.getName();
            String providerInfo = provider.getInfo();
            result.put(providerName, providerInfo);
            result.put("Entries", entries);
        }
        return result;
    }

    public static Map getSecurityProvider(String aProvider) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Provider provider = Security.getProvider(aProvider);
        Set<Map.Entry<Object, Object>> entries = provider.entrySet();
        String providerName = provider.getName();
        String providerInfo = provider.getInfo();
        result.put(providerName, providerInfo);
        result.put("Entries", entries);
        return result;
    }

    public static Map encryptGenerateKey(String data, String algorithm) {
        HashMap<String, String> encryptedData = new HashMap<String, String>();
        String encryptedString = null;
        try {
            SecureRandom random = new SecureRandom();
            KeyGenerator keygen = KeyGenerator.getInstance(algorithm);
            keygen.init(random);
            SecretKey secretKey = keygen.generateKey();
            byte[] keyByte = secretKey.getEncoded();
            encryptedData.put("key", CipherEngine.getString(keyByte));
            Cipher ecipher = Cipher.getInstance(algorithm);
            ecipher.init(1, secretKey);
            byte[] utf8 = data.getBytes("UTF8");
            byte[] enc = ecipher.doFinal(utf8);
            encryptedString = new BASE64Encoder().encode(enc);
            encryptedData.put("data", encryptedString);
            return encryptedData;
        }
        catch (BadPaddingException e) {
        }
        catch (IllegalBlockSizeException e) {
        }
        catch (IOException e) {
        }
        catch (NoSuchAlgorithmException e) {
        }
        catch (InvalidKeyException e) {
        }
        catch (NoSuchPaddingException e) {
            // empty catch block
        }
        return null;
    }

    public static Map encryptWithKey(String strKey, String data, String algorithm) {
        HashMap<String, String> encryptedData = new HashMap<String, String>();
        String encryptedString = null;
        try {
            Key aKey = CipherEngine.makeKey(strKey, algorithm);
            Cipher ecipher = Cipher.getInstance(algorithm);
            ecipher.init(1, aKey);
            byte[] utf8 = data.getBytes("UTF8");
            byte[] enc = ecipher.doFinal(utf8);
            encryptedString = new BASE64Encoder().encode(enc);
            encryptedData.put("data", encryptedString);
            encryptedData.put("key", strKey);
            return encryptedData;
        }
        catch (BadPaddingException e) {
            System.err.println(e);
        }
        catch (IllegalBlockSizeException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e);
        }
        catch (InvalidKeyException e) {
            System.err.println(e);
        }
        catch (NoSuchPaddingException e) {
            System.err.println(e);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return null;
    }

    private static Key getKey(String key, String algorithm) {
        byte[] keyBytes = new byte[]{};
        SecretKey secretKey = null;
        try {
            keyBytes = new BASE64Decoder().decodeBuffer(key);
            DESKeySpec desKeySpec = new DESKeySpec(keyBytes);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(algorithm);
            secretKey = secretKeyFactory.generateSecret(desKeySpec);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return secretKey;
    }

    private static Key makeKey(String key, String algorithm) {
        SecretKey deskey = null;
        try {
            DESedeKeySpec keySpec = new DESedeKeySpec(key.getBytes());
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            deskey = keyFactory.generateSecret(keySpec);
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (InvalidKeySpecException e) {
            e.printStackTrace();
        }
        return deskey;
    }

    public static String decrypt(String key, String data, String algorithm) {
        try {
            SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(algorithm);
            DESedeKeySpec keySpec = new DESedeKeySpec(key.getBytes());
            SecretKey deskey = keyFactory.generateSecret(keySpec);
            Cipher dcipher = Cipher.getInstance(algorithm);
            dcipher.init(2, deskey);
            byte[] dec = new BASE64Decoder().decodeBuffer(data);
            byte[] utf8 = dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (BadPaddingException e) {
            System.err.println(e);
        }
        catch (IllegalBlockSizeException e) {
            System.err.println(e);
        }
        catch (UnsupportedEncodingException e) {
            System.err.println(e);
        }
        catch (IOException e) {
            System.err.println(e);
        }
        catch (NoSuchAlgorithmException e) {
            System.err.println(e);
        }
        catch (NoSuchPaddingException e) {
            System.err.println(e);
        }
        catch (InvalidKeyException e) {
            System.err.println(e);
        }
        catch (Exception e) {
            System.err.println(e);
        }
        return null;
    }

    public static String byteToHexStr(byte[] data) {
        if (data == null || data.length == 0) {
            return new String("");
        }
        StringBuffer sb = new StringBuffer(2 * data.length);
        for (int i = 0; i < data.length; i = (int)((short)(i + 1))) {
            CipherEngine.appendBytes(sb, data[i]);
        }
        return sb.toString();
    }

    public static String hexStrToString(String str) {
        if (str == null || str.length() == 0) {
            return new String("");
        }
        int len = str.length() >> 1;
        StringBuffer sb = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            sb.append((char)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16));
        }
        return sb.toString();
    }

    private static void appendBytes(StringBuffer stringBuffer, byte int8) {
        stringBuffer.append(Character.forDigit(int8 >> 4 & 0xF, 16));
        stringBuffer.append(Character.forDigit(int8 & 0xF, 16));
    }

    public static byte[] hexStrToByte(String str) {
        if (str == null || str.length() == 0) {
            return new byte[0];
        }
        int len = str.length() >> 1;
        byte[] data = new byte[len];
        for (int i = 0; i < len; ++i) {
            data[i] = (byte)Integer.parseInt(str.substring(i * 2, i * 2 + 2), 16);
        }
        return data;
    }

    public static String getString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }
}

