/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.util;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXSecurityException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.CDXFilesList;
import java.io.File;
import java.io.IOException;
import java.util.TreeMap;

public class FileManager {
    protected static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$util$FileManager == null ? (class$gov$epa$cdx$commons$util$FileManager = FileManager.class$("gov.epa.cdx.commons.util.FileManager")) : class$gov$epa$cdx$commons$util$FileManager).getName());
    public static final String DOCUMENT_STATUS_FILE_PREFIX = "DocumentStatus_";
    public static final String TRANSACTION_STATUS_FILE_PREFIX = "TransactionStatus_";
    static /* synthetic */ Class class$gov$epa$cdx$commons$util$FileManager;

    public static File createDirectory(String dirName) throws CDXException {
        boolean success = false;
        File dirObject = null;
        try {
            dirObject = new File(dirName);
            success = dirObject.exists() ? dirObject.canWrite() : dirObject.mkdirs();
        }
        catch (SecurityException sEx) {
            log.error("Couldn't open or create Directory:" + dirName, sEx);
            throw new CDXSecurityException(CDXErrorCode.LACK_OF_PRIVILEGE, (Throwable)sEx);
        }
        if (success) {
            return dirObject;
        }
        throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Couldn't open or create Directory:" + dirName));
    }

    public static File createFile(File dirObject, String fileName) throws CDXException {
        boolean success = false;
        File fileObject = null;
        try {
            fileObject = new File(dirObject, fileName);
            success = fileObject.exists() ? fileObject.canWrite() : fileObject.createNewFile();
        }
        catch (SecurityException sEx) {
            log.error("Couldn't open or create File:" + fileObject.getPath(), sEx);
            throw new CDXSecurityException(CDXErrorCode.LACK_OF_PRIVILEGE, (Throwable)sEx);
        }
        catch (IOException ioEx) {
            log.error("Couldn't create File:" + fileObject.getPath(), ioEx);
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Couldn't create File:" + fileObject.getPath()));
        }
        if (success) {
            return fileObject;
        }
        throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Couldn't open or create File:" + fileObject.getPath()));
    }

    public static boolean isFileExists(String fileName) throws CDXException {
        boolean success = false;
        File fileObject = null;
        try {
            fileObject = new File(fileName);
            success = fileObject.exists();
        }
        catch (SecurityException sEx) {
            log.error("Couldn't open or create File:" + fileObject.getPath(), sEx);
            throw new CDXSecurityException(CDXErrorCode.LACK_OF_PRIVILEGE, (Throwable)sEx);
        }
        return success;
    }

    public static CDXFilesList getFilesListFromCurrentDirectory() throws CDXException {
        return FileManager.getFilesListFromDirectory(System.getProperty("user.dir"));
    }

    public static CDXFilesList getFilesListFromDirectory(String dirName) throws CDXException {
        CDXFilesList filesList = null;
        TreeMap<String, File> fileList = new TreeMap<String, File>();
        TreeMap<String, File> dirList = new TreeMap<String, File>();
        try {
            File dirObject = new File(dirName);
            if (dirObject == null) {
                throw new CDXServerException(CDXErrorCode.NULL_VALUE_EXCEPTION);
            }
            File[] files = dirObject.listFiles();
            File file = null;
            for (int i = 0; i < files.length; ++i) {
                file = files[i];
                if (file.isDirectory()) {
                    dirList.put(file.getName().toLowerCase(), file);
                }
                if (!file.isFile()) continue;
                fileList.put(file.getName().toLowerCase(), file);
            }
            filesList = new CDXFilesList(dirObject.getPath(), dirList.values(), fileList.values());
        }
        catch (SecurityException sEx) {
            log.error("Couldn't open or create Folder:" + dirName, sEx);
            throw new CDXSecurityException(CDXErrorCode.LACK_OF_PRIVILEGE, (Throwable)sEx);
        }
        catch (CDXException cdxEx) {
            throw cdxEx;
        }
        return filesList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

