/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.util;

import gov.epa.cdx.commons.util.tools.codec.Base64Decoder;
import gov.epa.cdx.commons.util.tools.codec.Base64Encoder;
import gov.epa.cdx.commons.util.tools.codec.Base64FormatException;
import java.net.InetAddress;
import org.doomdark.uuid.UUIDGenerator;

public final class GUID {
    public static final String SYSTEM_GUID_TYPE_KEY = "system_guid_type_key";
    public static final String SYSTEM_GUID_TYPE_BASE64 = "0";
    public static final String SYSTEM_GUID_TYPE_NUMBER = "1";
    public static final String SYSTEM_GUID_TYPE_UUID = "2";
    public static final String SYSTEM_GUID_TYPE_DEFAULT = "2";
    private static InetAddress ia = null;
    private static String sHostAddress = "";
    private static UUIDGenerator uuidGen = null;

    public static synchronized String getGUID() {
        String encType = System.getProperty(SYSTEM_GUID_TYPE_KEY, "2");
        if (encType.equalsIgnoreCase(SYSTEM_GUID_TYPE_NUMBER)) {
            return GUID.getNumberEncoderGUID();
        }
        if (encType.equalsIgnoreCase(SYSTEM_GUID_TYPE_BASE64)) {
            return GUID.getBASE64EncoderGUID();
        }
        return GUID.getUUID();
    }

    public static synchronized String getUUID() {
        if (uuidGen == null) {
            uuidGen = UUIDGenerator.getInstance();
        }
        return uuidGen.generateRandomBasedUUID().toString();
    }

    public static synchronized String getNumberEncoderGUID() {
        StringBuffer sGUID = new StringBuffer();
        String s = GUID.getStringGUID();
        for (int i = 0; i < s.length(); ++i) {
            sGUID.append(Character.getNumericValue(s.charAt(i)));
        }
        return sGUID.toString();
    }

    public static synchronized String getStringGUID() {
        StringBuffer sGUID = new StringBuffer();
        if (ia == null) {
            try {
                ia = InetAddress.getLocalHost();
                sHostAddress = ia.toString();
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        sGUID.append(sHostAddress + "/");
        sGUID.append(System.currentTimeMillis() + "/");
        sGUID.append(Math.random());
        return sGUID.toString();
    }

    public static synchronized String getBASE64EncoderGUID() {
        String sGUID = "";
        String s = GUID.getStringGUID();
        Base64Encoder enc = new Base64Encoder(s);
        sGUID = enc.processString();
        return sGUID;
    }

    public static synchronized String getBASE64DecodedGUID(String inGUID) {
        String sGUID = "";
        Base64Decoder dec = new Base64Decoder(inGUID);
        try {
            sGUID = dec.processString();
        }
        catch (Base64FormatException ex) {
            ex.printStackTrace();
        }
        return sGUID;
    }
}

