/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.util;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLBytesConverter {
    public static Document ToW3CDocument(byte[] byteArray) throws CDXException {
        try {
            return DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new ByteArrayInputStream(byteArray));
        }
        catch (Exception e) {
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
        }
    }

    public static Element ToDOM(byte[] byteArray) throws CDXException {
        return XMLBytesConverter.ToW3CDocument(byteArray).getDocumentElement();
    }

    public static byte[] ToByteArray(Node data) throws CDXException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(data), new StreamResult(out));
        }
        catch (TransformerException ex) {
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return out.toByteArray().length == 0 ? null : out.toByteArray();
    }
}

