/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.util;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.ZipVO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class ZipManager {
    protected static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$util$ZipManager == null ? (class$gov$epa$cdx$commons$util$ZipManager = ZipManager.class$("gov.epa.cdx.commons.util.ZipManager")) : class$gov$epa$cdx$commons$util$ZipManager).getName());
    static /* synthetic */ Class class$gov$epa$cdx$commons$util$ZipManager;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipFiles(Vector documents, String fullySpecifiedZIPfileName) throws CDXException {
        log.info("Zipping <" + String.valueOf(documents.size()) + " file(s)> and storing in: " + fullySpecifiedZIPfileName);
        ZipOutputStream out = null;
        BufferedInputStream origin = null;
        try {
            try {
                FileOutputStream dest = new FileOutputStream(fullySpecifiedZIPfileName);
                out = new ZipOutputStream(new BufferedOutputStream(dest));
                for (int documentIndex = 0; documentIndex < documents.size(); ++documentIndex) {
                    int count;
                    ZipVO document = (ZipVO)documents.get(documentIndex);
                    byte[] content = document.getData();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(content);
                    int sizeOfDocument = content.length;
                    origin = new BufferedInputStream(byteArrayInputStream, sizeOfDocument);
                    ZipEntry entry = new ZipEntry(document.getName());
                    out.putNextEntry(entry);
                    while ((count = origin.read(content, 0, sizeOfDocument)) != -1) {
                        out.write(content, 0, count);
                    }
                }
                Object var13_13 = null;
            }
            catch (Throwable e) {
                log.error("Document zipping failed for: " + fullySpecifiedZIPfileName, e);
                throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_ZIPPED, e);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (origin != null) {
                    origin.close();
                }
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (Exception ex) {
                log.error("Document zipping failed for: " + fullySpecifiedZIPfileName, ex);
                throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_ZIPPED, (Throwable)ex);
            }
        }
        try {}
        catch (Exception ex) {
            log.error("Document zipping failed for: " + fullySpecifiedZIPfileName, ex);
            throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_ZIPPED, (Throwable)ex);
        }
        if (origin != null) {
            origin.close();
        }
        if (out == null) return;
        out.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void zipFile(byte[] document, String fullySpecifiedZIPfileName, String xmlFileName) throws CDXException {
        log.info("Zipping " + xmlFileName + " (" + String.valueOf(document.length) + " Bytes) and storing in: " + fullySpecifiedZIPfileName);
        ZipOutputStream out = null;
        BufferedInputStream origin = null;
        try {
            try {
                int count;
                FileOutputStream dest = new FileOutputStream(fullySpecifiedZIPfileName);
                out = new ZipOutputStream(new BufferedOutputStream(dest));
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(document);
                int sizeOfDocument = document.length;
                origin = new BufferedInputStream(byteArrayInputStream, sizeOfDocument);
                ZipEntry entry = new ZipEntry(xmlFileName);
                out.putNextEntry(entry);
                while ((count = origin.read(document, 0, sizeOfDocument)) != -1) {
                    out.write(document, 0, count);
                }
                Object var11_11 = null;
            }
            catch (Throwable e) {
                log.error("Document zipping failed for: " + fullySpecifiedZIPfileName, e);
                throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_ZIPPED, e);
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            try {
                if (origin != null) {
                    origin.close();
                }
                if (out == null) throw throwable;
                out.close();
                throw throwable;
            }
            catch (Exception ex) {
                log.error("Document zipping failed for: " + fullySpecifiedZIPfileName, ex);
                throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_ZIPPED, (Throwable)ex);
            }
        }
        try {}
        catch (Exception ex) {
            log.error("Document zipping failed for: " + fullySpecifiedZIPfileName, ex);
            throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_ZIPPED, (Throwable)ex);
        }
        if (origin != null) {
            origin.close();
        }
        if (out == null) return;
        out.close();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] unzipFile(String fullySpecifiedFileName) throws CDXException {
        log.info("Unzipping " + fullySpecifiedFileName);
        byte[] document = null;
        BufferedInputStream entryBufferedInput = null;
        FilterOutputStream fileOut = null;
        ZipFile zf = null;
        File file = new File(fullySpecifiedFileName);
        try {
            try {
                zf = new ZipFile(file);
                Enumeration<? extends ZipEntry> enumeration = zf.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry nextZE = enumeration.nextElement();
                    entryBufferedInput = new BufferedInputStream(zf.getInputStream(nextZE));
                    int streamSize = (int)nextZE.getSize();
                    document = new byte[streamSize];
                    log.info("Retrieving XML from " + fullySpecifiedFileName + " (" + streamSize + " Bytes)");
                    entryBufferedInput.read(document);
                    String nextFileName = nextZE.getName();
                    if (nextFileName.indexOf("\\") != -1) {
                        File nextFileDirStructure = new File(nextFileName.substring(0, nextFileName.lastIndexOf("\\")));
                        nextFileDirStructure.mkdirs();
                    }
                    fileOut = new BufferedOutputStream(new FileOutputStream(nextFileName));
                    fileOut.write(document);
                }
                Object var12_12 = null;
            }
            catch (Throwable e) {
                log.error("Document unzipping failed for: " + fullySpecifiedFileName, e);
                throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_UNZIPPED, e);
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            try {
                if (entryBufferedInput != null) {
                    entryBufferedInput.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
                if (zf == null) throw throwable;
                zf.close();
                throw throwable;
            }
            catch (Exception ex) {
                log.error("Document unzipping failed for: " + fullySpecifiedFileName, ex);
                throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_UNZIPPED, (Throwable)ex);
            }
        }
        try {}
        catch (Exception ex) {
            log.error("Document unzipping failed for: " + fullySpecifiedFileName, ex);
            throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_UNZIPPED, (Throwable)ex);
        }
        if (entryBufferedInput != null) {
            entryBufferedInput.close();
        }
        if (fileOut != null) {
            fileOut.close();
        }
        if (zf == null) return document;
        zf.close();
        return document;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Vector unzipFiles(String fullySpecifiedFileName) throws CDXException {
        log.info("Unzipping " + fullySpecifiedFileName);
        Vector<ZipVO> documentList = new Vector<ZipVO>();
        File file = new File(fullySpecifiedFileName);
        ZipFile zf = null;
        BufferedInputStream entryBufferedInput = null;
        FilterOutputStream fileOut = null;
        try {
            try {
                zf = new ZipFile(file);
                Enumeration<? extends ZipEntry> enumeration = zf.entries();
                while (enumeration.hasMoreElements()) {
                    ZipEntry nextZE = enumeration.nextElement();
                    entryBufferedInput = new BufferedInputStream(zf.getInputStream(nextZE));
                    int streamSize = (int)nextZE.getSize();
                    byte[] document = new byte[streamSize];
                    log.info("Retrieving XML from " + fullySpecifiedFileName + " (" + streamSize + " Bytes)");
                    entryBufferedInput.read(document);
                    String nextFileName = nextZE.getName();
                    if (nextFileName.indexOf("\\") != -1) {
                        File nextFileDirStructure = new File(nextFileName.substring(0, nextFileName.lastIndexOf("\\")));
                        nextFileDirStructure.mkdirs();
                    }
                    fileOut = new BufferedOutputStream(new FileOutputStream(nextFileName));
                    fileOut.write(document);
                    documentList.add(new ZipVO(nextFileName, document));
                }
                Object var13_13 = null;
            }
            catch (Throwable e) {
                log.error("Document unzipping failed for: " + fullySpecifiedFileName, e);
                throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_UNZIPPED, e);
            }
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            try {
                if (entryBufferedInput != null) {
                    entryBufferedInput.close();
                }
                if (fileOut != null) {
                    fileOut.close();
                }
                if (zf == null) throw throwable;
                zf.close();
                throw throwable;
            }
            catch (Exception ex) {
                log.error("Document unzipping failed for: " + fullySpecifiedFileName, ex);
                throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_UNZIPPED, (Throwable)ex);
            }
        }
        try {}
        catch (Exception ex) {
            log.error("Document unzipping failed for: " + fullySpecifiedFileName, ex);
            throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_UNZIPPED, (Throwable)ex);
        }
        if (entryBufferedInput != null) {
            entryBufferedInput.close();
        }
        if (fileOut != null) {
            fileOut.close();
        }
        if (zf == null) return documentList;
        zf.close();
        return documentList;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

