/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.util.net;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXExternalServerException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Iterator;
import java.util.Map;

public class URLUtils {
    public static URL createGetURL(String baseURL, Map requestParameters) throws CDXException {
        StringBuffer buffer = new StringBuffer(baseURL);
        buffer.append('?');
        Iterator it = requestParameters.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            String value = (String)requestParameters.get(key);
            String encodedKey = URLEncoder.encode(key);
            String encodedValue = URLEncoder.encode(value);
            buffer.append(encodedKey);
            buffer.append('=');
            buffer.append(encodedValue);
            if (!it.hasNext()) continue;
            buffer.append('&');
        }
        URL url = null;
        try {
            url = new URL(buffer.toString());
        }
        catch (MalformedURLException badURLException) {
            throw new CDXException(CDXErrorCode.HTTP_URL_ERROR, (Throwable)badURLException);
        }
        return url;
    }

    public static String performGet(HttpURLConnection connection) throws CDXException {
        String line = null;
        StringBuffer out = new StringBuffer();
        try {
            connection.connect();
            BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
            while ((line = in.readLine()) != null) {
                out.append(line);
            }
            in.close();
            connection.disconnect();
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.HTTP_CONNECTION_FAILURE, (Throwable)ex);
        }
        return out.toString();
    }

    public static URL getURL(String inURL) throws CDXException {
        URL portURL = null;
        try {
            portURL = new URL(inURL);
        }
        catch (MalformedURLException ex) {
            throw new CDXExternalServerException(CDXErrorCode.HTTP_URL_ERROR, (Throwable)ex);
        }
        try {
            HttpURLConnection con = (HttpURLConnection)portURL.openConnection();
            con.connect();
            con.disconnect();
        }
        catch (Exception ex) {
            throw new CDXExternalServerException(CDXErrorCode.HTTP_CONNECTION_FAILURE, (Throwable)ex);
        }
        return portURL;
    }
}

