/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.util.tools;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.StringTokenizer;

public class Caller {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");
    private static StringWriter sw = new StringWriter();
    private static PrintWriter pw = new PrintWriter(sw);
    private static String ourFqn;
    private String callingClassFQN;

    public Caller(String fqcn) {
        this.callingClassFQN = fqcn;
    }

    private Caller() {
    }

    public String getClassName() {
        String[] trace = this.getStackTrace();
        int firstOccurenceOfcallingClassFQN = 0;
        for (int i = 0; i < trace.length; ++i) {
            if (!trace[i].startsWith(this.callingClassFQN)) continue;
            firstOccurenceOfcallingClassFQN = i;
        }
        String name = trace[firstOccurenceOfcallingClassFQN];
        StringTokenizer tok = new StringTokenizer(name, ".");
        int tokenCount = tok.countTokens() - 1;
        String token = null;
        for (int i = 0; i < tokenCount; ++i) {
            token = tok.nextToken();
        }
        return token;
    }

    public String getMethodName() {
        String[] trace = this.getStackTrace();
        int firstOccurenceOfcallingClassFQN = 0;
        for (int i = 0; i < trace.length; ++i) {
            if (!trace[i].startsWith(this.callingClassFQN)) continue;
            firstOccurenceOfcallingClassFQN = i;
        }
        String name = trace[firstOccurenceOfcallingClassFQN];
        StringTokenizer tok = new StringTokenizer(name, ".");
        int tokenCount = tok.countTokens();
        String token = null;
        for (int i = 0; i < tokenCount; ++i) {
            token = tok.nextToken();
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getStackTrace() {
        String s;
        StringWriter stringWriter = sw;
        synchronized (stringWriter) {
            Throwable t = new Throwable();
            t.printStackTrace(pw);
            s = sw.toString();
            sw.getBuffer().setLength(0);
        }
        StringTokenizer stk = new StringTokenizer(s, LINE_SEPARATOR);
        if (stk.countTokens() < 3) {
            return new String[0];
        }
        stk.nextToken();
        while (stk.hasMoreTokens() && !this.parseFqn(s = stk.nextToken()).equals(ourFqn)) {
        }
        int level = 0;
        String[] stack = new String[stk.countTokens()];
        while (stk.hasMoreTokens()) {
            s = stk.nextToken();
            stack[level] = this.parseFqn(s);
            ++level;
        }
        return stack;
    }

    private String parseFqn(String s) {
        int start = s.indexOf("at") + 3;
        int end = s.indexOf("(", start);
        return s.substring(start, end);
    }

    public static void printTrace() {
        Caller c = new Caller();
        String[] stack = c.getStackTrace();
        for (int i = 0; i < stack.length; ++i) {
            System.out.println(stack[i]);
        }
    }

    static {
        Class<?> c = new Caller().getClass();
        ourFqn = c.getName() + ".getStackTrace";
    }
}

