/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.commons.zip;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;

public class ZipUtil {
    protected static LogInterface log = LogFactory.getLog((class$gov$epa$cdx$commons$zip$ZipUtil == null ? (class$gov$epa$cdx$commons$zip$ZipUtil = ZipUtil.class$("gov.epa.cdx.commons.zip.ZipUtil")) : class$gov$epa$cdx$commons$zip$ZipUtil).getName());
    static /* synthetic */ Class class$gov$epa$cdx$commons$zip$ZipUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzip(File zipFile, File destinationPath) {
        ZipFile zip = null;
        try {
            ZipEntry entry;
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> enumeration = zip.entries();
            while (enumeration.hasMoreElements()) {
                entry = enumeration.nextElement();
                if (!entry.isDirectory()) continue;
                FileUtils.forceMkdir((File)new File(destinationPath, entry.getName()));
            }
            enumeration = zip.entries();
            while (enumeration.hasMoreElements()) {
                entry = enumeration.nextElement();
                if (entry.isDirectory()) continue;
                File file = new File(destinationPath, entry.getName());
                ZipUtil.unzipZipFileEntry(zip, entry, file);
            }
        }
        catch (Exception e) {
            log.error("Error occured", e);
        }
        finally {
            try {
                zip.close();
            }
            catch (Exception exception) {}
        }
    }

    public static void unzip(File zipFile, File destinationPath, String fileName) throws CDXException {
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
        }
        catch (Exception ex) {
            log.error("Error occured", ex);
            throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        Enumeration<? extends ZipEntry> enumeration = zip.entries();
        if (zip.size() != 1) {
            log.error("Zip has more then one file in it");
            throw new CDXException(CDXErrorCode.INVALID_ZIP_FILE_ENTRIES);
        }
        ZipEntry entry = enumeration.nextElement();
        if (entry.isDirectory()) {
            log.error("Zip has a directory in it");
            throw new CDXException(CDXErrorCode.INVALID_ZIP_FILE_ENTRIES);
        }
        File file = new File(destinationPath, fileName);
        ZipUtil.unzipZipFileEntry(zip, entry, file);
        try {
            zip.close();
        }
        catch (Exception ex) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void unzipZipFileEntry(ZipFile zip, ZipEntry entry, File destinationFile) {
        FileOutputStream stream = null;
        try {
            if (!destinationFile.exists()) {
                destinationFile.createNewFile();
            }
            stream = new FileOutputStream(destinationFile);
            CopyUtils.copy((InputStream)zip.getInputStream(entry), (OutputStream)stream);
        }
        catch (IOException ioException) {
            log.error("Could not unzip the file.", ioException);
        }
        finally {
            try {
                stream.close();
            }
            catch (Exception ex) {}
        }
    }

    public static boolean zip(List documentList, String destinationFile) throws CDXException {
        return ZipUtil.zip(documentList, destinationFile, false);
    }

    public static boolean zip(List documentList, String destinationFile, boolean savePath) throws CDXException {
        boolean success = false;
        ZipOutputStream outputStream = null;
        try {
            outputStream = new ZipOutputStream(new FileOutputStream(destinationFile));
            Iterator iterator = documentList.iterator();
            while (iterator.hasNext()) {
                File inFile = (File)iterator.next();
                ZipEntry zipEntry = new ZipEntry(savePath ? inFile.getPath() : inFile.getName());
                outputStream.putNextEntry(zipEntry);
                FileInputStream fis = new FileInputStream(inFile);
                CopyUtils.copy((InputStream)fis, (OutputStream)outputStream);
                fis.close();
            }
            success = true;
        }
        catch (Exception e) {
            log.fatal("Unable to zip the requested documents into:" + destinationFile + e.getMessage());
            throw (CDXException)e;
        }
        finally {
            try {
                outputStream.close();
            }
            catch (Exception ex) {}
        }
        return success;
    }

    public static Vector zipEntries(File zipFile) throws CDXException {
        Vector<String> entries = new Vector<String>();
        ZipFile zip = null;
        try {
            zip = new ZipFile(zipFile);
            Enumeration<? extends ZipEntry> list = zip.entries();
            while (list.hasMoreElements()) {
                ZipEntry entry = list.nextElement();
                entries.add(entry.getName());
            }
        }
        catch (Exception e) {
            throw new CDXException(CDXErrorCode.DOCUMENT_COULD_NOT_BE_UNZIPPED);
        }
        finally {
            try {
                zip.close();
            }
            catch (Exception ex) {}
        }
        return entries;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

