/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.auditor;

import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.tools.Caller;
import gov.epa.cdx.infrastructure.auditor.AuditManager;
import gov.epa.cdx.model.auditor.ActionStatus;
import gov.epa.cdx.model.auditor.AuditAction;
import gov.epa.cdx.model.auditor.AuditActor;
import gov.epa.cdx.model.auditor.AuditVO;
import gov.epa.cdx.model.security.AuthTokenVO;

public class Audit {
    protected static LogInterface log;
    private AuditActor actor;
    private String fqcn;
    private static final String AUDITOR_CLASS_TO_ACTORS_CATEGORY_KEY = "AuditorClassToActorsMapping";
    private static final String AUDITOR_CATEGORY_KEY = "Auditor";
    public static final String DEFAULT_USER_ID;
    public static final String DEFAULT_IP;
    public static final String DEFAULT_TRANSACTION_ID;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.auditor.Audit");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        DEFAULT_USER_ID = CDXPropertyManager.getProperty((String)AUDITOR_CATEGORY_KEY, (String)"DefaultUserId", (String)"cdxoperator@epa.gov");
        DEFAULT_IP = CDXPropertyManager.getProperty((String)AUDITOR_CATEGORY_KEY, (String)"DefaultIp", (String)"127.0.0.1");
        DEFAULT_TRANSACTION_ID = CDXPropertyManager.getProperty((String)AUDITOR_CATEGORY_KEY, (String)"DefaultTransactionId", (String)"Unknown");
    }

    public Audit(String fqcn) {
        this.fqcn = fqcn;
        String auditorActorName = CDXPropertyManager.getProperty((String)AUDITOR_CLASS_TO_ACTORS_CATEGORY_KEY, (String)fqcn, (String)"Undefined Component");
        this.actor = new AuditActor(auditorActorName);
    }

    public void success(String transactionId, String message) {
        this.success(transactionId, message, null);
    }

    public void failure(String transactionId, String message, Throwable ex) {
        this.failure(transactionId, message, ex, null);
    }

    public void info(String transactionId, String message) {
        this.info(transactionId, message, null);
    }

    public void success(String transactionId, String message, AuthTokenVO auth) {
        AuditVO vo = this.prepareBasicAuditVO(transactionId, message, auth);
        vo.setActionStatus(ActionStatus.getObjectById((String)"success"));
        AuditManager.createAuditEntry(vo);
    }

    public void failure(String transactionId, String message, Throwable ex, AuthTokenVO auth) {
        AuditVO vo = this.prepareBasicAuditVO(transactionId, message, auth);
        vo.setActionStatus(ActionStatus.getObjectById((String)"failure"));
        vo.setErrorDescr(ex);
        AuditManager.createAuditEntry(vo);
    }

    public void info(String transactionId, String message, AuthTokenVO auth) {
        AuditVO vo = this.prepareBasicAuditVO(transactionId, message, auth);
        vo.setActionStatus(ActionStatus.getObjectById((String)"info"));
        AuditManager.createAuditEntry(vo);
    }

    private AuditVO prepareBasicAuditVO(String transactionId, String message, AuthTokenVO auth) {
        AuditVO vo = new AuditVO();
        if (transactionId != null && transactionId.length() > 0) {
            vo.setAuditID(transactionId);
        } else {
            vo.setAuditID(DEFAULT_TRANSACTION_ID);
        }
        vo.setDescription(message);
        vo.setActorName(this.actor);
        vo.setAuditDate(System.currentTimeMillis());
        if (auth != null) {
            if (auth.getUserId() != null) {
                vo.setActorVOID(auth.getUserId());
            } else {
                vo.setActorVOID(DEFAULT_USER_ID);
            }
            if (auth.getClientHostIP() != null) {
                vo.setClientIP(auth.getClientHostIP());
            } else {
                vo.setClientIP(DEFAULT_IP);
            }
        } else {
            vo.setActorVOID(DEFAULT_USER_ID);
            vo.setClientIP(DEFAULT_IP);
        }
        String method = new Caller(this.fqcn).getMethodName();
        vo.setActionID(new AuditAction(method));
        return vo;
    }
}

