/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.auditor;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.jms.JMSManager;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.auditor.dao.AuditDAO;
import gov.epa.cdx.model.auditor.AuditVO;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeSet;

public class AuditManager {
    private static final String QUEUE_NAME = "JMSAuditorQueue";
    protected static LogInterface log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.auditor.AuditManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    private AuditManager() {
    }

    public static void createAuditEntry(AuditVO auditInfo) {
        try {
            JMSManager.sendMessage((String)QUEUE_NAME, (Serializable)auditInfo);
        }
        catch (CDXException ex) {
            log.error((Object)"Problems with sending messages to JMSManager", (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
    }

    public static void saveAuditEntry(AuditVO auditInfo) throws CDXException {
        if (auditInfo == null) {
            throw new CDXValidationException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("AuditInfo couldn't be NULL"));
        }
        AuditDAO.insertAuditInfo(auditInfo);
    }

    public static Collection getAuditInfoList(String auditID) throws CDXException {
        if (auditID == null || auditID.trim().equalsIgnoreCase("")) {
            throw new CDXValidationException(CDXErrorCode.INVALID_AUDIT_ID);
        }
        return AuditDAO.loadAuditInfoList(auditID);
    }

    public static Collection searchByTransaction(String trID) throws CDXException {
        if (trID == null || trID.equals("")) {
            throw new CDXValidationException(CDXErrorCode.NULL_VALUE_EXCEPTION);
        }
        return AuditDAO.loadAuditInfoList(trID);
    }

    public static TreeSet loadAllActorNames() throws CDXException {
        return AuditDAO.loadAllActorNames();
    }

    public static TreeSet loadAllDataflowNames() throws CDXException {
        return AuditDAO.loadAllDataflowNames();
    }

    public static Collection genericSearchByAuditFields(Collection auditIDs, Collection clientIPs, Collection userIDs, Collection actorIDs, Collection actionStatuses, Long startDate, Long endDate) throws CDXException {
        return AuditManager.genericSearchByAuditFields(auditIDs, clientIPs, userIDs, actorIDs, actionStatuses, null, startDate, endDate);
    }

    public static Collection genericSearchByAuditFields(Collection auditIDs, Collection clientIPs, Collection userIDs, Collection actorIDs, Collection actionStatuses, Collection docIDs, Long startDate, Long endDate) throws CDXException {
        return AuditDAO.genericSearchByAuditFields(auditIDs, clientIPs, userIDs, actorIDs, actionStatuses, docIDs, startDate, endDate);
    }

    public static Collection genericSearchByAuditFields(Collection auditIDs, Collection clientIPs, Collection userIDs, Collection dataflows, Collection actorIDs, Collection actionStatuses, Collection docIDs, Long startDate, Long endDate) throws CDXException {
        return AuditDAO.genericSearchByAuditFields(auditIDs, clientIPs, userIDs, dataflows, actorIDs, actionStatuses, docIDs, startDate, endDate);
    }

    public static void convertToFile(String auditID) {
    }
}

