/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.auditor;

import gov.epa.cdx.commons.exception.CDXDBRestoredException;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.auditor.AuditManager;
import gov.epa.cdx.model.auditor.AuditVO;
import gov.epa.cdx.model.security.AuthTokenVO;
import java.util.Collection;
import junit.framework.Assert;
import junit.framework.TestCase;

public class AuditTest
extends TestCase {
    public AuditTest(String s) {
        super(s);
    }

    public void testSuccess() {
        String USERID = "cdx@csc.com";
        String IP = "123.123.123.123";
        String UID = GUID.getGUID();
        String MESSAGE = "message";
        Audit audit = new Audit("gov.epa.dataflow.distributor.FRSDistributor");
        AuthTokenVO vo = new AuthTokenVO();
        vo.setUserId(USERID);
        vo.setClientIP(IP);
        audit.success(UID, MESSAGE, vo);
        Collection col = null;
        try {
            col = AuditManager.getAuditInfoList(UID);
        }
        catch (Exception exception) {
            Assert.fail((String)"Couldnt not retrieve audit");
        }
        Object[] array = col.toArray();
        AuditVO auditFromDb = (AuditVO)array[0];
        Assert.assertEquals((String)"Actor Name", (String)auditFromDb.getActorName().toString(), (String)"FRS Distributor");
        Assert.assertEquals((String)"Action Status", (String)auditFromDb.getActionStatus().toString(), (String)"SUCCESS");
        Assert.assertEquals((String)"Transaction Id", (String)auditFromDb.getAuditID(), (String)UID);
        Assert.assertEquals((String)"User id", (String)auditFromDb.getActorVOID(), (String)USERID);
        Assert.assertEquals((String)"Message", (String)auditFromDb.getDescription(), (String)MESSAGE);
        Assert.assertEquals((String)"Ip", (String)auditFromDb.getClientIP(), (String)IP);
    }

    public void testSuccessMultiple() {
        String USERID = "cdx@csc.com";
        String IP = "123.123.123.123";
        String UID = GUID.getGUID();
        String MESSAGE = "message";
        Audit audit = new Audit("gov.epa.dataflow.distributor.FRSDistributor");
        AuthTokenVO vo = new AuthTokenVO();
        vo.setUserId(USERID);
        vo.setClientIP(IP);
        audit.success(UID, MESSAGE, vo);
        audit.success(UID, String.valueOf(MESSAGE) + "2", vo);
        Collection col = null;
        try {
            col = AuditManager.getAuditInfoList(UID);
        }
        catch (Exception exception) {
            Assert.fail((String)"Couldnt not retrieve audit");
        }
        int size = col.size();
        Assert.assertEquals((String)"Number of auditVo objects", (int)2, (int)size);
    }

    public void testFailure() {
        String USERID = "cdx@csc.com";
        String IP = "123.123.123.123";
        String UID = GUID.getGUID();
        String MESSAGE = "message";
        Exception EXCEPTION = new Exception("test");
        Audit audit = new Audit("gov.epa.dataflow.distributor.FRSDistributor");
        AuthTokenVO vo = new AuthTokenVO();
        vo.setUserId(USERID);
        vo.setClientIP(IP);
        audit.failure(UID, MESSAGE, EXCEPTION, vo);
        Collection col = null;
        try {
            col = AuditManager.getAuditInfoList(UID);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Assert.fail((String)"Couldnt not retrieve audit");
        }
        Object[] array = col.toArray();
        AuditVO auditFromDb = (AuditVO)array[0];
        Assert.assertEquals((String)"Actor Name", (String)auditFromDb.getActorName().toString(), (String)"FRS Distributor");
        Assert.assertEquals((String)"Action Status", (String)auditFromDb.getActionStatus().toString(), (String)"FAILURE");
        Assert.assertEquals((String)"Transaction Id", (String)auditFromDb.getAuditID(), (String)UID);
        Assert.assertEquals((String)"User id", (String)auditFromDb.getActorVOID(), (String)USERID);
        Assert.assertEquals((String)"Message", (String)auditFromDb.getDescription(), (String)MESSAGE);
        Assert.assertEquals((String)"Ip", (String)auditFromDb.getClientIP(), (String)IP);
        CDXDBRestoredException restoredEx = (CDXDBRestoredException)auditFromDb.getErrorDescr();
        Assert.assertNotNull((Object)restoredEx.getStoredPrintStack());
    }

    public void testInfo() {
        String USERID = "cdx";
        String IP = "127.0.0.1";
        String UID = GUID.getGUID();
        String MESSAGE = "message";
        Audit audit = new Audit("gov.epa.dataflow.distributor.FRSDistributor");
        audit.info(UID, MESSAGE);
        Collection col = null;
        try {
            col = AuditManager.getAuditInfoList(UID);
        }
        catch (Exception exception) {
            Assert.fail((String)"Couldnt not retrieve audit");
        }
        Object[] array = col.toArray();
        AuditVO auditFromDb = (AuditVO)array[0];
        Assert.assertEquals((String)"Actor Name", (String)auditFromDb.getActorName().toString(), (String)"FRS Distributor");
        Assert.assertEquals((String)"Action Status", (String)auditFromDb.getActionStatus().toString(), (String)"SUCCESS");
        Assert.assertEquals((String)"Transaction Id", (String)auditFromDb.getAuditID(), (String)UID);
        Assert.assertEquals((String)"User id", (String)auditFromDb.getActorVOID(), (String)USERID);
        Assert.assertEquals((String)"Message", (String)auditFromDb.getDescription(), (String)MESSAGE);
        Assert.assertEquals((String)"Ip", (String)auditFromDb.getClientIP(), (String)IP);
    }
}

