/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.auditor.dao;

import gov.epa.cdx.commons.basedao.dao.BaseDAO;
import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXDBRestoredException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.dataflow.DataflowTypeManager;
import gov.epa.cdx.infrastructure.document.dao.DocumentDAO;
import gov.epa.cdx.model.auditor.ActionStatus;
import gov.epa.cdx.model.auditor.AuditAction;
import gov.epa.cdx.model.auditor.AuditActor;
import gov.epa.cdx.model.auditor.AuditVO;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;

public class AuditDAO {
    protected static LogInterface log;
    public static final String TABLE_NAME = "CDX_AUDIT_EVENTS";
    public static final String FIELD_AUDIT_ID = "AUDIT_ID";
    public static final String FIELD_USER_ID = "VALUE_OBJECT_ID";
    public static final String FIELD_CLIENT_IP_TX = "CLIENT_IP_TX";
    public static final String FIELD_PROCESS_ID = "PROCESS_ID";
    public static final String FIELD_PROCESS_STEP_ID = "PROCESS_STEP_ID";
    public static final String FIELD_ACTOR_NAME_TX = "ACTOR_NAME_TX";
    public static final String FIELD_ACTION_ID = "ACTION_ID";
    public static final String FIELD_ACTION_STATUS_ID = "ACTION_STATUS_ID";
    public static final String FIELD_VALUE_OBJECT_ID = "VALUE_OBJECT_ID";
    public static final String FIELD_DESCRIPTION_TX = "DESCRIPTION_TX";
    public static final String FIELD_EXCEPTION_TX = "EXCEPTION_TX";
    public static final String FIELD_AUDIT_EVENT_TM = "AUDIT_EVENT_TM";
    public static final String FIELD_AUDIT_EVENT_NUM = "AUDIT_EVENT_NUM";
    private static final Long defaulStartDate;
    private static final String SELECT_SQL_BY_AUDIT_ID = "Select * from CDX_AUDIT_EVENTS where (AUDIT_ID = ?)";
    private static final String INSERT_SQL = "INSERT INTO CDX_AUDIT_EVENTS (AUDIT_ID, CLIENT_IP_TX, PROCESS_ID, PROCESS_STEP_ID, ACTOR_NAME_TX, ACTION_ID, ACTION_STATUS_ID, VALUE_OBJECT_ID, DESCRIPTION_TX, EXCEPTION_TX, AUDIT_EVENT_TM ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static String DELETE_SQL_BY_AUDIT_ID;
    private static String ORDER_BY_TIME;
    private static String SELECT_ACTOR_NAMES;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.auditor.dao.AuditDAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        defaulStartDate = new Long(946702800000L);
        DELETE_SQL_BY_AUDIT_ID = "Delete * FROM CDX_AUDIT_EVENTS WHERE AUDIT_ID=?";
        ORDER_BY_TIME = " Order By AUDIT_EVENT_TM";
        SELECT_ACTOR_NAMES = "select distinct ACTOR_NAME_TX from CDX_AUDIT_EVENTS order by 1";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insertAuditInfo(AuditVO auditInfo) throws CDXException {
        block23: {
            con = null;
            pstmtAudit = null;
            maxSize = 3990;
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtAudit = con.prepareStatement("INSERT INTO CDX_AUDIT_EVENTS (AUDIT_ID, CLIENT_IP_TX, PROCESS_ID, PROCESS_STEP_ID, ACTOR_NAME_TX, ACTION_ID, ACTION_STATUS_ID, VALUE_OBJECT_ID, DESCRIPTION_TX, EXCEPTION_TX, AUDIT_EVENT_TM ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                    if (auditInfo.getAuditID() != null) {
                        auditInfo.setAuditID(BaseDAO.truncate((String)auditInfo.getAuditID(), (int)100));
                    }
                    pstmtAudit.setString(1, auditInfo.getAuditID());
                    if (auditInfo.getClientIP() != null) {
                        auditInfo.setClientIP(BaseDAO.truncate((String)auditInfo.getClientIP(), (int)15));
                    }
                    pstmtAudit.setString(2, auditInfo.getClientIP());
                    if (auditInfo.getProcessID() != null) {
                        auditInfo.setProcessID(BaseDAO.truncate((String)auditInfo.getProcessID(), (int)20));
                    }
                    pstmtAudit.setString(3, auditInfo.getProcessID());
                    if (auditInfo.getProcessStepID() != null) {
                        auditInfo.setProcessStepID(BaseDAO.truncate((String)auditInfo.getProcessStepID(), (int)20));
                    }
                    pstmtAudit.setString(4, auditInfo.getProcessStepID());
                    truncatedActorName = "";
                    if (auditInfo.getActorName().toString() != null) {
                        truncatedActorName = BaseDAO.truncate((String)auditInfo.getActorName().toString(), (int)256);
                    }
                    pstmtAudit.setString(5, truncatedActorName);
                    truncatedActionID = "";
                    if (auditInfo.getActionID().toString() != null) {
                        truncatedActionID = BaseDAO.truncate((String)auditInfo.getActionID().toString(), (int)100);
                    }
                    pstmtAudit.setString(6, truncatedActionID);
                    truncatedActionStatus = "";
                    if (auditInfo.getActionStatus().toString() != null) {
                        truncatedActionStatus = BaseDAO.truncate((String)auditInfo.getActionStatus().toString(), (int)100);
                    }
                    pstmtAudit.setString(7, truncatedActionStatus);
                    if (auditInfo.getActorVOID() != null) {
                        auditInfo.setActorVOID(BaseDAO.truncate((String)auditInfo.getActorVOID(), (int)100));
                    }
                    pstmtAudit.setString(8, auditInfo.getActorVOID());
                    if (auditInfo.getDescription() != null) {
                        auditInfo.setDescription(BaseDAO.truncate((String)auditInfo.getDescription(), (int)256));
                    }
                    pstmtAudit.setString(9, auditInfo.getDescription());
                    exp = auditInfo.getErrorDescr();
                    if (exp != null) {
                        sw = new StringWriter();
                        w = new PrintWriter(sw);
                        exp.printStackTrace(w);
                        w.flush();
                        error = sw.toString();
                        if (error.length() > maxSize) {
                            error = String.valueOf(error.substring(0, maxSize)) + " ...";
                        }
                        pstmtAudit.setString(10, error);
                    } else {
                        pstmtAudit.setString(10, "");
                    }
                    pstmtAudit.setTimestamp(11, new Timestamp(auditInfo.getAuditDate()));
                    pstmtAudit.executeUpdate();
                }
                catch (CDXDAOException ex) {
                    BaseDAO.rollback((Connection)con);
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)con);
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)con);
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var12_14) {
                var11_15 = null;
                try {
                    pstmtAudit.close();
                }
                catch (Exception ex) {
                    AuditDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var12_14;
            }
            {
                var11_16 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 556->565)] { 
lbl79:
            // 1 sources

            pstmtAudit.close();
            break block23;
lbl81:
            // 1 sources

            catch (Exception ex) {
                AuditDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteAuditInfo(AuditVO auditInfo) throws CDXException {
        block13: {
            con = null;
            pstmtDeleteAudit = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtDeleteAudit = con.prepareStatement(AuditDAO.DELETE_SQL_BY_AUDIT_ID);
                    pstmtDeleteAudit.setString(1, auditInfo.getAuditID());
                    if (pstmtDeleteAudit.executeUpdate() == 0) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_AUDIT_ID);
                    }
                }
                catch (CDXDAOException e) {
                    BaseDAO.rollback((Connection)con);
                    AuditDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    BaseDAO.rollback((Connection)con);
                    AuditDAO.log.error((Object)("No records were deleted. Audit ID (" + auditInfo.getAuditID() + ") isn't found."));
                    throw e;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)con);
                    AuditDAO.log.error((Object)("Problem while deleting from the DBfor Audit id : " + auditInfo.getAuditID()), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    BaseDAO.rollback((Connection)con);
                    AuditDAO.log.error((Object)"", (Throwable)e);
                    throw new CDXServerException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var5_7) {
                var4_8 = null;
                try {
                    pstmtDeleteAudit.close();
                }
                catch (Exception ex) {
                    AuditDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var5_7;
            }
            {
                var4_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 195->204)] { 
lbl40:
            // 1 sources

            pstmtDeleteAudit.close();
            break block13;
lbl42:
            // 1 sources

            catch (Exception ex) {
                AuditDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection loadAuditInfoList(String auditID) throws CDXException {
        block14: {
            vo = null;
            connection = null;
            pstmt = null;
            result = null;
            list = new ArrayList<AuditVO>();
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("Select * from CDX_AUDIT_EVENTS where (AUDIT_ID = ?)");
                    pstmt.setString(1, auditID);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_AUDIT_ID);
                    }
                    do {
                        vo = AuditDAO.readRow(result);
                        list.add(vo);
                    } while (result.next());
                }
                catch (CDXDAOException ex) {
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var8_10) {
                var7_11 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    AuditDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var8_10;
            }
            {
                var7_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 192->208)] { 
lbl46:
            // 1 sources

            result.close();
            pstmt.close();
            break block14;
lbl49:
            // 1 sources

            catch (Exception ex) {
                AuditDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return list;
    }

    public static Collection searchByTransaction(String trID) throws CDXException {
        return AuditDAO.loadAuditInfoList(trID);
    }

    public static Collection genericSearchByAuditFields(Collection auditIDs, Collection clientIPs, Collection userIDs, Collection dataflows, Collection actorIDs, Collection actionStatuses, Collection docIDs, Long startDate, Long endDate) throws CDXException {
        String transactionId = null;
        String dataflow = null;
        if (!(auditIDs != null && auditIDs.size() == 1 || dataflows == null || dataflows.isEmpty())) {
            Iterator iter = dataflows.iterator();
            while (iter.hasNext()) {
                dataflow = (String)iter.next();
                try {
                    Collection transactionList = DocumentDAO.getTransactionsByDataflow(dataflow);
                    Iterator iter2 = transactionList.iterator();
                    while (iter2.hasNext()) {
                        if (auditIDs == null) {
                            auditIDs = new ArrayList<String>();
                        }
                        transactionId = (String)iter2.next();
                        auditIDs.add(transactionId);
                    }
                }
                catch (CDXException cDXException) {}
            }
        }
        return AuditDAO.genericSearchByAuditFields(auditIDs, clientIPs, userIDs, actorIDs, actionStatuses, docIDs, startDate, endDate);
    }

    public static Collection genericSearchByAuditFields(Collection auditIDs, Collection clientIPs, Collection userIDs, Collection actorIDs, Collection actionStatuses, Collection docIDs, Long startDate, Long endDate) throws CDXException {
        if (docIDs != null && !docIDs.isEmpty()) {
            Iterator iter = docIDs.iterator();
            while (iter.hasNext()) {
                String docID = (String)iter.next();
                try {
                    TransactionVO trVO = DocumentDAO.getTransactionForDocument(docID);
                    if (auditIDs == null) {
                        auditIDs = new ArrayList<String>();
                    }
                    auditIDs.add(trVO.getTransactionID());
                }
                catch (CDXException cDXException) {}
            }
        }
        return AuditDAO.genericSearchByAuditFields(auditIDs, clientIPs, userIDs, actorIDs, actionStatuses, startDate, endDate);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection genericSearchByAuditFields(Collection auditIDs, Collection clientIPs, Collection userIDs, Collection actorIDs, Collection actionStatuses, Long startDate, Long endDate) throws CDXException {
        block17: {
            vo = null;
            connection = null;
            pstmt = null;
            result = null;
            list = new ArrayList<AuditVO>();
            sql = new StringBuffer("Select * From CDX_AUDIT_EVENTS Where AUDIT_EVENT_NUM > 0 ");
            try {
                try {
                    if (!(auditIDs != null && !auditIDs.isEmpty() || clientIPs != null && !clientIPs.isEmpty() || userIDs != null && !userIDs.isEmpty() || actorIDs != null && !actorIDs.isEmpty() || actionStatuses != null && !actionStatuses.isEmpty() || startDate != null || endDate != null)) {
                        throw new CDXValidationException(CDXErrorCode.NULL_VALUE_EXCEPTION);
                    }
                    if (auditIDs.size() > 1) {
                        AuditDAO.buildGenericOrSearchSqlByCollection(sql, auditIDs, "AUDIT_ID");
                    } else {
                        AuditDAO.buildGenericSearchSqlByCollection(sql, auditIDs, "AUDIT_ID");
                    }
                    AuditDAO.buildGenericSearchSqlByCollection(sql, userIDs, "VALUE_OBJECT_ID");
                    AuditDAO.buildGenericSearchSqlByCollection(sql, clientIPs, "CLIENT_IP_TX");
                    AuditDAO.buildGenericSearchSqlByCollection(sql, actorIDs, "ACTOR_NAME_TX");
                    AuditDAO.buildGenericSearchSqlByCollection(sql, actionStatuses, "ACTION_STATUS_ID");
                    sql.append(" and (AUDIT_EVENT_TM >? and AUDIT_EVENT_TM <?) ");
                    if (startDate == null) {
                        startDate = AuditDAO.defaulStartDate;
                    }
                    if (endDate == null) {
                        endDate = new Long(System.currentTimeMillis());
                    }
                    sql.append(" " + AuditDAO.ORDER_BY_TIME);
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(sql.toString());
                    pstmt.setTimestamp(1, new Timestamp(startDate));
                    pstmt.setTimestamp(2, new Timestamp(endDate));
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        vo = AuditDAO.readRow(result);
                        list.add(vo);
                    }
                }
                catch (CDXException ex) {
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var15_16) {
                var14_17 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    AuditDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection(connection);
                throw var15_16;
            }
            {
                var14_18 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 424->441)] { 
lbl61:
            // 1 sources

            result.close();
            pstmt.close();
            break block17;
lbl64:
            // 1 sources

            catch (Exception ex) {
                AuditDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TreeSet loadAllActorNames() throws CDXException {
        block10: {
            connection = null;
            pstmt = null;
            result = null;
            list = new TreeSet<String>();
            sql = new StringBuffer(AuditDAO.SELECT_ACTOR_NAMES);
            try {
                try {
                    AuditDAO.log.debug((Object)sql.toString());
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(sql.toString());
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        actorName = result.getString("ACTOR_NAME_TX");
                        list.add(actorName);
                    }
                }
                catch (Exception ex) {
                    AuditDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var7_7) {
                var6_8 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    AuditDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var7_7;
            }
            {
                var6_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 131->146)] { 
lbl35:
            // 1 sources

            result.close();
            pstmt.close();
            break block10;
lbl38:
            // 1 sources

            catch (Exception ex) {
                AuditDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return list;
    }

    public static TreeSet loadAllDataflowNames() throws CDXException {
        List flows = DataflowTypeManager.getAllDataflows();
        TreeSet<String> list = new TreeSet<String>();
        Iterator it = flows.iterator();
        while (it.hasNext()) {
            DataflowTypeVO vo = (DataflowTypeVO)it.next();
            list.add(vo.getDataflowType().toString());
        }
        return list;
    }

    private static void buildGenericOrSearchSqlByCollection(StringBuffer sql, Collection values, String fieldName) {
        if (values != null && !values.isEmpty()) {
            boolean firstOne = true;
            sql.append(" and (");
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                if (firstOne) {
                    firstOne = false;
                    sql.append(String.valueOf(fieldName) + "='" + item.toString() + "'");
                    continue;
                }
                sql.append(" or " + fieldName + "='" + item.toString() + "'");
            }
            sql.append(")");
        }
    }

    private static void buildGenericSearchSqlByCollection(StringBuffer sql, Collection values, String fieldName) {
        if (values != null && !values.isEmpty()) {
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                Object item = iter.next();
                sql.append(" and " + fieldName + "='" + item.toString() + "'");
            }
        }
    }

    private static AuditVO readRow(ResultSet result) throws CDXException {
        AuditVO vo = new AuditVO();
        String value = "";
        try {
            value = result.getString(FIELD_AUDIT_ID);
            vo.setAuditID(value);
            value = result.getString(FIELD_ACTION_ID);
            vo.setActionID(new AuditAction(value));
            value = result.getString(FIELD_ACTION_STATUS_ID);
            vo.setActionStatus(ActionStatus.getObjectById((String)value));
            value = result.getString(FIELD_ACTOR_NAME_TX);
            vo.setActorName(new AuditActor(value));
            vo.setAuditDate(result.getTimestamp(FIELD_AUDIT_EVENT_TM).getTime());
            value = result.getString(FIELD_CLIENT_IP_TX);
            vo.setClientIP(value);
            value = result.getString(FIELD_DESCRIPTION_TX);
            vo.setDescription(value);
            value = result.getString(FIELD_EXCEPTION_TX);
            if (value == null || value.trim().length() == 0) {
                vo.setErrorDescr(null);
            } else {
                vo.setErrorDescr((Throwable)new CDXDBRestoredException(value));
            }
            value = result.getString(FIELD_PROCESS_ID);
            vo.setProcessID(value);
            value = result.getString(FIELD_PROCESS_STEP_ID);
            vo.setProcessStepID(value);
            value = result.getString("VALUE_OBJECT_ID");
            vo.setActorVOID(value);
        }
        catch (SQLException ex) {
            log.error((Object)"", (Throwable)ex);
            throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
        }
        return vo;
    }
}

