/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.distributor;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.DynamicLoader;
import gov.epa.cdx.infrastructure.distributor.DistributorUtil;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.model.distributor.Distributor;

public class DistributorFactory {
    private static LogInterface log;
    private static final String DISTRIBUTOR_CATEGORY_KEY = "Distributor";
    private static final String DISTRIBUTOR_TYPE_KEY = "DistributorType";
    private static final String DISTRIBUTOR_SUFFIX_CATEGORY_KEY = "ExternalApplications";
    private static final String DISTRIBUTOR_SUFFIX_TYPE_KEY = "DistributorSuffix";
    private static final String SESSIONBEAN_TYPE = "SessionBean";
    private static final String GENERIC_DISTRIBUTOR_KEY = "DISTRIBUTOR";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.distributor.DistributorFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static Distributor getDistributor(String dataflow) throws CDXException {
        String distributorClassName = CDXPropertyManager.getProperty((String)dataflow, (String)DISTRIBUTOR_CATEGORY_KEY);
        String distributorType = CDXPropertyManager.getProperty((String)dataflow, (String)DISTRIBUTOR_TYPE_KEY);
        String distributorSuffix = CDXPropertyManager.getProperty((String)DISTRIBUTOR_SUFFIX_CATEGORY_KEY, (String)DISTRIBUTOR_SUFFIX_TYPE_KEY, (String)".Distributor");
        String distributorGenericClassName = CDXPropertyManager.getProperty((String)GENERIC_DISTRIBUTOR_KEY, (String)DISTRIBUTOR_CATEGORY_KEY);
        String distributorGenericType = CDXPropertyManager.getProperty((String)GENERIC_DISTRIBUTOR_KEY, (String)DISTRIBUTOR_TYPE_KEY);
        String dataflowDistributor = String.valueOf(dataflow) + distributorSuffix;
        if (distributorGenericClassName != null && distributorClassName == null) {
            distributorClassName = distributorGenericClassName;
        }
        boolean sessionBean = true;
        if (distributorGenericType != null && !distributorGenericType.equalsIgnoreCase(SESSIONBEAN_TYPE)) {
            sessionBean = false;
        }
        if (distributorClassName == null) {
            distributorClassName = dataflowDistributor;
        } else if (distributorType != null && !distributorType.equalsIgnoreCase(SESSIONBEAN_TYPE)) {
            sessionBean = false;
        }
        try {
            NodeMgr.getUrlByNode(dataflowDistributor);
            distributorClassName = dataflowDistributor;
            sessionBean = true;
        }
        catch (Exception exception) {}
        Distributor distributor = null;
        try {
            distributor = sessionBean ? DistributorUtil.getRemote(distributorClassName) : (Distributor)DynamicLoader.loadAndInstantiateClass((String)distributorClassName);
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.DISTRIBUTOR_FOR_DATAFLOW_COULD_NOT_BE_LOADED, (Throwable)ex);
        }
        return distributor;
    }
}

