/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.document;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.dataflow.DataflowTypeManager;
import gov.epa.cdx.infrastructure.document.dao.DocumentDAO;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentStatusVO;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;

public class DocumentMgr {
    protected static LogInterface log;
    private static SimpleDateFormat formatter;
    private static HashMap lists;
    private static final long maxSize = 81920000L;
    private static DocumentMgr documentMgr;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.document.DocumentMgr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        formatter = new SimpleDateFormat("yyyy_MM_dd_HH_mm_ss_SSS");
    }

    private static DocumentMgr getInstance() {
        if (documentMgr == null) {
            documentMgr = new DocumentMgr();
        }
        return documentMgr;
    }

    private DocumentMgr() {
        lists = new HashMap();
    }

    public static void createDocumentStructure(DocumentList documentList) throws CDXException {
        documentMgr = DocumentMgr.getInstance();
        lists.put(documentList.getTransaction(), documentList);
        throw new UnsupportedOperationException("Method createDocumentStructure() not yet implemented.");
    }

    public static TransactionVO createDocuments(TransactionVO passedTransactionVO, DocumentList documentList) throws CDXException {
        documentMgr = DocumentMgr.getInstance();
        TransactionVO transactionVO = null;
        if (passedTransactionVO == null || passedTransactionVO.getTransactionID().equals("")) {
            transactionVO = TransactionMgr.create();
        } else if (TransactionMgr.isValid(passedTransactionVO.getTransactionID())) {
            transactionVO = passedTransactionVO;
        } else {
            log.error((Object)"Passed transaction is not valid and cannot be associated with the documents. Documents cannot be stored");
            throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT_STORAGE);
        }
        try {
            Iterator it = documentList.getDocuments().iterator();
            while (it.hasNext()) {
                DocumentVO vo = (DocumentVO)it.next();
                vo.setID(GUID.getGUID());
                DataflowTypeManager.isValid(vo.getDataflowTypeVO());
                DocumentDAO.insert(transactionVO.getTransactionID(), vo);
            }
        }
        catch (CDXException cdxException) {
            TransactionMgr.updateTransactionStatus(transactionVO.getTransactionID(), Status.FAILED);
            log.error((Object)"Cannot Insert Documents To The Database", (Throwable)cdxException);
            throw cdxException;
        }
        return transactionVO;
    }

    public static DocumentList getDocumentsMetaData(String transactionId) throws CDXException {
        DocumentMgr.getInstance();
        DocumentList documentList = DocumentDAO.loadAllDocumentMetaData(transactionId);
        return documentList;
    }

    public static DocumentList getAllDocuments(String transactionID) throws CDXException {
        DocumentList documentList = null;
        documentMgr = DocumentMgr.getInstance();
        documentList = DocumentDAO.loadAllDocuments(transactionID);
        return documentList;
    }

    public static DocumentList getDocumentsByStatus(String transactionID, DocumentStatusVO status) throws CDXException {
        DocumentList documentList = null;
        documentMgr = DocumentMgr.getInstance();
        documentList = DocumentDAO.loadDocumentsByStatus(transactionID, status);
        return documentList;
    }

    private static void validateDocumentsSize(DocumentList documentList) throws CDXException {
        long documentsSize = 0L;
        Iterator iter = documentList.getDocuments().iterator();
        while (iter.hasNext()) {
            DocumentVO storedDocumentVO = (DocumentVO)iter.next();
            if ((documentsSize += (long)storedDocumentVO.getData().length) <= 81920000L) continue;
            log.error((Object)"Size of the documents exceed max allowed size.");
            throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_SIZE);
        }
    }

    public static DocumentVO getDocumentByTransactionAndName(String transactionID, String documentName) throws CDXException {
        return DocumentDAO.loadDocument(transactionID, documentName);
    }

    public static DocumentList getDocuments(String transactionID, DocumentList passedDocumentList) throws CDXException {
        documentMgr = DocumentMgr.getInstance();
        DocumentList documentList = passedDocumentList;
        DocumentVO storedDocumentVO = null;
        long documentsSize = 0L;
        if (passedDocumentList == null) {
            log.error((Object)"Invalid DocumentList is Passed. The list contains zero Documents");
            throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_LIST);
        }
        Iterator iter = documentList.getDocuments().iterator();
        while (iter.hasNext()) {
            DocumentVO requestedDocumentVO = (DocumentVO)iter.next();
            storedDocumentVO = transactionID == null || transactionID.equals("") ? DocumentDAO.loadDocumentByName(requestedDocumentVO.getName()) : DocumentDAO.loadDocument(transactionID, requestedDocumentVO.getName());
            if ((documentsSize += (long)storedDocumentVO.getData().length) > 81920000L) {
                log.error((Object)"Size of the documents exceed max allowed size.");
                throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_SIZE);
            }
            DocumentMgr.validateDocumentRequest(requestedDocumentVO, storedDocumentVO);
            requestedDocumentVO.setData(storedDocumentVO.getData());
            requestedDocumentVO.setID(storedDocumentVO.getID());
        }
        log.debug((Object)"Exit DocumentMgr.getDocuments. ");
        return documentList;
    }

    private static void validateDocumentRequest(DocumentVO requestedDocumentVO, DocumentVO storedDocumentVO) throws CDXException {
        log.debug((Object)"Enter DocumentMgr.validateDocumentRequest");
        boolean dataFlowTypeValidation = true;
        boolean documentTypeValidation = true;
        if (!requestedDocumentVO.getDataflowTypeVO().getDataflowType().equals(storedDocumentVO.getDataflowTypeVO().getDataflowType())) {
            dataFlowTypeValidation = false;
        }
        if (!requestedDocumentVO.getDocumentType().equals((Object)storedDocumentVO.getDocumentType())) {
            documentTypeValidation = false;
        }
        if (!dataFlowTypeValidation && documentTypeValidation) {
            log.error((Object)"DataFlow Type of Requested Document does not match Data Flow Type of stored Dcoument");
            throw new CDXValidationException(CDXErrorCode.DATA_FLOW_TYPE_MISSMATCH);
        }
        if (dataFlowTypeValidation && !documentTypeValidation) {
            log.error((Object)"Document Type of Requested Document does not match Document Type of stored Document");
            throw new CDXValidationException(CDXErrorCode.DOCUMENT_TYPE_MISSMATCH);
        }
        if (!dataFlowTypeValidation && !documentTypeValidation) {
            log.error((Object)"Data Flow Type of Requested Document and Document Type does not match Data Flow type and Document Type of stored Dcoument");
            throw new CDXValidationException(CDXErrorCode.DOCUMENT_TYPE_AND_DATA_FLOW_TYPE_MISSMATCH);
        }
    }

    public static DocumentVO getDocument(String documentId) throws CDXException {
        return DocumentDAO.loadDocument(documentId);
    }

    public static void updateDocumentStatus(String documentId, DocumentStatusVO status) throws CDXException {
        DocumentDAO.updateDocumentStatus(documentId, status);
    }

    public static void updateDocumentDataflowType(String documentId, DataflowTypeVO dataflow) throws CDXException {
        DocumentDAO.updateDocumentDataflow(documentId, dataflow);
    }

    public static TransactionVO getTransactionForDocument(String documentId) throws CDXException {
        return DocumentDAO.getTransactionForDocument(documentId);
    }

    public static void deleteDocument(String documentId) throws CDXException {
        DocumentDAO.deleteDocument(documentId);
    }

    public static String createDocument(TransactionVO transaction, DocumentVO document) throws CDXException {
        String documentId = GUID.getGUID();
        document.setID(documentId);
        DataflowTypeManager.isValid(document.getDataflowTypeVO());
        DocumentDAO.insert(transaction.getTransactionID(), document);
        return documentId;
    }

    public static String getDocumentName(String documentName, String nodeVersion) {
        String docName = null;
        String timeStamp = null;
        timeStamp = formatter.format(new Date());
        docName = String.valueOf(documentName) + "_" + nodeVersion + "_" + timeStamp + ".xml";
        return docName;
    }

    public static DocumentList getPayloadDocuments(String transactionId) throws CDXException {
        DocumentList documentList = DocumentDAO.getPayloadDocuments(transactionId);
        return documentList;
    }

    public static DocumentList getReportDocuments(String transactionId) throws CDXException {
        DocumentList documentList = DocumentDAO.getReportDocuments(transactionId);
        return documentList;
    }
}

