/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.document;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentInterface;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DocumentMgrTest
extends TestCase {
    public DocumentMgrTest() {
        super("DocumentMgrTest");
    }

    public DocumentMgrTest(String name) {
        super(name);
    }

    public void testCreateDocuments() {
        try {
            this.createDocuments(0);
        }
        catch (Exception exception) {
            Assert.fail((String)"Cannot create documents");
        }
    }

    private TransactionVO createDocuments(int i) throws CDXException {
        TransactionVO transactionVO = null;
        DocumentList documentList = this.createDocumentList(i, true);
        transactionVO = DocumentMgr.createDocuments(null, documentList);
        System.out.println("transaction: " + transactionVO.getTransactionID());
        return transactionVO;
    }

    private DocumentList createDocumentList(int row, boolean isDataRequired) throws CDXException {
        DocumentType[][] documentTypes = new DocumentType[][]{{DocumentType.XML, DocumentType.FLAT, DocumentType.BINARY}, {DocumentType.OTHER, DocumentType.XML, DocumentType.BINARY}, {DocumentType.XML, DocumentType.FLAT, DocumentType.OTHER}};
        String[][] names = new String[][]{{"Arty", "Denis", "Dodik"}, {"Bopsen", "Bulyul", "Shurik"}, {"Leto", "Zima", "Osyen"}};
        String[][] data = new String[][]{{"Ochen krupny kaban", "Bilyardist i lubitel poest'", "Shibko umny"}, {"Krasavitsa narodnaya", "Pobeditel' vseh kastrul'", "Razgovorchivy Myshonok"}, {"prishlo s dojdyami", "lyutaya razygralas'", "listya jeltye..."}};
        DocumentList documentList = new DocumentList(new DataflowTypeVO("TEST"));
        int k = 0;
        while (k < 3) {
            DocumentVO document = null;
            document = isDataRequired ? new DocumentVO(null, names[row][k], documentTypes[row][k], new DataflowTypeVO("TEST"), data[row][k].getBytes()) : new DocumentVO(null, names[row][k], documentTypes[row][k], new DataflowTypeVO("TEST"));
            documentList.addDocument((DocumentInterface)document);
            ++k;
        }
        return documentList;
    }
}

