/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.document.dao;

import gov.epa.cdx.commons.basedao.dao.BaseDAO;
import gov.epa.cdx.commons.basedao.dao.wrapper.BlobManager;
import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.transaction.dao.TransactionDAO;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentInterface;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentStatusVO;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class DocumentDAO {
    protected static LogInterface log;
    public static String SELECT_SQL_BY_DOCUMENT_ID;
    public static String SELECT_SQL_ALL_DOCUMENTS_BY_TRANSACTION_ID;
    public static String SELECT_SQL_ALL_DOCUMENTS_BY_TRANSACTION_ID_AND_STATUS;
    public static String SELECT_SQL_PAYLOAD_DOCUMENTS_BY_TRANSACTION_ID;
    public static String SELECT_SQL_REPORT_DOCUMENTS_BY_TRANSACTION_ID;
    public static String SELECT_SQL_TRANSACTIONS_BY_DATAFLOW;
    public static String SELECT_SQL_DOCUMENT_BY_TRANSACTION_ID_AND_NAME;
    public static String INSERT_SQL;
    public static String SELECT_BLOB_SQL;
    public static String DELETE_SQL_BY_DOCUMENT_ID;
    public static String DELETE_SQL_BY_TRANSACTION_ID;
    public static String SELECT_SQL_ALL_DOCUMENTS_META_DATA_BY_TRANSACTION_ID;
    public static String SELECT_SQL_DOCUMENTS_BY_DOCUMENT_NAME;
    public static String UPDATE_SQL_DOCUMENT_STATUS;
    public static String UPDATE_SQL_DOCUMENT_DATAFLOW;
    public static String SELECT_SQL_TRANSACTION_BY_DOCUMENT_ID;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.document.dao.DocumentDAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        SELECT_SQL_BY_DOCUMENT_ID = "SELECT cdx.validation_status_id, cdx.dataflow_type_id, cdx.document_content_da, cdx.document_name_tx, cdx.document_type_id, cdx.transaction_id FROM cdx_documents cdx WHERE ((cdx.document_id = ?))";
        SELECT_SQL_ALL_DOCUMENTS_BY_TRANSACTION_ID = "SELECT cdx.document_id, cdx.dataflow_type_id, cdx.document_content_da, cdx.document_name_tx, cdx.document_type_id, cdx.validation_status_id FROM cdx_documents cdx WHERE ((cdx.transaction_id = ?))";
        SELECT_SQL_ALL_DOCUMENTS_BY_TRANSACTION_ID_AND_STATUS = "SELECT cdx.document_id, cdx.dataflow_type_id, cdx.document_content_da, cdx.document_name_tx, cdx.document_type_id, cdx.validation_status_id FROM cdx_documents cdx WHERE ((cdx.transaction_id = ?) AND (cdx.validation_status_id = ?))";
        SELECT_SQL_PAYLOAD_DOCUMENTS_BY_TRANSACTION_ID = "SELECT cdx.document_id, cdx.dataflow_type_id, cdx.document_content_da, cdx.document_name_tx, cdx.document_type_id, cdx.validation_status_id FROM cdx_documents cdx WHERE ((cdx.transaction_id = ?) AND (cdx.validation_status_id <> '" + Status.REPORT.toString() + "'))";
        SELECT_SQL_REPORT_DOCUMENTS_BY_TRANSACTION_ID = "SELECT cdx.document_id, cdx.dataflow_type_id, cdx.document_content_da, cdx.document_name_tx, cdx.document_type_id, cdx.validation_status_id FROM cdx_documents cdx WHERE ((cdx.transaction_id = ?) AND (cdx.validation_status_id = '" + Status.REPORT.toString() + "'))";
        SELECT_SQL_TRANSACTIONS_BY_DATAFLOW = "SELECT cdx.transaction_id FROM cdx_documents cdx WHERE ((cdx.dataflow_type_id = ?))";
        SELECT_SQL_DOCUMENT_BY_TRANSACTION_ID_AND_NAME = "SELECT cdx.document_id, cdx.dataflow_type_id, cdx.document_content_da, cdx.document_type_id, cdx.validation_status_id  FROM cdx_documents cdx WHERE ((cdx.transaction_id = ?) AND (cdx.document_name_tx = ?))";
        INSERT_SQL = "INSERT INTO cdx_documents (dataflow_type_id, document_content_da, document_name_tx, document_type_id, transaction_id, document_id, validation_status_id) VALUES (?, ?, ?, ?, ?, ?, ?)";
        SELECT_BLOB_SQL = "SELECT cdx.document_content_da FROM cdx_documents cdx WHERE (cdx.document_id = ?)";
        DELETE_SQL_BY_DOCUMENT_ID = "DELETE FROM cdx_documents cdx WHERE ((cdx.document_id = ?))";
        DELETE_SQL_BY_TRANSACTION_ID = "DELETE FROM cdx_documents cdx WHERE ((cdx.transaction_id = ?))";
        SELECT_SQL_ALL_DOCUMENTS_META_DATA_BY_TRANSACTION_ID = "SELECT cdx.document_id, cdx.dataflow_type_id, cdx.document_name_tx, cdx.document_type_id, cdx.validation_status_id  FROM cdx_documents cdx WHERE ((cdx.transaction_id = ?))";
        SELECT_SQL_DOCUMENTS_BY_DOCUMENT_NAME = "SELECT  cdx.DOCUMENT_NAME_TX, cdx_tr.CREATED_TM,   cdx.dataflow_type_id, cdx.document_id, cdx.document_content_da,  cdx.document_type_id, cdx.transaction_id, cdx.validation_status_id  FROM cdx_documents cdx, cdx_transactions cdx_tr  WHERE cdx.TRANSACTION_ID= cdx_tr.TRANSACTION_ID  and (cdx.document_name_tx = ? )  Order by cdx_tr.CREATED_TM desc ";
        UPDATE_SQL_DOCUMENT_STATUS = "update CDX_DOCUMENTS set VALIDATION_STATUS_ID=? where DOCUMENT_ID=?";
        UPDATE_SQL_DOCUMENT_DATAFLOW = "update CDX_DOCUMENTS set DATAFLOW_TYPE_ID = ? where DOCUMENT_ID = ?";
        SELECT_SQL_TRANSACTION_BY_DOCUMENT_ID = "SELECT cdx.transaction_id FROM cdx_documents cdx WHERE ((cdx.document_id = ?))";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentVO loadDocumentByName(String documentName) throws CDXException {
        block13: {
            documentVO = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.SELECT_SQL_DOCUMENTS_BY_DOCUMENT_NAME);
                    pstmt.setString(1, documentName);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.DOCUMENT_NAME_INVALID);
                    }
                    dataFlowTypeId = result.getString("dataflow_type_id");
                    documentContentBlob = result.getBlob("document_content_da");
                    input = documentContentBlob.getBinaryStream();
                    allBytes = DocumentDAO.readAllBytes(input, documentContentBlob.length());
                    documentTypeId = result.getString("document_type_id");
                    documentId = result.getString("document_id");
                    status = result.getString("validation_status_id");
                    documentVO = new DocumentVO(documentId, documentName, DocumentType.getDocumentTypeById((String)documentTypeId), new DataflowTypeVO(dataFlowTypeId), allBytes);
                    documentVO.setStatus(new DocumentStatusVO(status));
                }
                catch (CDXDAOException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var13_16) {
                var12_17 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var13_16;
            }
            {
                var12_18 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 279->295)] { 
lbl49:
            // 1 sources

            result.close();
            pstmt.close();
            break block13;
lbl52:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return documentVO;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentVO loadDocument(String transactionId, String documentName) throws CDXException {
        block13: {
            documentVO = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.SELECT_SQL_DOCUMENT_BY_TRANSACTION_ID_AND_NAME);
                    pstmt.setString(1, transactionId);
                    pstmt.setString(2, documentName);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT);
                    }
                    dataFlowTypeId = result.getString("dataflow_type_id");
                    documentContentBlob = result.getBlob("document_content_da");
                    input = documentContentBlob.getBinaryStream();
                    allBytes = DocumentDAO.readAllBytes(input, documentContentBlob.length());
                    documentTypeId = result.getString("document_type_id");
                    documentId = result.getString("document_id");
                    status = result.getString("validation_status_id");
                    documentVO = new DocumentVO(documentId, documentName, DocumentType.getDocumentTypeById((String)documentTypeId), new DataflowTypeVO(dataFlowTypeId), allBytes);
                    documentVO.setStatus(new DocumentStatusVO(status));
                }
                catch (CDXDAOException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var14_17) {
                var13_18 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var14_17;
            }
            {
                var13_19 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 292->309)] { 
lbl50:
            // 1 sources

            result.close();
            pstmt.close();
            break block13;
lbl53:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return documentVO;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getTransactionsByDataflow(String dataflow) throws CDXException {
        block14: {
            transactionList = new ArrayList<String>();
            connection = null;
            pstmt = null;
            result = null;
            transactionId = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.SELECT_SQL_TRANSACTIONS_BY_DATAFLOW);
                    pstmt.setString(1, dataflow);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT);
                    }
                    do {
                        transactionId = result.getString("transaction_id");
                        transactionList.add(transactionId);
                    } while (result.next());
                }
                catch (CDXDAOException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var8_10) {
                var7_11 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var8_10;
            }
            {
                var7_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 199->215)] { 
lbl46:
            // 1 sources

            result.close();
            pstmt.close();
            break block14;
lbl49:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return transactionList;
    }

    public static DocumentList loadDocumentsByStatus(String transactionId, DocumentStatusVO status) throws CDXException {
        return DocumentDAO.loadDocuments(transactionId, status);
    }

    public static DocumentList loadAllDocuments(String transactionId) throws CDXException {
        return DocumentDAO.loadDocuments(transactionId, null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DocumentList loadDocuments(String transactionId, DocumentStatusVO status) throws CDXException {
        block16: {
            docList = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    if (status != null) {
                        pstmt = connection.prepareStatement(DocumentDAO.SELECT_SQL_ALL_DOCUMENTS_BY_TRANSACTION_ID_AND_STATUS);
                        pstmt.setString(2, status.toString());
                    } else {
                        pstmt = connection.prepareStatement(DocumentDAO.SELECT_SQL_ALL_DOCUMENTS_BY_TRANSACTION_ID);
                    }
                    pstmt.setString(1, transactionId);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT);
                    }
                    docList = new DocumentList(new DataflowTypeVO("TEST"));
                    transactionVO = TransactionDAO.load(transactionId);
                    docList.setTransaction(transactionVO);
                    do {
                        dataFlowTypeId = result.getString("dataflow_type_id");
                        docList.setDataFlowType(new DataflowTypeVO(dataFlowTypeId));
                        documentContentBlob = result.getBlob("document_content_da");
                        input = documentContentBlob.getBinaryStream();
                        allBytes = DocumentDAO.readAllBytes(input, documentContentBlob.length());
                        documentName = result.getString("document_name_tx");
                        documentTypeId = result.getString("document_type_id");
                        documentId = result.getString("document_id");
                        currentStatus = result.getString("validation_status_id");
                        documentVO = new DocumentVO(documentId, documentName, DocumentType.getDocumentTypeById((String)documentTypeId), new DataflowTypeVO(dataFlowTypeId), allBytes);
                        documentVO.setStatus(new DocumentStatusVO(currentStatus));
                        docList.addDocument((DocumentInterface)documentVO);
                    } while (result.next());
                }
                catch (CDXDAOException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var17_20) {
                var16_21 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var17_20;
            }
            {
                var16_22 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 387->404)] { 
lbl61:
            // 1 sources

            result.close();
            pstmt.close();
            break block16;
lbl64:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return docList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentVO loadDocument(String documentId) throws CDXException {
        block13: {
            documentVO = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.SELECT_SQL_BY_DOCUMENT_ID);
                    pstmt.setString(1, documentId);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_ID);
                    }
                    status = result.getString("validation_status_id");
                    dataFlowTypeId = result.getString("dataflow_type_id");
                    documentContentBlob = result.getBlob("document_content_da");
                    input = documentContentBlob.getBinaryStream();
                    allBytes = DocumentDAO.readAllBytes(input, documentContentBlob.length());
                    documentName = result.getString("document_name_tx");
                    documentTypeId = result.getString("document_type_id");
                    result.getString("transaction_id");
                    documentVO = new DocumentVO(documentId, documentName, DocumentType.getDocumentTypeById((String)documentTypeId), new DataflowTypeVO(dataFlowTypeId), allBytes);
                    documentVO.setStatus(new DocumentStatusVO(status));
                }
                catch (CDXDAOException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var13_16) {
                var12_17 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var13_16;
            }
            {
                var12_18 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 291->307)] { 
lbl51:
            // 1 sources

            result.close();
            pstmt.close();
            break block13;
lbl54:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return documentVO;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insert(String transactionId, DocumentVO documentVO) throws CDXException {
        block13: {
            connection = null;
            pstmt = null;
            blobData = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement(DocumentDAO.INSERT_SQL);
                    pstmt.setString(1, documentVO.getDataflowTypeVO().getDataflowType());
                    blobData = BlobManager.createBlob((Connection)connection, (byte[])documentVO.getData());
                    pstmt.setBlob(2, blobData);
                    pstmt.setString(3, documentVO.getName());
                    pstmt.setString(4, documentVO.getDocumentType().toString());
                    pstmt.setString(5, transactionId);
                    pstmt.setString(6, documentVO.getID());
                    pstmt.setString(7, documentVO.getStatus().getId());
                    if (pstmt.executeUpdate() != 1) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_ID);
                    }
                }
                catch (CDXDAOException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var7_9) {
                var6_10 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var7_9;
            }
            {
                var6_11 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 259->268)] { 
lbl49:
            // 1 sources

            pstmt.close();
            break block13;
lbl51:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteDocument(String documentId) throws CDXException {
        block13: {
            connection = null;
            pstmt = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.DELETE_SQL_BY_DOCUMENT_ID);
                    pstmt.setString(1, documentId);
                    if (pstmt.executeUpdate() != 1) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_ID);
                    }
                }
                catch (CDXDAOException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var5_7) {
                var4_8 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var5_7;
            }
            {
                var4_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 152->161)] { 
lbl40:
            // 1 sources

            pstmt.close();
            break block13;
lbl42:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteAllDocumentsForTransaction(String transactionId) throws CDXException {
        block13: {
            connection = null;
            pstmt = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.DELETE_SQL_BY_TRANSACTION_ID);
                    pstmt.setString(1, transactionId);
                    if (pstmt.executeUpdate() < 1) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT);
                    }
                }
                catch (CDXDAOException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var5_7) {
                var4_8 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var5_7;
            }
            {
                var4_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 152->161)] { 
lbl40:
            // 1 sources

            pstmt.close();
            break block13;
lbl42:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    public DocumentList read(TransactionVO transaction) throws CDXException {
        BaseDAO.getConnection();
        DocumentList documentList = null;
        return documentList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentList loadAllDocumentMetaData(String transactionId) throws CDXException {
        block14: {
            docList = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.SELECT_SQL_ALL_DOCUMENTS_META_DATA_BY_TRANSACTION_ID);
                    pstmt.setString(1, transactionId);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT_RETRIEVAL);
                    }
                    docList = new DocumentList(new DataflowTypeVO("TEST"));
                    transactionVO = TransactionDAO.load(transactionId);
                    docList.setTransaction(transactionVO);
                    do {
                        dataFlowTypeId = result.getString("dataflow_type_id");
                        docList.setDataFlowType(new DataflowTypeVO(dataFlowTypeId));
                        documentName = result.getString("document_name_tx");
                        documentTypeId = result.getString("document_type_id");
                        documentId = result.getString("document_id");
                        status = result.getString("validation_status_id");
                        documentVO = new DocumentVO(documentId, documentName, DocumentType.getDocumentTypeById((String)documentTypeId), new DataflowTypeVO(dataFlowTypeId));
                        documentVO.setStatus(new DocumentStatusVO(status));
                        docList.addDocument((DocumentInterface)documentVO);
                    } while (result.next());
                }
                catch (CDXDAOException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var13_16) {
                var12_17 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var13_16;
            }
            {
                var12_18 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 317->333)] { 
lbl54:
            // 1 sources

            result.close();
            pstmt.close();
            break block14;
lbl57:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return docList;
    }

    private static byte[] readAllBytes(InputStream in, long length) throws CDXException {
        byte[] byteArray = new byte[(int)length];
        try {
            in.read(byteArray);
        }
        catch (Exception ex) {
            throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
        }
        return byteArray;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransactionVO getTransactionForDocument(String documentId) throws CDXException {
        block12: {
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.SELECT_SQL_TRANSACTION_BY_DOCUMENT_ID);
                    pstmt.setString(1, documentId);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_ID);
                    }
                    transactionId = result.getString("transaction_id");
                    var7_8 = TransactionDAO.load(transactionId);
                    var5_9 = null;
                }
                catch (CDXValidationException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var6_13) {
                var5_10 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var6_13;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 160->175)] { 
lbl40:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl43:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return var7_8;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateDocumentStatus(String documentId, DocumentStatusVO status) throws CDXException {
        block11: {
            connection = null;
            pstmt = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.UPDATE_SQL_DOCUMENT_STATUS);
                    pstmt.setString(1, status.getId());
                    pstmt.setString(2, documentId);
                    if (pstmt.executeUpdate() != 1) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_ID);
                    }
                }
                catch (CDXValidationException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var6_6) {
                var5_7 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var6_6;
            }
            {
                var5_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 123->132)] { 
lbl33:
            // 1 sources

            pstmt.close();
            break block11;
lbl35:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateDocumentDataflow(String documentId, DataflowTypeVO dataflow) throws CDXException {
        block11: {
            connection = null;
            pstmt = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(DocumentDAO.UPDATE_SQL_DOCUMENT_DATAFLOW);
                    pstmt.setString(1, dataflow.getDataflowType());
                    pstmt.setString(2, documentId);
                    if (pstmt.executeUpdate() != 1) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_DOCUMENT_ID);
                    }
                }
                catch (CDXValidationException ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)connection);
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var6_6) {
                var5_7 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var6_6;
            }
            {
                var5_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 123->132)] { 
lbl33:
            // 1 sources

            pstmt.close();
            break block11;
lbl35:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    public static DocumentList getPayloadDocuments(String transactionId) throws CDXException {
        return DocumentDAO.loadDocumentByStatus(transactionId, SELECT_SQL_PAYLOAD_DOCUMENTS_BY_TRANSACTION_ID);
    }

    public static DocumentList getReportDocuments(String transactionId) throws CDXException {
        return DocumentDAO.loadDocumentByStatus(transactionId, SELECT_SQL_REPORT_DOCUMENTS_BY_TRANSACTION_ID);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DocumentList loadDocumentByStatus(String transactionId, String query) throws CDXException {
        block14: {
            docList = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(query);
                    pstmt.setString(1, transactionId);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_FOR_DOCUMENT);
                    }
                    docList = new DocumentList(new DataflowTypeVO("TEST"));
                    transactionVO = TransactionDAO.load(transactionId);
                    docList.setTransaction(transactionVO);
                    do {
                        dataFlowTypeId = result.getString("dataflow_type_id");
                        docList.setDataFlowType(new DataflowTypeVO(dataFlowTypeId));
                        documentContentBlob = result.getBlob("document_content_da");
                        input = documentContentBlob.getBinaryStream();
                        allBytes = DocumentDAO.readAllBytes(input, documentContentBlob.length());
                        documentName = result.getString("document_name_tx");
                        documentTypeId = result.getString("document_type_id");
                        documentId = result.getString("document_id");
                        currentStatus = result.getString("validation_status_id");
                        documentVO = new DocumentVO(documentId, documentName, DocumentType.getDocumentTypeById((String)documentTypeId), new DataflowTypeVO(dataFlowTypeId), allBytes);
                        documentVO.setStatus(new DocumentStatusVO(currentStatus));
                        docList.addDocument((DocumentInterface)documentVO);
                    } while (result.next());
                }
                catch (CDXDAOException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var17_20) {
                var16_21 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var17_20;
            }
            {
                var16_22 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 355->372)] { 
lbl57:
            // 1 sources

            result.close();
            pstmt.close();
            break block14;
lbl60:
            // 1 sources

            catch (Exception ex) {
                DocumentDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return docList;
    }
}

