/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.document.dao;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.infrastructure.document.dao.DocumentDAO;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.Arrays;
import java.util.Iterator;
import junit.framework.Assert;
import junit.framework.TestCase;

public class DocumentDAOTest
extends TestCase {
    public DocumentDAOTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void testGetDocumentById() {
        DocumentVO voToInsert = this.createTestDocumentObject("doc1");
        TransactionVO tr = null;
        try {
            tr = TransactionMgr.create();
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"TransactionMgr failed while trying to create exception");
        }
        try {
            try {
                DocumentDAO.deleteDocument(voToInsert.getID());
            }
            catch (CDXValidationException cDXValidationException) {}
            DocumentDAO.insert(tr.getTransactionID(), voToInsert);
            DocumentVO resultDocument = DocumentDAO.loadDocument(voToInsert.getID());
            Assert.assertTrue((boolean)this.compareDocument(voToInsert, resultDocument));
            Assert.assertEquals((String)resultDocument.getStatus().getId(), (String)"CREATED");
            DocumentDAO.deleteDocument(voToInsert.getID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"Test failed");
        }
    }

    public void testLoadDocument() {
        DocumentVO voToInsert = this.createTestDocumentObject("doc1");
        TransactionVO tr = null;
        try {
            tr = TransactionMgr.create();
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"TransactionMgr failed while trying to create exception");
        }
        try {
            try {
                DocumentDAO.deleteDocument(voToInsert.getID());
            }
            catch (CDXValidationException cDXValidationException) {}
            DocumentDAO.insert(tr.getTransactionID(), voToInsert);
            DocumentVO resultDocument = DocumentDAO.loadDocument(voToInsert.getID());
            Assert.assertTrue((boolean)this.compareDocument(voToInsert, resultDocument));
            DocumentDAO.deleteDocument(voToInsert.getID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"Test failed");
        }
    }

    public void testLoadDocumentByTransactionAndName() {
        DocumentVO voToInsert = this.createTestDocumentObject("doc2");
        TransactionVO tr = null;
        try {
            tr = TransactionMgr.create();
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"TransactionMgr failed while trying to create exception");
        }
        try {
            try {
                DocumentDAO.deleteDocument(voToInsert.getID());
            }
            catch (CDXValidationException cDXValidationException) {}
            DocumentDAO.insert(tr.getTransactionID(), voToInsert);
            DocumentVO resultDocument = DocumentDAO.loadDocument(tr.getTransactionID(), voToInsert.getName());
            Assert.assertTrue((boolean)this.compareDocument(voToInsert, resultDocument));
            DocumentDAO.deleteDocument(voToInsert.getID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"Test failed");
        }
    }

    public void testLoadAllDocumentByTransaction() {
        DocumentVO voToInsert1 = this.createTestDocumentObject("doc12");
        DocumentVO voToInsert2 = this.createTestDocumentObject("doc13");
        TransactionVO tr = null;
        try {
            tr = TransactionMgr.create();
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"TransactionMgr failed while trying to create exception");
        }
        try {
            try {
                DocumentDAO.deleteDocument(voToInsert1.getID());
                DocumentDAO.deleteDocument(voToInsert2.getID());
            }
            catch (CDXValidationException cDXValidationException) {}
            DocumentDAO.insert(tr.getTransactionID(), voToInsert1);
            DocumentDAO.insert(tr.getTransactionID(), voToInsert2);
            DocumentList resultDocumentList = DocumentDAO.loadAllDocuments(tr.getTransactionID());
            Iterator it = resultDocumentList.getDocuments().iterator();
            while (it.hasNext()) {
                DocumentVO resultDocument = (DocumentVO)it.next();
                if (resultDocument.getID().equals(voToInsert1.getID())) {
                    Assert.assertTrue((boolean)this.compareDocument(voToInsert1, resultDocument));
                    continue;
                }
                Assert.assertTrue((boolean)this.compareDocument(voToInsert2, resultDocument));
            }
            DocumentDAO.deleteAllDocumentsForTransaction(tr.getTransactionID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"Test failed");
        }
    }

    public void testInsertLongDocument() {
        DocumentVO vo = this.createTestDocumentObject("doc3");
        TransactionVO tr = null;
        try {
            tr = TransactionMgr.create();
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"TransactionMgr failed while trying to create exception");
        }
        byte[] array = new byte[0x100000];
        byte bt = 111;
        Arrays.fill(array, bt);
        vo.setData(array);
        try {
            try {
                DocumentDAO.deleteDocument(vo.getID());
            }
            catch (CDXValidationException cDXValidationException) {}
            DocumentDAO.insert(tr.getTransactionID(), vo);
            DocumentVO documentRead = DocumentDAO.loadDocument(vo.getID());
            Assert.assertTrue((boolean)this.compareDocument(vo, documentRead));
            DocumentDAO.deleteDocument(vo.getID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"DAO Exception occured");
        }
    }

    private DocumentVO createTestDocumentObject(String name) {
        DocumentVO vo = new DocumentVO();
        vo.setDataFlowType(new DataflowTypeVO("NEI"));
        vo.setDocumentType(DocumentType.XML);
        vo.setID(name);
        vo.setName(name);
        byte[] array = new byte[10240];
        byte bt = 111;
        Arrays.fill(array, bt);
        vo.setData(array);
        return vo;
    }

    private boolean compareDocument(DocumentVO doc1, DocumentVO doc2) {
        if (doc1.getDataflowTypeVO().getDataflowType() != doc2.getDataflowTypeVO().getDataflowType()) {
            return false;
        }
        if (!doc1.getName().equals(doc2.getName())) {
            return false;
        }
        if (doc1.getDocumentType() != doc2.getDocumentType()) {
            return false;
        }
        if (!doc1.getID().equals(doc2.getID())) {
            return false;
        }
        return Arrays.equals(doc1.getData(), doc2.getData());
    }
}

