/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.extractor;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.zip.ZipUtil;
import gov.epa.cdx.infrastructure.extractor.ExtractorParser;
import gov.epa.cdx.infrastructure.extractor.HeaderDigester;
import gov.epa.cdx.infrastructure.extractor.HeaderHandler;
import gov.epa.cdx.infrastructure.extractor.MultiPayloadHandler;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.header.HeaderVO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.node.NodeVersionVO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.CopyUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.xml.sax.InputSource;

public class ExtractorManager {
    private static final transient LogInterface logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.extractor.ExtractorManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = LogFactory.getLog((String)clazz.getName());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static HeaderVO extractHeader(DocumentVO document) throws CDXException {
        HeaderVO result = null;
        HeaderDigester digester = new HeaderDigester();
        FileReader fullXML = null;
        BufferedReader fullXMLBuffer = null;
        StringWriter headerXMLWriter = new StringWriter();
        StringReader headerXMLReader = null;
        File tempDirectory = null;
        if (!ExtractorManager.isValid(document)) {
            throw new CDXException(CDXErrorCode.INVALID_DOCUMENT_TYPE, (Throwable)new IllegalArgumentException("document is invalid for header extraction"));
        }
        try {
            try {
                tempDirectory = ExtractorManager.getTempDirectory(document.getID());
                FileUtils.forceMkdir((File)tempDirectory);
                File fullFile = ExtractorManager.writeFileToDisk(tempDirectory, document);
                fullXML = new FileReader(fullFile);
                fullXMLBuffer = new BufferedReader(fullXML);
                HeaderHandler handler = new HeaderHandler(headerXMLWriter);
                ExtractorParser.parse(fullXMLBuffer, handler, handler);
                headerXMLReader = new StringReader(headerXMLWriter.toString());
                HeaderVO headerVO = result = digester.digest(new InputSource(headerXMLReader));
                Object var10_12 = null;
                IOUtils.closeQuietly((Reader)fullXMLBuffer);
                IOUtils.closeQuietly((Reader)fullXML);
                IOUtils.closeQuietly((Reader)headerXMLReader);
                IOUtils.closeQuietly((Writer)headerXMLWriter);
                try {
                    FileUtils.deleteDirectory((File)tempDirectory);
                    return headerVO;
                }
                catch (IOException e2) {
                    logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                }
                return headerVO;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            IOUtils.closeQuietly(fullXMLBuffer);
            IOUtils.closeQuietly(fullXML);
            IOUtils.closeQuietly(headerXMLReader);
            IOUtils.closeQuietly((Writer)headerXMLWriter);
            try {}
            catch (IOException e2) {
                logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                throw throwable;
            }
            FileUtils.deleteDirectory((File)tempDirectory);
            throw throwable;
        }
    }

    public static DocumentVO extractPayload(DocumentVO document) throws CDXException {
        return (DocumentVO)ExtractorManager.extractPayloads(document).get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List extractPayloads(DocumentVO document) throws CDXException {
        FileReader reader = null;
        BufferedReader buffer = null;
        File tempDirectory = null;
        if (!ExtractorManager.isValid(document)) {
            throw new CDXException(CDXErrorCode.INVALID_DOCUMENT_TYPE, (Throwable)new IllegalArgumentException("document is invalid for payload extraction"));
        }
        try {
            try {
                tempDirectory = ExtractorManager.getTempDirectory(document.getID());
                FileUtils.forceMkdir((File)tempDirectory);
                File fullFile = ExtractorManager.writeFileToDisk(tempDirectory, document);
                reader = new FileReader(fullFile);
                buffer = new BufferedReader(reader);
                MultiPayloadHandler handler = new MultiPayloadHandler(tempDirectory + File.separator + document.getID());
                ExtractorParser.parse(buffer, handler, handler);
                ArrayList<DocumentVO> results = new ArrayList<DocumentVO>();
                int i = 0;
                while (true) {
                    if (i >= handler.getFiles().size()) break;
                    File temp = (File)handler.getFiles().get(i);
                    results.add(ExtractorManager.createDocument(temp, document, i));
                    ++i;
                }
                ArrayList<DocumentVO> arrayList = results;
                Object var9_11 = null;
                IOUtils.closeQuietly((Reader)buffer);
                IOUtils.closeQuietly((Reader)reader);
                try {
                    FileUtils.deleteDirectory((File)tempDirectory);
                    return arrayList;
                }
                catch (IOException e2) {
                    logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                }
                return arrayList;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            IOUtils.closeQuietly(buffer);
            IOUtils.closeQuietly(reader);
            try {}
            catch (IOException e2) {
                logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                throw throwable;
            }
            FileUtils.deleteDirectory((File)tempDirectory);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DocumentVO unzip(DocumentVO document) throws CDXException {
        FileReader reader = null;
        BufferedReader buffer = null;
        File tempDirectory = null;
        int i = 1;
        if (!document.getDocumentType().equals((Object)DocumentType.ZIP)) {
            throw new CDXException(CDXErrorCode.INVALID_DOCUMENT_TYPE, (Throwable)new IllegalArgumentException("document is invalid for unzipping"));
        }
        try {
            try {
                DocumentVO unzippedDocument;
                tempDirectory = ExtractorManager.getTempDirectory(document.getID());
                FileUtils.forceMkdir((File)tempDirectory);
                File fullFile = ExtractorManager.writeFileToDisk(tempDirectory, document);
                reader = new FileReader(fullFile);
                buffer = new BufferedReader(reader);
                document.setDocumentType(DocumentType.XML);
                DocumentVO documentVO = unzippedDocument = ExtractorManager.createDocument(fullFile, document, i);
                Object var7_9 = null;
                IOUtils.closeQuietly((Reader)buffer);
                IOUtils.closeQuietly((Reader)reader);
                try {
                    FileUtils.deleteDirectory((File)tempDirectory);
                    return documentVO;
                }
                catch (IOException e2) {
                    logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                }
                return documentVO;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
            }
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            IOUtils.closeQuietly(buffer);
            IOUtils.closeQuietly(reader);
            try {}
            catch (IOException e2) {
                logger.error((Object)("unable to delete directory " + tempDirectory), (Throwable)e2);
                throw throwable;
            }
            FileUtils.deleteDirectory((File)tempDirectory);
            throw throwable;
        }
    }

    private static boolean isValid(DocumentVO document) {
        DocumentType type = document.getDocumentType();
        return document != null && document.getData() != null && document.getData().length > 0 && (type.equals((Object)DocumentType.ZIP) || type.equals((Object)DocumentType.HEADER) || type.equals((Object)DocumentType.XML));
    }

    private static File getTempDirectory(String documentId) throws CDXException {
        String tempdirPath = null;
        NodeKey nodeKey = new NodeKey("TempDir", NodeVersion.V10);
        NodeVersionVO versionVO = null;
        try {
            versionVO = NodeMgr.getNodeByNodeKey(nodeKey);
        }
        catch (Throwable throwable) {}
        if (!(versionVO != null && (tempdirPath = versionVO.getUrl()) != null || new File(tempdirPath = System.getProperty("java.io.tmpdir")).canWrite())) {
            tempdirPath = "." + File.separator;
        }
        return new File(String.valueOf(tempdirPath) + File.separator + documentId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static File writeFileToDisk(File path, DocumentVO document) throws Exception {
        File file;
        BufferedOutputStream out = null;
        File file2 = new File(path + File.separator + document.getName());
        try {
            try {
                out = new BufferedOutputStream(new FileOutputStream(file2));
                CopyUtils.copy((byte[])document.getData(), (OutputStream)out);
                if (document.getDocumentType().equals((Object)DocumentType.ZIP)) {
                    if (ZipUtil.zipEntries((File)file2).size() != 1) {
                        throw new IllegalArgumentException("can not extract payload when zipfile has multiple entries");
                    }
                    String temp = String.valueOf(document.getID()) + "-unzipped.xml";
                    ZipUtil.unzip((File)file2, (File)path, (String)temp);
                    file2 = new File(path + File.separator + temp);
                }
                file = file2;
                Object var5_7 = null;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            IOUtils.closeQuietly(out);
            throw throwable;
        }
        IOUtils.closeQuietly((OutputStream)out);
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DocumentVO createDocument(File payloadFile, DocumentVO original, int count) throws Exception {
        DocumentVO documentVO;
        DocumentVO result = new DocumentVO();
        result.setDataFlowType(original.getDataflowTypeVO());
        result.setDocumentType(original.getDocumentType());
        BufferedInputStream fileIn = null;
        BufferedOutputStream fileOut = null;
        ZipOutputStream zipOut = null;
        try {
            try {
                File tempFile;
                if (original.getDocumentType().equals((Object)DocumentType.ZIP)) {
                    tempFile = new File(String.valueOf(payloadFile.getParent()) + File.separator + original.getID() + "-payload" + count + ".zip");
                    fileOut = new BufferedOutputStream(new FileOutputStream(tempFile));
                    zipOut = new ZipOutputStream(fileOut);
                    ZipEntry entry = new ZipEntry(String.valueOf(original.getID()) + "-payload" + count + ".xml");
                    zipOut.putNextEntry(entry);
                    fileIn = new BufferedInputStream(new FileInputStream(payloadFile));
                    CopyUtils.copy((InputStream)fileIn, (OutputStream)zipOut);
                    IOUtils.closeQuietly((InputStream)fileIn);
                    IOUtils.closeQuietly((OutputStream)zipOut);
                    IOUtils.closeQuietly((OutputStream)fileOut);
                } else {
                    tempFile = payloadFile;
                }
                fileIn = new BufferedInputStream(new FileInputStream(tempFile));
                byte[] data = IOUtils.toByteArray((InputStream)fileIn);
                result.setData(data);
                result.setName(tempFile.getName());
                documentVO = result;
                Object var9_11 = null;
            }
            catch (Exception e) {
                logger.error((Object)e);
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            IOUtils.closeQuietly(zipOut);
            IOUtils.closeQuietly(fileOut);
            IOUtils.closeQuietly(fileIn);
            throw throwable;
        }
        IOUtils.closeQuietly(zipOut);
        IOUtils.closeQuietly(fileOut);
        IOUtils.closeQuietly((InputStream)fileIn);
        return documentVO;
    }
}

