/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.extractor;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class HeaderHandler
extends DefaultHandler {
    private boolean activated = false;
    private XMLStreamWriter xmlw;

    public HeaderHandler(OutputStream out) throws XMLStreamException {
        this.xmlw = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
    }

    public HeaderHandler(Writer out) throws XMLStreamException {
        this.xmlw = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
    }

    public void startDocument() throws SAXException {
        try {
            this.xmlw.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.xmlw.writeEndDocument();
            this.xmlw.flush();
            this.xmlw.close();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.xmlw.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] chars, int i, int i1) throws SAXException {
        try {
            if (this.activated) {
                this.xmlw.writeCharacters(chars, i, i1);
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
        this.characters(chars, i, i1);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if (this.activated || "Document".equals(localName) || "Payload".equals(localName)) {
                this.xmlw.writeEndElement();
            }
            if ("Header".equals(localName)) {
                this.activated = false;
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if ("Header".equals(localName)) {
                this.activated = true;
            }
            if (this.activated || "Document".equals(localName) || "Payload".equals(localName)) {
                this.xmlw.writeStartElement(uri, qName);
                int i = 0;
                while (i < atts.getLength()) {
                    this.xmlw.writeAttribute(atts.getQName(i), atts.getValue(i));
                    ++i;
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }
}

