/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.extractor;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.commons.io.IOUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MultiPayloadHandler
extends DefaultHandler {
    private boolean activated;
    private XMLStreamWriter xmlw;
    private int count;
    private String filePrefix;
    private FileWriter writer;
    private List files;

    public MultiPayloadHandler(String filePrefix) {
        this.filePrefix = filePrefix;
        this.activated = false;
        this.count = 0;
        this.xmlw = null;
        this.files = new ArrayList();
    }

    private void createWriter() throws RuntimeException {
        try {
            File temp = new File(String.valueOf(this.filePrefix) + "-payload" + this.count++ + ".xml");
            this.writer = new FileWriter(temp);
            this.xmlw = XMLOutputFactory.newInstance().createXMLStreamWriter(this.writer);
            this.files.add(temp);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void closeWriter() throws RuntimeException {
        try {
            IOUtils.closeQuietly((Writer)this.writer);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void startDocument() throws SAXException {
    }

    public void endDocument() throws SAXException {
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.xmlw.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] chars, int i, int i1) throws SAXException {
        try {
            if (this.activated) {
                this.xmlw.writeCharacters(chars, i, i1);
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
        this.characters(chars, i, i1);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if ("Payload".equals(localName)) {
                this.activated = false;
                this.xmlw.writeEndDocument();
                this.xmlw.flush();
                this.xmlw.close();
                this.closeWriter();
            } else if (this.activated) {
                this.xmlw.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        try {
            if ("Payload".equals(localName)) {
                this.activated = true;
                this.createWriter();
                this.xmlw.writeStartDocument();
            } else if (this.activated) {
                this.xmlw.writeStartElement(uri, qName);
                int i = 0;
                while (i < atts.getLength()) {
                    this.xmlw.writeAttribute(atts.getQName(i), atts.getValue(i));
                    ++i;
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public List getFiles() {
        return this.files;
    }
}

