/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.extractor;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class PayloadHandler
extends DefaultHandler {
    private boolean activated = false;
    private boolean parsed = false;
    private XMLStreamWriter xmlw;

    public PayloadHandler(OutputStream out) throws XMLStreamException {
        this.xmlw = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
    }

    public PayloadHandler(Writer out) throws XMLStreamException {
        this.xmlw = XMLOutputFactory.newInstance().createXMLStreamWriter(out);
    }

    public void startDocument() throws SAXException {
        try {
            this.xmlw.writeStartDocument();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.xmlw.writeEndDocument();
            this.xmlw.flush();
            this.xmlw.close();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.xmlw.writeProcessingInstruction(target, data);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void characters(char[] chars, int i, int i1) throws SAXException {
        try {
            if (this.activated) {
                this.xmlw.writeCharacters(chars, i, i1);
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] chars, int i, int i1) throws SAXException {
        this.characters(chars, i, i1);
    }

    public void endElement(String uri, String localName, String qName) throws SAXException {
        try {
            if ("Payload".equals(localName)) {
                this.activated = false;
                this.parsed = true;
            } else if (this.activated) {
                this.xmlw.writeEndElement();
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void startElement(String uri, String localName, String qName, Attributes atts) throws SAXException {
        if (this.parsed) {
            throw new SAXException("can not extract payload when there are multiple payloads");
        }
        try {
            if ("Payload".equals(localName)) {
                this.activated = true;
            } else if (this.activated) {
                this.xmlw.writeStartElement(uri, qName);
                int i = 0;
                while (i < atts.getLength()) {
                    this.xmlw.writeAttribute(atts.getQName(i), atts.getValue(i));
                    ++i;
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }
}

