/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.node;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.infrastructure.node.dao.NodeDAO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVO;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.node.NodeVersionVO;
import java.util.Collection;

public class NodeMgr {
    private static final NodeKey HOST_NODE_KEY = new NodeKey("HostNode", NodeVersion.V10);

    public static void createNode(NodeVO node) throws CDXException {
        NodeDAO.insert(node);
    }

    public static NodeVO getNode(String nodeId) throws CDXException {
        return NodeDAO.load(nodeId);
    }

    public static NodeVersionVO getNodeByNodeKey(NodeKey key) throws CDXException {
        NodeVO vo = NodeDAO.load(key.getID());
        String url = vo.getNodeVersionByVersion(key.getVersion());
        NodeVersionVO nodeVersionVO = new NodeVersionVO(vo.getNodeId(), vo.getHostIp(), vo.getName(), key.getVersion(), url);
        return nodeVersionVO;
    }

    public static void deleteNode(String nodeId) throws CDXException {
        NodeDAO.delete(nodeId);
    }

    public static Collection getAllPublicNodes() throws CDXException {
        return NodeDAO.getAllPublicNodes();
    }

    public static NodeKey getNodeByUrl(String url) throws CDXException {
        NodeKey nodeKey = NodeDAO.getNodeIdByUrl(url);
        return nodeKey;
    }

    public static String getUrlByNode(String node) throws CDXException {
        String url = null;
        try {
            NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(new NodeKey(node, NodeVersion.V10));
            url = nodeVersion.getUrl();
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.PROPERTY_EXCEPTION, (Throwable)ex);
        }
        return url;
    }

    public static String getNodeIdByHostIP(String hostIP) throws CDXException {
        return NodeDAO.getNodeIdByHostIp(hostIP);
    }

    public static String getCurrentServerURL() throws CDXException {
        String hostNodeURL = null;
        try {
            NodeVersionVO nodeVersion = NodeMgr.getNodeByNodeKey(HOST_NODE_KEY);
            hostNodeURL = nodeVersion.getUrl();
        }
        catch (Exception ex) {
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        return hostNodeURL;
    }
}

