/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.node.dao;

import gov.epa.cdx.commons.basedao.dao.BaseDAO;
import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVO;
import gov.epa.cdx.model.node.NodeVersion;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class NodeDAO {
    protected static LogInterface log;
    private static final String SELECT_SQL = "SELECT cdx.node_host_ip_tx, cdx.node_name_tx, nodeversions.version_id, nodeversions.url_tx FROM cdx_nodes cdx, cdx_node_versions nodeversions WHERE ((cdx.node_id = nodeversions.node_id) AND (cdx.node_id = ?))";
    private static final String INSERT_SQL_NODETABLE = "INSERT INTO cdx_nodes (node_id, node_host_ip_tx, node_name_tx) VALUES (?, ?, ?)";
    private static final String INSERT_SQL_NODEVERSIONTABLE = "INSERT INTO cdx_node_versions (node_id, version_id, url_tx) VALUES (?, ?, ?)";
    private static final String DELETE_SQL_NODEVERSIONTABLE = "DELETE FROM cdx_node_versions cdx WHERE ((cdx.node_id = ?))";
    private static final String DELETE_SQL_NODETABLE = "DELETE FROM cdx_nodes cdx WHERE ((cdx.node_id = ?))";
    private static final String SELECT_SQL_ALLNODES = "SELECT cdx.node_id FROM cdx_nodes cdx WHERE ((cdx.node_type_id='PUBLIC'))";
    private static final String SELECT_SQL_NODE_ID_BY_URL = "SELECT cdx.node_id, nodeversion.version_id FROM cdx_nodes cdx, cdx_node_versions nodeversion  WHERE ((cdx.node_id = nodeversion.node_id) AND (nodeversion.url_tx = ?))";
    private static final String SELECT_SQL_NODE_ID_BY_HOST_IP = "SELECT cdx.node_id  FROM cdx_nodes cdx WHERE ( (cdx.node_host_ip_tx = ?) )";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.node.dao.NodeDAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeVO load(String nodeId) throws CDXException {
        block13: {
            nodeVO = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT cdx.node_host_ip_tx, cdx.node_name_tx, nodeversions.version_id, nodeversions.url_tx FROM cdx_nodes cdx, cdx_node_versions nodeversions WHERE ((cdx.node_id = nodeversions.node_id) AND (cdx.node_id = ?))");
                    pstmt.setString(1, nodeId);
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        nodeIP = result.getString("node_host_ip_tx");
                        nodeName = result.getString("node_name_tx");
                        versionId = result.getString("version_id");
                        versionUrl = result.getString("url_tx");
                        if (nodeVO == null) {
                            nodeVO = new NodeVO(nodeId, nodeIP, nodeName);
                        }
                        nodeVO.addNodeVersionUrl(NodeVersion.getNodeVersionById((String)versionId), versionUrl);
                    }
                }
                catch (CDXDAOException e) {
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    NodeDAO.log.error((Object)("Unable to perform load opertation for nodeID: " + nodeId), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    NodeDAO.log.error((Object)("Error happend inside NodeDAO class, load method, for nodeID: " + nodeId), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var10_12) {
                var9_13 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    NodeDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var10_12;
            }
            {
                var9_14 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 235->251)] { 
lbl44:
            // 1 sources

            result.close();
            pstmt.close();
            break block13;
lbl47:
            // 1 sources

            catch (Exception ex) {
                NodeDAO.log.error((Object)"Couldn't close ResultSet or PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return nodeVO;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insert(NodeVO nodeVO) throws CDXException {
        block15: {
            connection = null;
            pstmt = null;
            pstmtNodeVersion = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement("INSERT INTO cdx_nodes (node_id, node_host_ip_tx, node_name_tx) VALUES (?, ?, ?)");
                    pstmt.setString(1, nodeVO.getNodeId());
                    pstmt.setString(2, nodeVO.getHostIp());
                    pstmt.setString(3, nodeVO.getName());
                    if (pstmt.executeUpdate() != 1) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_NODE_ID);
                    }
                    it = nodeVO.getVersionUrlMap().keySet().iterator();
                    while (true) {
                        block14: {
                            if (it.hasNext()) break block14;
                            connection.commit();
                            break;
                        }
                        nodeVersion = (NodeVersion)it.next();
                        url = nodeVO.getNodeVersionByVersion(nodeVersion);
                        pstmtNodeVersion = connection.prepareStatement("INSERT INTO cdx_node_versions (node_id, version_id, url_tx) VALUES (?, ?, ?)");
                        pstmtNodeVersion.setString(1, nodeVO.getNodeId());
                        pstmtNodeVersion.setString(2, nodeVersion.toString());
                        pstmtNodeVersion.setString(3, url);
                        pstmtNodeVersion.executeUpdate();
                        pstmtNodeVersion.close();
                    }
                }
                catch (CDXDAOException e) {
                    BaseDAO.rollback((Connection)connection);
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    BaseDAO.rollback((Connection)connection);
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    NodeDAO.log.error((Object)("Unable to perform insert for node id: " + nodeVO.getNodeId()), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    BaseDAO.rollback((Connection)connection);
                    NodeDAO.log.error((Object)("Error happend inside NodeDAO class, insert method, for nodeID: " + nodeVO.getNodeId()), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var8_11) {
                var7_12 = null;
                try {
                    pstmtNodeVersion.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    NodeDAO.log.error((Object)"Couldn't close PrepareStatement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var8_11;
            }
            {
                var7_13 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 342->357)] { 
lbl60:
            // 1 sources

            pstmtNodeVersion.close();
            pstmt.close();
            break block15;
lbl63:
            // 1 sources

            catch (Exception ex) {
                NodeDAO.log.error((Object)"Couldn't close PrepareStatement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void delete(String nodeId) throws CDXException {
        block13: {
            connection = null;
            pstmt = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    connection.setAutoCommit(false);
                    pstmt = connection.prepareStatement("DELETE FROM cdx_node_versions cdx WHERE ((cdx.node_id = ?))");
                    pstmt.setString(1, nodeId);
                    pstmt.executeUpdate();
                    pstmt.close();
                    pstmt = connection.prepareStatement("DELETE FROM cdx_nodes cdx WHERE ((cdx.node_id = ?))");
                    pstmt.setString(1, nodeId);
                    if (pstmt.executeUpdate() != 1) {
                        NodeDAO.log.error((Object)("Could perform delete for the specified nodeID: " + nodeId));
                        throw new CDXValidationException(CDXErrorCode.INVALID_NODE_ID);
                    }
                    connection.commit();
                }
                catch (CDXDAOException e) {
                    BaseDAO.rollback((Connection)connection);
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    BaseDAO.rollback((Connection)connection);
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    NodeDAO.log.error((Object)("Unable to perform delete for nodeID: " + nodeId), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    BaseDAO.rollback((Connection)connection);
                    NodeDAO.log.error((Object)("Error happend inside NodeDAO class, delete method, for nodeID: " + nodeId), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var5_7) {
                var4_8 = null;
                try {
                    pstmt.close();
                }
                catch (Exception v0) {
                    NodeDAO.log.error((Object)"Experience problems while closing one of the following:  resultset or prepared statements or connection ");
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var5_7;
            }
            {
                var4_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 249->258)] { 
lbl48:
            // 1 sources

            pstmt.close();
            break block13;
lbl50:
            // 1 sources

            catch (Exception v1) {
                NodeDAO.log.error((Object)"Experience problems while closing one of the following:  resultset or prepared statements or connection ");
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllPublicNodes() throws CDXException {
        block12: {
            allNodes = new ArrayList<NodeVO>();
            nodeVO = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT cdx.node_id FROM cdx_nodes cdx WHERE ((cdx.node_type_id='PUBLIC'))");
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        nodeID = result.getString("node_id");
                        nodeVO = NodeDAO.load(nodeID);
                        allNodes.add(nodeVO);
                    }
                }
                catch (CDXDAOException e) {
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    NodeDAO.log.error((Object)"Unable to get All Public Nodes", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    NodeDAO.log.error((Object)"Error happend inside NodeDAO class, getAllPublicNodes method", (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var7_9) {
                var6_10 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception v0) {
                    NodeDAO.log.error((Object)"Experience problems while closing one of the following:  resultset or prepared statements or connection ");
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var7_9;
            }
            {
                var6_11 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 161->177)] { 
lbl41:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl44:
            // 1 sources

            catch (Exception v1) {
                NodeDAO.log.error((Object)"Experience problems while closing one of the following:  resultset or prepared statements or connection ");
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return allNodes;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static NodeKey getNodeIdByUrl(String url) throws CDXException {
        block12: {
            nodeKey = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT cdx.node_id, nodeversion.version_id FROM cdx_nodes cdx, cdx_node_versions nodeversion  WHERE ((cdx.node_id = nodeversion.node_id) AND (nodeversion.url_tx = ?))");
                    pstmt.setString(1, url);
                    result = pstmt.executeQuery();
                    if (result.next() == false) throw new CDXValidationException(CDXErrorCode.NODE_NOT_FOUND);
                    nodeId = result.getString("node_id");
                    nodeVersion = result.getString("version_id");
                    nodeKey = new NodeKey(nodeId, NodeVersion.getNodeVersionById((String)nodeVersion));
                }
                catch (CDXDAOException e) {
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    NodeDAO.log.error((Object)("Unable find NodeID by url: " + url), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    NodeDAO.log.error((Object)("Error happend inside NodeDAO class, getNodeIdByUrl method for url:  " + url), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var8_11) {
                var7_12 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception v0) {
                    NodeDAO.log.error((Object)"Experience problems while closing one of the following:  resultset or prepared statements or connection ");
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var8_11;
            }
            {
                var7_13 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 231->247)] { 
lbl42:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl45:
            // 1 sources

            catch (Exception v1) {
                NodeDAO.log.error((Object)"Experience problems while closing one of the following:  resultset or prepared statements or connection ");
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return nodeKey;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getNodeIdByHostIp(String hostIP) throws CDXException {
        block12: {
            nodeId = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT cdx.node_id  FROM cdx_nodes cdx WHERE ( (cdx.node_host_ip_tx = ?) )");
                    pstmt.setString(1, hostIP);
                    result = pstmt.executeQuery();
                    if (result.next() == false) throw new CDXValidationException(CDXErrorCode.NODE_NOT_FOUND);
                    nodeId = result.getString("node_id");
                }
                catch (CDXDAOException e) {
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    NodeDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    NodeDAO.log.error((Object)("Unable to get NodeId By HostIp: " + hostIP), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    NodeDAO.log.error((Object)("Error happend inside NodeDAO class, getNodeIdByHostIp method, for ip: " + hostIP), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var7_9) {
                var6_10 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception v0) {
                    NodeDAO.log.error((Object)"Experience problems while closing one of the following:  resultset or prepared statements or connection ");
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var7_9;
            }
            {
                var6_11 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 204->220)] { 
lbl40:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl43:
            // 1 sources

            catch (Exception v1) {
                NodeDAO.log.error((Object)"Experience problems while closing one of the following:  resultset or prepared statements or connection ");
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return nodeId;
    }
}

