/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.notification;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.auditor.Audit;
import gov.epa.cdx.infrastructure.distributor.DistributorFactory;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.distributor.Distributor;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentStatusVO;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.Collection;
import java.util.Iterator;

public class NotificationMgr {
    protected static Audit audit;
    private static final String NOTIFICATION_CATEGORY_KEY = "Notification";
    private static final String STATUS_NOTIFICATION;
    private static final String EVENT_NOTIFICATION;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.notification.NotificationMgr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        audit = new Audit(clazz.getName());
        STATUS_NOTIFICATION = CDXPropertyManager.getProperty((String)NOTIFICATION_CATEGORY_KEY, (String)"Status", (String)"http://www.exchangenetwork.net/node/status");
        EVENT_NOTIFICATION = CDXPropertyManager.getProperty((String)NOTIFICATION_CATEGORY_KEY, (String)"Event", (String)"http://www.exchangenetwork.net/node/event");
    }

    public static boolean isEventNotification(DataflowTypeVO dataflowType) {
        boolean result = false;
        if (EVENT_NOTIFICATION.equalsIgnoreCase(dataflowType.toString())) {
            result = true;
        }
        return result;
    }

    public static boolean isStatusNotification(DataflowTypeVO dataflowType) {
        boolean result = false;
        if (STATUS_NOTIFICATION.equalsIgnoreCase(dataflowType.toString())) {
            result = true;
        }
        return result;
    }

    public static boolean isDocumentNotification(DataflowTypeVO dataflowType) {
        boolean result = false;
        if (!STATUS_NOTIFICATION.equalsIgnoreCase(dataflowType.toString()) && !EVENT_NOTIFICATION.equalsIgnoreCase(dataflowType.toString())) {
            result = true;
        }
        return result;
    }

    private static String setStatus(DocumentList documentList, boolean documentStatus) throws CDXException {
        DataflowTypeVO dataflowTypeVO = null;
        String transactionId = null;
        String returnId = null;
        String documentName = null;
        String documentId = null;
        Iterator it = documentList.getDocuments().iterator();
        while (it.hasNext()) {
            DocumentVO statusDocument = (DocumentVO)it.next();
            String status = statusDocument.getDocumentType().toString();
            Status.isValid((String)status);
            if (documentStatus) {
                documentId = statusDocument.getName();
                TransactionVO transactionVO = new TransactionVO();
                transactionVO = DocumentMgr.getTransactionForDocument(documentId);
                transactionId = transactionVO.getTransactionID();
                DocumentMgr.updateDocumentStatus(documentId, new DocumentStatusVO(status));
                DocumentVO document = DocumentMgr.getDocument(documentId);
                documentName = document.getName();
                dataflowTypeVO = document.getDataflowTypeVO();
                returnId = transactionId;
            } else {
                documentName = transactionId = statusDocument.getName();
                try {
                    Collection tasks = TaskManager.searchForTasksByTransaction(transactionId);
                    if (tasks != null && tasks.size() > 0) {
                        TaskVO task = (TaskVO)tasks.iterator().next();
                        dataflowTypeVO = new DataflowTypeVO((String)task.getTaskParameters().get("DataFlowKey"));
                    }
                }
                catch (Exception exception) {
                    dataflowTypeVO = null;
                }
                returnId = transactionId;
            }
            TransactionMgr.updateTransactionStatus(transactionId, Status.getStatusById((String)status));
            byte[] content = statusDocument.getData();
            if (content == null || content.length <= 0) continue;
            if (dataflowTypeVO == null) {
                dataflowTypeVO = new DataflowTypeVO("NODE");
                audit.info(transactionId, "Cannot determine dataflow from transaction id.  Status report is saved with dataflow <" + dataflowTypeVO.getDataflowType() + ">", null);
            }
            NotificationMgr.setStatusReport(transactionId, documentName, dataflowTypeVO, statusDocument.getData(), documentStatus);
        }
        if (documentStatus) {
            NotificationMgr.updateApplicationStatus(transactionId, dataflowTypeVO, documentList);
        }
        return returnId;
    }

    public static String setTransactionStatus(DocumentList documentList) throws CDXException {
        return NotificationMgr.setStatus(documentList, false);
    }

    public static String setDocumentStatus(DocumentList documentList) throws CDXException {
        return NotificationMgr.setStatus(documentList, true);
    }

    private static void setStatusReport(String transactionId, String documentName, DataflowTypeVO dataflowTypeVO, byte[] report, boolean documentStatus) throws CDXException {
        if (report.length > 0) {
            String fileName = null;
            fileName = documentStatus ? "DocumentStatus_" + documentName + ".txt" : "TransactionStatus_" + documentName + ".txt";
            TransactionVO transactionVO = TransactionMgr.getTransaction(transactionId);
            DocumentVO document = new DocumentVO(GUID.getGUID(), fileName, DocumentType.FLAT.toString(), dataflowTypeVO.toString(), report);
            document.setStatus(new DocumentStatusVO(Status.REPORT.toString()));
            DocumentMgr.createDocument(transactionVO, document);
        }
    }

    private static void updateApplicationStatus(String transactionId, DataflowTypeVO dataflowTypeVO, DocumentList documentList) throws CDXException {
        try {
            if (dataflowTypeVO != null) {
                Distributor distributor = DistributorFactory.getDistributor(dataflowTypeVO.getDataflowType());
                distributor.updateDistributionStatus(documentList);
            }
        }
        catch (Exception exception) {
            audit.failure(transactionId, exception.getMessage(), exception);
            throw new CDXException(CDXErrorCode.ERROR_UPDATING_DISTRIBUTION_STATUS, (Throwable)exception);
        }
    }
}

