/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.scheduler;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.scheduler.dao.TaskDAO;
import gov.epa.cdx.infrastructure.services.ParameterManager;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentType;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.scheduler.SearchVO;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class TaskManager {
    protected static LogInterface log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.scheduler.TaskManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static void saveTask(TaskVO task) throws CDXException {
        Collection nodeKeys = null;
        TransactionVO trVO = null;
        NodeKey nodeKey = null;
        if (task == null) {
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Couldn't save Task, if Task object is NULL!"));
        }
        nodeKeys = task.getTaskNodeKeys();
        if (nodeKeys.isEmpty()) {
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)new Exception("Couldn't save Task, if Task doesn't have NodeKeys!"));
        }
        try {
            Iterator iter = nodeKeys.iterator();
            while (iter.hasNext()) {
                nodeKey = (NodeKey)iter.next();
                trVO = task.getTaskTransaction(nodeKey);
                if (trVO != null) continue;
                trVO = TransactionMgr.create();
                task.setTaskTransaction(nodeKey, trVO);
            }
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)ex);
        }
        task = TaskManager.saveBlobParameters(task, trVO);
        TaskDAO.insertTask(task);
    }

    private static TaskVO saveBlobParameters(TaskVO task, TransactionVO trVO) throws CDXException {
        Map parameters = task.getTaskParameters();
        Iterator iter = parameters.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!ParameterManager.isParameterTypeBlob(key)) continue;
            byte[] data = ((String)parameters.get(key)).getBytes();
            String documentId = TaskManager.saveValueAsDocument(trVO, data);
            parameters.put(key, documentId);
        }
        task.setTaskParameters(parameters);
        return task;
    }

    private static String saveValueAsDocument(TransactionVO trVO, byte[] data) throws CDXException {
        String documentId = null;
        DocumentVO documentVO = new DocumentVO(documentId, "Blob Parameter Content", DocumentType.BINARY, new DataflowTypeVO("NODE"), data);
        documentId = DocumentMgr.createDocument(trVO, documentVO);
        return documentId;
    }

    public static void updateTask(TaskVO task) throws CDXException {
        throw new RuntimeException("This Method isn't implemented yet.");
    }

    public static void deleteTask(TaskVO task) throws CDXException {
        TaskStatus status = null;
        if (task == null) {
            log.error((Object)"Called deleteTask with Task equal NULL.");
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Couldn't delete Task, if Task object is NULL!"));
        }
        status = TaskManager.getLatestTaskStatus(task.getTaskID());
        if (!status.equals((Object)TaskStatus.NotStarted)) {
            log.error((Object)("Invalid state of Task. I try to delete Task with Status:" + status.toString()));
            throw new CDXValidationException(CDXErrorCode.VALIDATION_ERROR, (Throwable)new Exception("Invalid state of Task. I try to delete Task with Status:" + status.toString()));
        }
        TaskDAO.deleteTask(task);
    }

    public static TaskVO loadTask(String taskID) throws CDXException {
        TaskVO task = TaskDAO.loadTask(taskID);
        task = TaskManager.loadBlobParameters(task);
        return task;
    }

    private static TaskVO loadBlobParameters(TaskVO task) throws CDXException {
        Map parameters = task.getTaskParameters();
        Iterator iter = parameters.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            if (!ParameterManager.isParameterTypeBlob(key)) continue;
            String documentId = (String)parameters.get(key);
            DocumentVO document = DocumentMgr.getDocument(documentId);
            parameters.put(key, new String(document.getData()));
        }
        task.setTaskParameters(parameters);
        return task;
    }

    public static Collection searchForTasksByTransaction(String transactionID) throws CDXException {
        Collection ids = TaskDAO.searchForTasksByTransactionId(transactionID);
        return ids;
    }

    public static TaskVO loadTaskByTransactionIdAndTaskType(String transactionID, TaskTypeVO taskType) throws CDXException {
        String taskID = TaskDAO.getTaskIdByTransactionIdAndTaskType(transactionID, taskType.toString());
        TaskVO taskVO = TaskDAO.loadTask(taskID);
        return taskVO;
    }

    public static TaskStatus getLatestTaskStatus(String taskID) throws CDXException {
        return TaskManager.loadTask(taskID).getStatus();
    }

    public static Collection searchForTasksByDateAndTypeAndStatus(Long startDate, Long endDate, TaskTypeVO type, String status) throws CDXException {
        return TaskDAO.searchForTaskByDateAndTypeAndStatus(startDate, endDate, type, status);
    }

    public static Collection searchForTasksByTypeAndTaskStatus(TaskTypeVO taskType, TaskStatus status) throws CDXException {
        Collection taskIds = TaskDAO.searchForTasksByTypeAndTaskStatus(taskType, status);
        ArrayList<TaskVO> tasks = new ArrayList<TaskVO>();
        Iterator it = taskIds.iterator();
        while (it.hasNext()) {
            String taskID = (String)it.next();
            TaskVO vo = TaskManager.loadTask(taskID);
            tasks.add(vo);
        }
        return tasks;
    }

    public static void updateTaskParameterValue(String taskId, String parameterName, String parameterValue) throws CDXException {
        if (ParameterManager.isParameterTypeBlob(parameterName)) {
            parameterValue = TaskManager.saveValueAsDocument(TransactionMgr.create(), parameterValue.getBytes());
        }
        TaskDAO.updateTaskParameterByParameterNameAndTaskId(taskId, parameterName, parameterValue);
    }

    public static void insertTaskParameter(String taskId, String parameterName, String parameterValue) throws CDXException {
        if (ParameterManager.isParameterTypeBlob(parameterName)) {
            parameterValue = TaskManager.saveValueAsDocument(TransactionMgr.create(), parameterValue.getBytes());
        }
        TaskDAO.insertTaskParameter(taskId, parameterName, parameterValue);
    }

    public static void setTaskStatus(TaskVO task) throws CDXException {
        if (task == null) {
            log.error((Object)"Called setTaskStatus with Task equal NULL.");
            throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Couldn't update status of Task, if Task object is NULL!"));
        }
        TaskDAO.setTaskStatus(task.getTaskID(), task.getStatus());
    }

    public static Collection advancedTaskSearch(SearchVO search) throws CDXException {
        return TaskDAO.advancedTaskSearch(search);
    }
}

