/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.scheduler;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.FileManager;
import gov.epa.cdx.infrastructure.document.DocumentMgr;
import gov.epa.cdx.infrastructure.scheduler.TaskManager;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentList;
import gov.epa.cdx.model.document.DocumentVO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.io.File;
import java.io.FileOutputStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TaskManagerTest
extends TestCase {
    protected static LogInterface log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.scheduler.TaskManagerTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public TaskManagerTest() {
        super("TaskManagerTest");
    }

    public TaskManagerTest(String name) {
        super(name);
    }

    public void testExecuteDistributeToICTS() {
        CDXPropertyManager.init((String)CDXPropertyManager.GLOBAL_CONFIG_FILE, (String)CDXPropertyManager.GLOBAL_CONFIG_FILE);
        CDXPropertyManager.loadProperties();
        String transactionId = "de5904c6-68cc-432b-b713-5de7d2eb2c50";
        try {
            TaskManager.loadTaskByTransactionIdAndTaskType(transactionId, new TaskTypeVO("DISTRIBUTE"));
        }
        catch (CDXException e) {
            e.printStackTrace();
            Assert.fail();
        }
    }

    private void saveTaskExecuteResult(TaskVO task, Collection nodeKeys) {
        TransactionVO trVO = null;
        NodeKey nodeKey = null;
        DocumentList docs = null;
        try {
            Iterator iter = nodeKeys.iterator();
            while (iter.hasNext()) {
                nodeKey = (NodeKey)iter.next();
                trVO = task.getTaskTransaction(nodeKey);
                docs = DocumentMgr.getAllDocuments(trVO.getTransactionID());
                this.saveDocs(docs);
            }
        }
        catch (Exception ex) {
            log.error((Object)"", (Throwable)ex);
        }
    }

    private void saveDocs(DocumentList docs) {
        FileOutputStream out = null;
        String fileName = "";
        String dirName = "";
        File dirObject = null;
        File fileObject = null;
        Collection col = docs.getDocuments();
        DocumentVO docVO = null;
        if (docs != null) {
            Iterator iter = col.iterator();
            while (iter.hasNext()) {
                docVO = (DocumentVO)iter.next();
                dirName = "c:\\cdx_files\\" + docVO.getDataflowTypeVO().getDataflowType().toString() + "\\";
                fileName = docVO.getName();
                try {
                    dirObject = FileManager.createDirectory((String)dirName);
                    fileObject = FileManager.createFile((File)dirObject, (String)fileName);
                    out = new FileOutputStream(fileObject);
                    out.write(docVO.getData());
                    out.close();
                }
                catch (Exception ex) {
                    log.error((Object)"", (Throwable)ex);
                }
            }
        } else {
            System.out.println("### Array of Documents are NULL");
        }
    }

    private void createAllParameters(Map parameters, Collection taskNodeKeys) {
        NodeKey nodeKey = null;
        try {
            parameters.put("DataFlowKey", new DataflowTypeVO("TEST"));
            parameters.put("ServiceTypeKey", "GetFacilityByNameOrID");
            parameters.put("All", "All%");
            nodeKey = new NodeKey("Nebraska", NodeVersion.V09);
            taskNodeKeys.add(nodeKey);
            nodeKey = new NodeKey("SQL Data Server", NodeVersion.V09);
            taskNodeKeys.add(nodeKey);
            nodeKey = new NodeKey("CDX Server", NodeVersion.V09);
            taskNodeKeys.add(nodeKey);
        }
        catch (Exception ex) {
            Assert.fail((String)("Exception: " + ex.getMessage()));
        }
        System.out.println("Parameters created.");
    }

    public void testSearchByDateAndTaskType() {
        TaskTypeVO taskType = new TaskTypeVO("QUERY");
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yyyy");
        try {
            Date startDate = formatter.parse("04/25/2003");
            Long endDate = new Long(startDate.getTime() + 86400000L);
            Collection ids = TaskManager.searchForTasksByDateAndTypeAndStatus(new Long(startDate.getTime()), endDate, taskType, null);
            System.out.println(ids.size());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail();
        }
    }
}

