/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.scheduler.dao;

import gov.epa.cdx.aspects.qos.DataflowMonitoring;
import gov.epa.cdx.commons.basedao.dao.BaseDAO;
import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.transaction.dao.TransactionDAO;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.SearchVO;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TaskDAO {
    protected static LogInterface log;
    private static String INSERT_SQL_TASKTABLE;
    private static String INSERT_SQL_TASKPARAMTABLE;
    private static String INSERT_SQL_TASKTRANSNODESTABLE;
    private static String DELETE_SQL_TASKTABLE;
    private static String DELETE_SQL_TASK_PARAMS;
    private static String DELETE_SQL_TASK_TRANS_NODES;
    private static String SELECT_SQL_TASK;
    private static String SELECT_SQL_TASK_PARAM;
    private static String SELECT_SQL_TASK_TRANS_NODE;
    private static String UPDATE_SQL_STATUS;
    private static String SELECT_SQL_TASKID_BY_TRANSACTIONID;
    private static String SELECT_SQL_TASKID_BY_TASK_TYPE_AND_TASK_STATUS;
    private static String SELECT_SQL_TASKID_BY_TRANSACTIONID_AND_TASKTYPE;
    private static String SELECT_SQL_TASKID_BY_DATE_AND_TASKTYPE;
    private static String SELECT_SQL_TASKID_BY_DATE_AND_TASKTYPE_AND_TASK_STATUS;
    private static String SELECT_SQL_TASKID_BY_DATE_AND_TASK_STATUS;
    private static String UPDATED_TASK_PARAMETER_BY_TASKID_AND_PARAMETER_NAME;
    private static String SELECT_TASK_STATUS_IDS;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("TaskDAO.java", Class.forName("gov.epa.cdx.infrastructure.scheduler.dao.TaskDAO"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-setTaskStatus-gov.epa.cdx.infrastructure.scheduler.dao.TaskDAO-java.lang.String:gov.epa.cdx.model.scheduler.TaskStatus:-taskID:newStatus:-gov.epa.cdx.commons.exception.CDXException:-void-"), 680);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.scheduler.dao.TaskDAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        INSERT_SQL_TASKTABLE = "INSERT INTO CDX_TASKS (TASK_ID, TASK_STATUS_ID, TASK_TYPE_ID, TASK_START_TM, TASK_DESCRIPTION_TX,  CREATOR_TX ) VALUES (?, ?, ?, ?, ?, ? )";
        INSERT_SQL_TASKPARAMTABLE = "Insert into cdx_task_parameters ( TASK_ID, PARAMETER_NAME_TX, PARAMETER_VALUE_TX) VALUES (?, ?, ?)";
        INSERT_SQL_TASKTRANSNODESTABLE = "INSERT INTO CDX_TASK_TRANS_NODES  ( TASK_ID, TRANSACTION_ID, NODE_ID,  VERSION_ID) VALUES (?, ?, ?, ?)";
        DELETE_SQL_TASKTABLE = "DELETE FROM CDX_TASKS task  WHERE (task.task_id = ?)";
        DELETE_SQL_TASK_PARAMS = "DELETE FROM CDX_TASK_PARAMETERS tp  WHERE (tp.task_id = ?)";
        DELETE_SQL_TASK_TRANS_NODES = "DELETE FROM CDX_TASK_TRANS_NODES ttn  WHERE (ttn.task_id = ?)";
        SELECT_SQL_TASK = "select t.TASK_STATUS_ID, t.TASK_TYPE_ID, t.TASK_START_TM, t.TASK_DESCRIPTION_TX from cdx_tasks t  where (t.TASK_ID= ?)";
        SELECT_SQL_TASK_PARAM = "select PARAMETER_NAME_TX, PARAMETER_VALUE_TX  from cdx_task_parameters tp  where (tp.TASK_ID= ?)";
        SELECT_SQL_TASK_TRANS_NODE = "select NODE_ID, TRANSACTION_ID,  VERSION_ID   from cdx_task_trans_nodes ttp  where (ttp.TASK_ID= ?)";
        UPDATE_SQL_STATUS = "UPDATE CDX_TASKS SET TASK_STATUS_ID = ? Where TASK_ID = ?";
        SELECT_SQL_TASKID_BY_TRANSACTIONID = "SELECT TASK_ID  FROM cdx_task_trans_nodes  where cdx_task_trans_nodes.TRANSACTION_ID= ?";
        SELECT_SQL_TASKID_BY_TASK_TYPE_AND_TASK_STATUS = " SELECT cdx_tasks.task_id FROM cdx_tasks WHERE ((cdx_tasks.task_type_id = ?) AND (cdx_tasks.task_status_id = ?))";
        SELECT_SQL_TASKID_BY_TRANSACTIONID_AND_TASKTYPE = "SELECT cdx_tasks.TASK_ID  FROM cdx_tasks, cdx_task_trans_nodes  where cdx_tasks.TASK_ID= cdx_task_trans_nodes.TASK_ID  and cdx_task_trans_nodes.TRANSACTION_ID= ?  and cdx_tasks.TASK_TYPE_ID= ?";
        SELECT_SQL_TASKID_BY_DATE_AND_TASKTYPE = "SELECT cdx_tasks.TASK_ID  FROM cdx_tasks  where (cdx_tasks.CREATED_TM > ?  and cdx_tasks.CREATED_TM < ?)  and cdx_tasks.TASK_TYPE_ID = ? ";
        SELECT_SQL_TASKID_BY_DATE_AND_TASKTYPE_AND_TASK_STATUS = "SELECT cdx_tasks.TASK_ID  FROM cdx_tasks  where (cdx_tasks.CREATED_TM > ?  and cdx_tasks.CREATED_TM < ?)  and cdx_tasks.TASK_TYPE_ID = ?  and cdx_tasks.TASK_STATUS_ID = ? ";
        SELECT_SQL_TASKID_BY_DATE_AND_TASK_STATUS = "SELECT cdx_tasks.TASK_ID  FROM cdx_tasks  where (cdx_tasks.CREATED_TM > ?  and cdx_tasks.CREATED_TM < ?)  and cdx_tasks.TASK_STATUS_ID = ? ";
        UPDATED_TASK_PARAMETER_BY_TASKID_AND_PARAMETER_NAME = "UPDATE CDX_TASK_PARAMETERS  SET PARAMETER_VALUE_TX = ? WHERE TASK_ID = ? AND PARAMETER_NAME_TX= ?";
        SELECT_TASK_STATUS_IDS = "select distinct TASK_STATUS_ID from cdx_tasks order by 1";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTaskIdByTransactionIdAndTaskType(String transactionID, String taskType) throws CDXException {
        block13: {
            taskID = null;
            con = null;
            pstmtTaskID = null;
            result = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtTaskID = con.prepareStatement(TaskDAO.SELECT_SQL_TASKID_BY_TRANSACTIONID_AND_TASKTYPE);
                    pstmtTaskID.setString(1, transactionID);
                    pstmtTaskID.setString(2, taskType);
                    result = pstmtTaskID.executeQuery();
                    if (!result.next()) {
                        TaskDAO.log.error((Object)("No records for taskID were retrieved from the database for transaction: " + transactionID + " and for taskType : " + taskType));
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_ID);
                    }
                    taskID = result.getString("TASK_ID");
                }
                catch (CDXDAOException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    TaskDAO.log.error((Object)("Unable to get TaskId By TransactionId and task type:" + transactionID), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)("Error happened inside TaskDAO class, getTaskIdByTransactionId method,  for transactionID: " + transactionID), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var8_10) {
                var7_11 = null;
                try {
                    pstmtTaskID.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var8_10;
            }
            {
                var7_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 245->255)] { 
lbl42:
            // 1 sources

            pstmtTaskID.close();
            break block13;
lbl44:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
        return taskID;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getTaskStatusIds() throws CDXException {
        block10: {
            con = null;
            pstmtTaskID = null;
            result = null;
            list = new ArrayList<String>();
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtTaskID = con.prepareStatement(TaskDAO.SELECT_TASK_STATUS_IDS);
                    result = pstmtTaskID.executeQuery();
                    while (result.next()) {
                        taskStatusId = result.getString("TASK_STATUS_ID");
                        list.add(taskStatusId);
                    }
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Error happened inside TaskDAO class, getTaskStatusIds method, ", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var6_6) {
                var5_7 = null;
                try {
                    pstmtTaskID.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statements", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var6_6;
            }
            {
                var5_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 106->115)] { 
lbl32:
            // 1 sources

            pstmtTaskID.close();
            break block10;
lbl34:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statements", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection searchForTasksByTypeAndTaskStatus(TaskTypeVO taskType, TaskStatus status) throws CDXException {
        block10: {
            con = null;
            pstmtTaskID = null;
            result = null;
            list = new ArrayList<String>();
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtTaskID = con.prepareStatement(TaskDAO.SELECT_SQL_TASKID_BY_TASK_TYPE_AND_TASK_STATUS);
                    pstmtTaskID.setString(1, taskType.getType());
                    pstmtTaskID.setString(2, status.toString());
                    result = pstmtTaskID.executeQuery();
                    while (result.next()) {
                        taskId = result.getString("TASK_ID");
                        list.add(taskId);
                    }
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Error happened inside TaskDAO class, searchForTasksByTransactionId method,  for transactionID: ", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var8_8) {
                var7_9 = null;
                try {
                    pstmtTaskID.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var8_8;
            }
            {
                var7_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 133->142)] { 
lbl34:
            // 1 sources

            pstmtTaskID.close();
            break block10;
lbl36:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection searchForTasksByTransactionId(String transactionID) throws CDXException {
        block13: {
            con = null;
            pstmtTaskID = null;
            result = null;
            list = new ArrayList<String>();
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtTaskID = con.prepareStatement(TaskDAO.SELECT_SQL_TASKID_BY_TRANSACTIONID);
                    pstmtTaskID.setString(1, transactionID);
                    result = pstmtTaskID.executeQuery();
                    while (result.next()) {
                        taskId = result.getString("TASK_ID");
                        list.add(taskId);
                    }
                }
                catch (CDXDAOException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    TaskDAO.log.error((Object)("Couldnt not perform a search for tasks by:" + transactionID), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)("Error happened inside TaskDAO class, searchForTasksByTransactionId method,  for transactionID: " + transactionID), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var7_10) {
                var6_11 = null;
                try {
                    pstmtTaskID.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var7_10;
            }
            {
                var6_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 205->214)] { 
lbl42:
            // 1 sources

            pstmtTaskID.close();
            break block13;
lbl44:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insertTask(TaskVO task) throws CDXException {
        block15: {
            con = null;
            pstmtTask = null;
            pstmtTaskParams = null;
            pstmtTaskNodeTrans = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    con.setAutoCommit(false);
                    pstmtTask = con.prepareStatement(TaskDAO.INSERT_SQL_TASKTABLE);
                    pstmtTask.setString(1, task.getTaskID());
                    pstmtTask.setString(2, task.getStatus().toString());
                    pstmtTask.setString(3, task.getTaskType().toString());
                    pstmtTask.setTimestamp(4, new Timestamp(task.getTaskStartTime()));
                    pstmtTask.setString(5, task.getTaskDescription());
                    pstmtTask.setString(6, "cdxadmin");
                    pstmtTask.executeUpdate();
                    pstmtTaskParams = con.prepareStatement(TaskDAO.INSERT_SQL_TASKPARAMTABLE);
                    parameters = task.getTaskParameters();
                    iter = parameters.keySet().iterator();
                    key = null;
                    value = null;
                    while (true) {
                        if (!iter.hasNext()) break;
                        key = (String)iter.next();
                        value = (String)parameters.get(key);
                        pstmtTaskParams.setString(1, task.getTaskID());
                        pstmtTaskParams.setString(2, key);
                        pstmtTaskParams.setString(3, value);
                        pstmtTaskParams.executeUpdate();
                    }
                    pstmtTaskNodeTrans = con.prepareStatement(TaskDAO.INSERT_SQL_TASKTRANSNODESTABLE);
                    nodeKeys = task.getTaskNodeKeys();
                    trVO = null;
                    nodeKey = null;
                    iter = nodeKeys.iterator();
                    while (true) {
                        block14: {
                            if (iter.hasNext()) break block14;
                            con.commit();
                            break;
                        }
                        nodeKey = (NodeKey)iter.next();
                        trVO = task.getTaskTransaction(nodeKey);
                        pstmtTaskNodeTrans.setString(1, task.getTaskID());
                        pstmtTaskNodeTrans.setString(2, trVO.getTransactionID());
                        pstmtTaskNodeTrans.setString(3, nodeKey.getID());
                        pstmtTaskNodeTrans.setString(4, nodeKey.getVersion().toString());
                        pstmtTaskNodeTrans.executeUpdate();
                    }
                }
                catch (CDXDAOException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)("Unable to insert new row for TaskId :" + task.getTaskID()), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)("Error happened inside TaskDAO class, insert method,  for taskID: " + task.getTaskID()), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var13_16) {
                var12_17 = null;
                try {
                    pstmtTask.close();
                    pstmtTaskParams.close();
                    pstmtTaskNodeTrans.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var13_16;
            }
            {
                var12_18 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 513->535)] { 
lbl83:
            // 1 sources

            pstmtTask.close();
            pstmtTaskParams.close();
            pstmtTaskNodeTrans.close();
            break block15;
lbl87:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insertTaskParameter(String taskId, String parameterName, String parameterValue) throws CDXException {
        block9: {
            con = null;
            pstmtTask = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtTask = con.prepareStatement(TaskDAO.INSERT_SQL_TASKPARAMTABLE);
                    pstmtTask.setString(1, taskId);
                    pstmtTask.setString(2, parameterName);
                    pstmtTask.setString(3, parameterValue);
                    pstmtTask.executeUpdate();
                    con.commit();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)("Inserting " + parameterName + "=" + parameterValue + " for task " + taskId), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var7_6) {
                var6_7 = null;
                try {
                    pstmtTask.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var7_6;
            }
            {
                var6_8 = null;
            }
            ** try [egrp 2[TRYBLOCK] [3 : 136->146)] { 
lbl30:
            // 1 sources

            pstmtTask.close();
            break block9;
lbl32:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void deleteTask(TaskVO task) throws CDXException {
        block17: {
            con = null;
            pstmtDeleteTask = null;
            pstmtDeleteTaskParam = null;
            pstmtDeleteTaskTransNode = null;
            trVO = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    con.setAutoCommit(false);
                    pstmtDeleteTaskParam = con.prepareStatement(TaskDAO.DELETE_SQL_TASK_PARAMS);
                    pstmtDeleteTaskParam.setString(1, task.getTaskID());
                    pstmtDeleteTaskParam.executeUpdate();
                    pstmtDeleteTaskTransNode = con.prepareStatement(TaskDAO.DELETE_SQL_TASK_TRANS_NODES);
                    pstmtDeleteTaskTransNode.setString(1, task.getTaskID());
                    if (pstmtDeleteTaskTransNode.executeUpdate() == 0) {
                        TaskDAO.log.error((Object)("No record(s) were deleted from  cdx_task_trans_nodes table for task: " + task.getTaskID()));
                        throw new CDXValidationException(CDXErrorCode.INVALID_TASK_ID);
                    }
                    pstmtDeleteTask = con.prepareStatement(TaskDAO.DELETE_SQL_TASKTABLE);
                    pstmtDeleteTask.setString(1, task.getTaskID());
                    if (pstmtDeleteTask.executeUpdate() != 1) {
                        TaskDAO.log.error((Object)("No record(s) were deleted from task table for task : " + task.getTaskID()));
                        throw new CDXValidationException(CDXErrorCode.INVALID_TASK_ID);
                    }
                    con.commit();
                    trans = task.getTransactions();
                    iter = trans.iterator();
                    while (iter.hasNext()) {
                        try {
                            trVO = (TransactionVO)iter.next();
                            TransactionDAO.delete(trVO.getTransactionID());
                        }
                        catch (Exception delEx) {
                            TaskDAO.log.error((Object)("Couldn't delete Transaction for TaskID=" + task.getTaskID() + ", because Exception occurred:" + delEx.getMessage()));
                        }
                    }
                }
                catch (CDXDAOException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)("Unable to delete task with TaskId :" + task.getTaskID()), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)("Error happened inside TaskDAO class, deleteTask method,  for taskID: " + task.getTaskID()), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var10_13) {
                var9_14 = null;
                try {
                    pstmtDeleteTask.close();
                    pstmtDeleteTaskParam.close();
                    pstmtDeleteTaskTransNode.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var10_13;
            }
            {
                var9_15 = null;
            }
            ** try [egrp 3[TRYBLOCK] [7 : 447->469)] { 
lbl67:
            // 1 sources

            pstmtDeleteTask.close();
            pstmtDeleteTaskParam.close();
            pstmtDeleteTaskTransNode.close();
            break block17;
lbl71:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TaskVO loadTask(String taskID) throws CDXException {
        block16: {
            con = null;
            pstmtTaskLoad = null;
            pstmtTaskParamLoad = null;
            pstmtTaskDetailsLoad = null;
            result = null;
            newTask = null;
            taskDescription = null;
            taskType = null;
            taskStartTime = 0L;
            taskStatus = null;
            taskParameters = new HashMap<String, String>();
            taskNodeKeyTransactionDetails = new HashMap<NodeKey, TransactionVO>();
            paramName = null;
            paramValue = null;
            nodeID = null;
            nodeVersion = null;
            trVO = null;
            nodeKey = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtTaskLoad = con.prepareStatement(TaskDAO.SELECT_SQL_TASK);
                    pstmtTaskLoad.setString(1, taskID);
                    result = pstmtTaskLoad.executeQuery();
                    if (!result.next()) {
                        TaskDAO.log.error((Object)("No records were retrieved from the database for task: " + taskID));
                        throw new CDXValidationException(CDXErrorCode.INVALID_TASK_ID);
                    }
                    taskStatus = TaskStatus.getTaskTypeByID((String)result.getString("TASK_STATUS_ID"));
                    taskType = new TaskTypeVO(result.getString("TASK_TYPE_ID"));
                    taskDescription = result.getString("TASK_DESCRIPTION_TX");
                    taskStartTime = result.getTimestamp("TASK_START_TM").getTime();
                    result.close();
                    pstmtTaskParamLoad = con.prepareStatement(TaskDAO.SELECT_SQL_TASK_PARAM);
                    pstmtTaskParamLoad.setString(1, taskID);
                    result = pstmtTaskParamLoad.executeQuery();
                    while (true) {
                        if (!result.next()) break;
                        paramName = result.getString("PARAMETER_NAME_TX");
                        paramValue = result.getString("PARAMETER_VALUE_TX");
                        taskParameters.put(paramName, paramValue);
                    }
                    result.close();
                    pstmtTaskDetailsLoad = con.prepareStatement(TaskDAO.SELECT_SQL_TASK_TRANS_NODE);
                    pstmtTaskDetailsLoad.setString(1, taskID);
                    result = pstmtTaskDetailsLoad.executeQuery();
                    while (true) {
                        block15: {
                            if (result.next()) break block15;
                            result.close();
                            newTask = new TaskVO(taskID, taskDescription, taskType, taskStartTime, taskStatus, taskParameters, taskNodeKeyTransactionDetails);
                            break;
                        }
                        nodeID = result.getString("NODE_ID");
                        nodeVersion = result.getString("VERSION_ID");
                        nodeKey = new NodeKey(nodeID, NodeVersion.getNodeVersionById((String)nodeVersion));
                        trVO = TransactionDAO.load(result.getString("TRANSACTION_ID"));
                        taskNodeKeyTransactionDetails.put(nodeKey, trVO);
                    }
                }
                catch (CDXDAOException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    TaskDAO.log.error((Object)("Unable to load information for TaskId :" + taskID), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)("Error happend inside TaskDAO class, loadTask method,  for taskID: " + taskID), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var22_23) {
                var21_24 = null;
                try {
                    pstmtTaskLoad.close();
                    pstmtTaskParamLoad.close();
                    pstmtTaskDetailsLoad.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var22_23;
            }
            {
                var21_25 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 554->576)] { 
lbl87:
            // 1 sources

            pstmtTaskLoad.close();
            pstmtTaskParamLoad.close();
            pstmtTaskDetailsLoad.close();
            break block16;
lbl91:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
        return newTask;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void setTaskStatus(String var0, TaskStatus var1_1) throws CDXException {
        block13: {
            var9_2 = var0;
            var10_3 = var1_1;
            var8_4 = Factory.makeJP((JoinPoint.StaticPart)TaskDAO.ajc$tjp_0, null, null, (Object)var9_2, (Object)var10_3);
            con = null;
            pstmtTask = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtTask = con.prepareStatement(TaskDAO.UPDATE_SQL_STATUS);
                    pstmtTask.setString(1, newStatus.toString());
                    pstmtTask.setString(2, taskID);
                    if (pstmtTask.executeUpdate() == 0) {
                        TaskDAO.log.error((Object)("Couldn't update Status of the Task, if Task doesn't exists! Task ID is " + taskID));
                        throw new CDXValidationException(CDXErrorCode.INVALID_TASK_ID);
                    }
                }
                catch (CDXDAOException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)("Unable to update status of the task for TaskId :" + taskID), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    BaseDAO.rollback((Connection)con);
                    TaskDAO.log.error((Object)("Error happend inside TaskDAO class, updateTaskStatus method,  for taskID: " + taskID), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var6_11) {
                var5_12 = null;
                try {
                    pstmtTask.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var6_11;
            }
            {
                var5_13 = null;
            }
            ** try [egrp 2[TRYBLOCK] [1 : 249->258)] { 
lbl45:
            // 1 sources

            pstmtTask.close();
            break block13;
lbl47:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
        DataflowMonitoring.aspectOf().ajc$afterReturning$gov_epa_cdx_aspects_qos_DataflowMonitoring$3$c8e9c681(var8_4);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection searchForTaskByDateAndType(Long startDate, Long endDate, TaskTypeVO type) throws CDXException {
        block13: {
            list = new ArrayList<String>();
            con = null;
            pstmtTaskID = null;
            result = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    pstmtTaskID = con.prepareStatement(TaskDAO.SELECT_SQL_TASKID_BY_DATE_AND_TASKTYPE);
                    pstmtTaskID.setTimestamp(1, new Timestamp(startDate));
                    pstmtTaskID.setTimestamp(2, new Timestamp(endDate));
                    pstmtTaskID.setString(3, type.toString());
                    result = pstmtTaskID.executeQuery();
                    while (result.next()) {
                        taskId = result.getString("TASK_ID");
                        list.add(taskId);
                    }
                }
                catch (CDXDAOException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    TaskDAO.log.error((Object)("Unable to get TaskIds By date and task type:" + type), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)("Error happend inside TaskDAO class, searchForTaskByDateAndType method,  for type: " + type), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var9_12) {
                var8_13 = null;
                try {
                    pstmtTaskID.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var9_12;
            }
            {
                var8_14 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 255->265)] { 
lbl44:
            // 1 sources

            pstmtTaskID.close();
            break block13;
lbl46:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection searchForTaskByDateAndTypeAndStatus(Long startDate, Long endDate, TaskTypeVO type, String status) throws CDXException {
        block17: {
            list = new ArrayList<String>();
            con = null;
            pstmtTaskID = null;
            result = null;
            try {
                try {
                    con = BaseDAO.getConnection();
                    if (status == null) {
                        pstmtTaskID = con.prepareStatement(TaskDAO.SELECT_SQL_TASKID_BY_DATE_AND_TASKTYPE);
                        pstmtTaskID.setTimestamp(1, new Timestamp(startDate));
                        pstmtTaskID.setTimestamp(2, new Timestamp(endDate));
                        pstmtTaskID.setString(3, type.toString());
                    } else if (type == null) {
                        pstmtTaskID = con.prepareStatement(TaskDAO.SELECT_SQL_TASKID_BY_DATE_AND_TASK_STATUS);
                        pstmtTaskID.setTimestamp(1, new Timestamp(startDate));
                        pstmtTaskID.setTimestamp(2, new Timestamp(endDate));
                        pstmtTaskID.setString(3, status);
                    } else {
                        pstmtTaskID = con.prepareStatement(TaskDAO.SELECT_SQL_TASKID_BY_DATE_AND_TASKTYPE_AND_TASK_STATUS);
                        pstmtTaskID.setTimestamp(1, new Timestamp(startDate));
                        pstmtTaskID.setTimestamp(2, new Timestamp(endDate));
                        pstmtTaskID.setString(3, type.toString());
                        pstmtTaskID.setString(4, status);
                    }
                    result = pstmtTaskID.executeQuery();
                    while (result.next()) {
                        taskId = result.getString("TASK_ID");
                        list.add(taskId);
                    }
                }
                catch (CDXDAOException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (CDXValidationException ex) {
                    TaskDAO.log.error((Object)"", (Throwable)ex);
                    throw ex;
                }
                catch (SQLException ex) {
                    TaskDAO.log.error((Object)("Unable to get TaskIds By date and task type:" + type), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)("Error happend inside TaskDAO class, searchForTaskByDateAndType method,  for type: " + type), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)ex);
                }
            }
            catch (Throwable var10_13) {
                var9_14 = null;
                try {
                    pstmtTaskID.close();
                }
                catch (Exception ex) {
                    TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)con);
                throw var10_13;
            }
            {
                var9_15 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 401->411)] { 
lbl57:
            // 1 sources

            pstmtTaskID.close();
            break block17;
lbl59:
            // 1 sources

            catch (Exception ex) {
                TaskDAO.log.error((Object)"Couldn't close prepared statments", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)con);
        return list;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void updateTaskParameterByParameterNameAndTaskId(String taskId, String parameterName, String parameterValue) throws CDXException {
        Connection con = null;
        PreparedStatement stmt = null;
        try {
            try {
                con = BaseDAO.getConnection();
                stmt = con.prepareStatement(UPDATED_TASK_PARAMETER_BY_TASKID_AND_PARAMETER_NAME);
                stmt.setString(1, parameterValue);
                stmt.setString(2, taskId);
                stmt.setString(3, parameterName);
                if (stmt.executeUpdate() == 0) {
                    log.error((Object)("No record(s) were updatedfor task: " + taskId + "and parameter Name" + parameterName));
                    throw new CDXValidationException(CDXErrorCode.INVALID_TASK_ID);
                }
            }
            catch (CDXException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error((Object)"", (Throwable)ex);
                throw new CDXException(CDXErrorCode.INVALID_TASK_ID);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            BaseDAO.closeConnection((Connection)con);
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        BaseDAO.closeConnection((Connection)con);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection advancedTaskSearch(SearchVO search) throws CDXException {
        Connection con = null;
        Statement stmt = null;
        ArrayList<TaskVO> list = new ArrayList<TaskVO>();
        ResultSet result = null;
        HashMap<String, String> taskIDsList = new HashMap<String, String>();
        try {
            try {
                con = BaseDAO.getConnection();
                String sql = search.getTaskSQL();
                if (sql == null) throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Advanced Task Search SQL is EMPTY!"));
                if (sql.trim().length() == 0) {
                    throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Advanced Task Search SQL is EMPTY!"));
                }
                stmt = con.prepareStatement(sql);
                result = stmt.executeQuery();
                while (result.next()) {
                    String taskID = result.getString("TASK_ID");
                    if (taskIDsList.containsKey(taskID)) continue;
                    taskIDsList.put(taskID, taskID);
                    TaskVO task = null;
                    task = TaskDAO.loadTask(taskID);
                    list.add(task);
                }
            }
            catch (CDXException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.error((Object)"Couldn't perform Advanced Task Search!", (Throwable)ex);
                throw new CDXException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)new Exception("Couldn't perform Advanced Task Search! Error:" + ex.getMessage()));
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            try {
                if (result != null) {
                    result.close();
                }
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (SQLException sQLException) {}
            BaseDAO.closeConnection((Connection)con);
            throw throwable;
        }
        {
            Object var9_13 = null;
        }
        try {}
        catch (SQLException sQLException) {}
        if (result != null) {
            result.close();
        }
        if (stmt != null) {
            stmt.close();
        }
        BaseDAO.closeConnection((Connection)con);
        return list;
    }
}

