/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.scheduler.dao;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.scheduler.dao.TaskDAO;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.model.node.NodeKey;
import gov.epa.cdx.model.node.NodeVersion;
import gov.epa.cdx.model.scheduler.TaskStatus;
import gov.epa.cdx.model.scheduler.TaskTypeVO;
import gov.epa.cdx.model.scheduler.TaskVO;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.HashMap;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TaskDAOTest
extends TestCase {
    public TaskDAOTest() {
        super("TaskDAOTest");
    }

    public TaskDAOTest(String name) {
        super(name);
    }

    public void testInsert() {
        TaskVO task = null;
        try {
            task = this.createTask();
            try {
                TaskDAO.insertTask(task);
            }
            catch (CDXException ex) {
                Assert.fail((String)("Exception: " + ex.getMessage()));
            }
            TaskDAO.deleteTask(task);
        }
        catch (CDXException ex) {
            Assert.fail((String)("Exception: " + ex.getMessage()));
        }
    }

    public void testLoad() {
        TaskVO task = null;
        TaskVO newTask = null;
        try {
            task = this.createTask();
            TaskDAO.insertTask(task);
            try {
                newTask = TaskDAO.loadTask(task.getTaskID());
                System.out.println("newTask is eqauls: " + newTask.equals(task));
                System.out.println(newTask);
            }
            catch (CDXException ex) {
                Assert.fail((String)("Exception: " + ex.getMessage()));
            }
            TaskDAO.deleteTask(task);
        }
        catch (CDXException ex) {
            Assert.fail((String)("Exception: " + ex.getMessage()));
        }
    }

    public void testGetTaskIdByTransactionIdAndTaskType() {
        String taskID = null;
        try {
            taskID = TaskDAO.getTaskIdByTransactionIdAndTaskType("08033a2c-67d7-4618-83fa-e1159fc15ccf", "DATA_FLOW_QUERY");
            System.out.println(taskID);
        }
        catch (CDXException ex) {
            Assert.fail((String)("Exception: " + ex.getMessage()));
        }
    }

    private TaskVO createTask() throws CDXException {
        TaskVO newTask = null;
        String taskDescription = "TaskDAO test";
        TaskTypeVO taskType = new TaskTypeVO("QUERY");
        long taskStartTime = System.currentTimeMillis();
        TaskStatus taskStatus = TaskStatus.NotStarted;
        HashMap<String, String> taskParameters = new HashMap<String, String>();
        HashMap<NodeKey, TransactionVO> taskNodeKeyTransactionDetails = new HashMap<NodeKey, TransactionVO>();
        TransactionVO trVO = null;
        NodeKey nodeKey = null;
        int i = 0;
        while (i < 3) {
            taskParameters.put("name" + i, "value" + i);
            ++i;
        }
        nodeKey = new NodeKey("testid", NodeVersion.V08);
        i = 0;
        while (i < 2) {
            trVO = TransactionMgr.create();
            taskNodeKeyTransactionDetails.put(nodeKey, trVO);
            ++i;
        }
        newTask = new TaskVO(GUID.getGUID(), taskDescription, taskType, taskStartTime, taskStatus, taskParameters, taskNodeKeyTransactionDetails);
        return newTask;
    }
}

