/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.servicelookup;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.infrastructure.servicelookup.dao.ServiceLookupDAO;
import gov.epa.cdx.model.commons.QueryVO;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentType;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ServiceLookupMgr {
    public static Collection getAllDataflowNames() throws CDXException {
        return ServiceLookupDAO.getAllDataFlows();
    }

    public static Collection getAllServiceNames() throws CDXException {
        return ServiceLookupDAO.getAllServiceNames();
    }

    public static Collection getAllServiceNamesByDataflow(String dataFlowName) throws CDXException {
        return ServiceLookupDAO.getAllServiceTypeNames(dataFlowName);
    }

    public static Collection getAllServiceParameterNamesByService(String serviceName) throws CDXException {
        return ServiceLookupDAO.getAllParameterNamesByServiceName(serviceName);
    }

    public static DataflowTypeVO getDataflowByServiceName(String serviceName) throws CDXException {
        return ServiceLookupDAO.getDataflowByServiceName(serviceName);
    }

    public static String[] orderParameters(Map parameters, String serviceName) throws CDXException {
        Collection orderedParameterNames = ServiceLookupMgr.getAllServiceParameterNamesByService(serviceName);
        String[] orderedValues = new String[orderedParameterNames.size()];
        int i = 0;
        Iterator iter = orderedParameterNames.iterator();
        while (iter.hasNext()) {
            String value;
            String parameterName = (String)iter.next();
            orderedValues[i] = value = (String)parameters.get(parameterName);
            ++i;
        }
        return orderedValues;
    }

    public static Map mapQueryParameters(QueryVO queryVO) throws CDXException {
        HashMap<String, String> queryParameters = new HashMap<String, String>();
        DataflowTypeVO dataFlowType = ServiceLookupMgr.getDataflowByServiceName(queryVO.getServiceName());
        queryParameters.put("DataFlowKey", dataFlowType.toString());
        queryParameters.put("ServiceTypeKey", queryVO.getServiceName());
        queryParameters.put("FileType", DocumentType.XML.toString());
        if (queryVO.getReturnURL() != null) {
            queryParameters.put("RequestorUrlKey", queryVO.getReturnURL());
        }
        Iterator orderedParamterNames = ServiceLookupMgr.getAllServiceParameterNamesByService(queryVO.getServiceName()).iterator();
        int i = 0;
        while (i < queryVO.getParameters().length) {
            queryParameters.put((String)orderedParamterNames.next(), queryVO.getParameters()[i]);
            ++i;
        }
        return queryParameters;
    }
}

