/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.servicelookup.dao;

import gov.epa.cdx.commons.basedao.dao.BaseDAO;
import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXServerException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;

public class ServiceLookupDAO {
    private static final LogInterface log;
    private static final String SELECT_ALLSERVICES_SQL = "SELECT cdx.service_name_tx FROM cdx_services cdx";
    private static final String SELECT_ALLDATAFLOWS_SQL = "SELECT cdx.dataflow_type_id FROM cdx_dataflow_types cdx";
    private static final String SELECT_ALLSERVICETYPES_SQL = "SELECT cdx.dataflow_type_id, cdx.service_name_tx FROM cdx_services cdx WHERE ((cdx.dataflow_type_id = ?))";
    private static final String SELECT_ALL_PARAMETERS_ORDERED_BY_ORDERNUMBER_SQL = "SELECT PARAMETERS.parameter_name_tx FROM cdx_service_parameters cdx, cdx_services services, cdx_parameters PARAMETERS WHERE (    (services.service_id = cdx.service_id) AND (PARAMETERS.parameter_id_num = cdx.parameter_id_num) AND (services.service_name_tx = ?)) ORDER BY cdx.position_num ASC";
    private static final String SELECT_DATAFLOW_BY_SERVICE_SQL = "SELECT cdx.dataflow_type_id FROM cdx_services cdx WHERE ((cdx.service_name_tx = ?))";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.servicelookup.dao.ServiceLookupDAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllServiceNames() throws CDXException {
        block14: {
            connection = null;
            pstmt = null;
            result = null;
            allServiceNameList = new ArrayList<String>();
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT cdx.service_name_tx FROM cdx_services cdx");
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        serviceName = result.getString("service_name_tx");
                        allServiceNameList.add(serviceName);
                    }
                }
                catch (SQLException ex) {
                    throw new CDXServerException(CDXErrorCode.DATABASE_FAILURE, (Throwable)ex);
                }
                catch (Exception e) {
                    throw new CDXServerException(CDXErrorCode.INTERNAL_SERVER_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var6_7) {
                var5_8 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    ServiceLookupDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
                }
                try {
                    connection.close();
                    throw var6_7;
                }
                catch (Exception ex) {
                    ServiceLookupDAO.log.error((Object)"Could not close connection", (Throwable)ex);
                }
                throw var6_7;
            }
            {
                var5_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [4 : 106->121)] { 
lbl38:
            // 1 sources

            result.close();
            pstmt.close();
            break block14;
lbl41:
            // 1 sources

            catch (Exception ex) {
                ServiceLookupDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
            }
        }
        try {}
        catch (Exception ex) {
            ServiceLookupDAO.log.error((Object)"Could not close connection", (Throwable)ex);
            return allServiceNameList;
        }
        connection.close();
        return allServiceNameList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllDataFlows() throws CDXException {
        block12: {
            connection = null;
            pstmt = null;
            result = null;
            allDataFlowsList = new ArrayList<String>();
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT cdx.dataflow_type_id FROM cdx_dataflow_types cdx");
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        dataFlowName = result.getString("dataflow_type_id");
                        allDataFlowsList.add(dataFlowName);
                    }
                }
                catch (CDXDAOException e) {
                    ServiceLookupDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    ServiceLookupDAO.log.error((Object)"Unable to get all available dataflows from the database.", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    ServiceLookupDAO.log.error((Object)"Exception happend while trying to get all available dataflows from the database.", (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var6_8) {
                var5_9 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    ServiceLookupDAO.log.error((Object)"Could not close prepared statement or result set", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var6_8;
            }
            {
                var5_10 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 147->162)] { 
lbl39:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl42:
            // 1 sources

            catch (Exception ex) {
                ServiceLookupDAO.log.error((Object)"Could not close prepared statement or result set", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return allDataFlowsList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllServiceTypeNames(String dataFlowId) throws CDXException {
        block12: {
            connection = null;
            pstmt = null;
            result = null;
            allServiceNameList = new ArrayList<String>();
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT cdx.dataflow_type_id, cdx.service_name_tx FROM cdx_services cdx WHERE ((cdx.dataflow_type_id = ?))");
                    pstmt.setString(1, dataFlowId);
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        serviceName = result.getString("service_name_tx");
                        allServiceNameList.add(serviceName);
                    }
                }
                catch (CDXDAOException e) {
                    ServiceLookupDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    ServiceLookupDAO.log.error((Object)"Unable to get all available service type names from the database.", (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    ServiceLookupDAO.log.error((Object)"Exception happend while trying to get all available service type names from the database.", (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var7_9) {
                var6_10 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    ServiceLookupDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var7_9;
            }
            {
                var6_11 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 157->172)] { 
lbl40:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl43:
            // 1 sources

            catch (Exception ex) {
                ServiceLookupDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return allServiceNameList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Collection getAllParameterNamesByServiceName(String serviceName) throws CDXException {
        block12: {
            connection = null;
            pstmt = null;
            result = null;
            allParameterNameList = new ArrayList<String>();
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT PARAMETERS.parameter_name_tx FROM cdx_service_parameters cdx, cdx_services services, cdx_parameters PARAMETERS WHERE (    (services.service_id = cdx.service_id) AND (PARAMETERS.parameter_id_num = cdx.parameter_id_num) AND (services.service_name_tx = ?)) ORDER BY cdx.position_num ASC");
                    pstmt.setString(1, serviceName);
                    result = pstmt.executeQuery();
                    while (result.next()) {
                        parameterName = result.getString("parameter_name_tx");
                        allParameterNameList.add(parameterName);
                    }
                }
                catch (CDXDAOException e) {
                    ServiceLookupDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    ServiceLookupDAO.log.error((Object)("Unable to get all parameter names  from the database for service name: " + serviceName), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    ServiceLookupDAO.log.error((Object)("Exception happend while trying to get parameter names for  service name:" + serviceName), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var7_9) {
                var6_10 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    ServiceLookupDAO.log.error((Object)"Could not close prepared statement or resultset", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var7_9;
            }
            {
                var6_11 = null;
            }
            ** try [egrp 2[TRYBLOCK] [5 : 185->200)] { 
lbl40:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl43:
            // 1 sources

            catch (Exception ex) {
                ServiceLookupDAO.log.error((Object)"Could not close prepared statement or resultset", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return allParameterNameList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DataflowTypeVO getDataflowByServiceName(String serviceName) throws CDXException {
        block12: {
            connection = null;
            pstmt = null;
            result = null;
            dataFlowType = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement("SELECT cdx.dataflow_type_id FROM cdx_services cdx WHERE ((cdx.service_name_tx = ?))");
                    pstmt.setString(1, serviceName);
                    result = pstmt.executeQuery();
                    if (result.next() == false) throw new CDXValidationException(CDXErrorCode.INVALID_SERVICE_REQUEST_NAME);
                    dataFlow = result.getString("dataflow_type_id");
                    dataFlowType = new DataflowTypeVO(dataFlow);
                }
                catch (CDXDAOException e) {
                    ServiceLookupDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    ServiceLookupDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    ServiceLookupDAO.log.error((Object)("Unable to obtain dataflow  from the database for service name: " + serviceName), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    ServiceLookupDAO.log.error((Object)("Exception happend while trying to obtain dataflow for  service name:" + serviceName), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var7_10) {
                var6_11 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    ServiceLookupDAO.log.error((Object)"Could not close prepared statement or resultset", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var7_10;
            }
            {
                var6_12 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 210->225)] { 
lbl41:
            // 1 sources

            result.close();
            pstmt.close();
            break block12;
lbl44:
            // 1 sources

            catch (Exception ex) {
                ServiceLookupDAO.log.error((Object)"Could not close prepared statement or resultset", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return dataFlowType;
    }
}

