/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.serviceprovider;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.DynamicLoader;
import gov.epa.cdx.infrastructure.node.NodeMgr;
import gov.epa.cdx.infrastructure.serviceprovider.ServiceProviderUtil;
import gov.epa.cdx.model.serviceprovider.ServiceProvider;

public class ServiceProviderFactory {
    private static LogInterface log;
    private static final String SERVICEPROVIDER_CATEGORY_KEY = "ServiceProvider";
    private static final String SERVICEPROVIDER_TYPE_KEY = "ServiceProviderType";
    private static final String SERVICEPROVIDER_SUFFIX_CATEGORY_KEY = "ExternalApplications";
    private static final String SERVICEPROVIDER_SUFFIX_TYPE_KEY = "ServiceProviderSuffix";
    private static final String SESSIONBEAN_TYPE = "SessionBean";
    private static final String GENERIC_CATEGORY_KEY = "SERVICE_PROVIDER";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.serviceprovider.ServiceProviderFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static ServiceProvider getServiceProvider(String dataflow, String serviceName) throws CDXException {
        String serviceProviderDefaultClassName = CDXPropertyManager.getProperty((String)dataflow, (String)SERVICEPROVIDER_CATEGORY_KEY);
        String serviceProviderDefaultType = CDXPropertyManager.getProperty((String)dataflow, (String)SERVICEPROVIDER_TYPE_KEY);
        String serviceProviderSuffix = CDXPropertyManager.getProperty((String)SERVICEPROVIDER_SUFFIX_CATEGORY_KEY, (String)SERVICEPROVIDER_SUFFIX_TYPE_KEY, (String)".ServiceProvider");
        String dataflowServiceProvider = String.valueOf(dataflow) + serviceProviderSuffix;
        String serviceProviderOverrideClassName = CDXPropertyManager.getProperty((String)dataflow, (String)serviceName);
        String serviceProviderGenericClassName = CDXPropertyManager.getProperty((String)GENERIC_CATEGORY_KEY, (String)SERVICEPROVIDER_CATEGORY_KEY);
        String serviceProviderGenericType = CDXPropertyManager.getProperty((String)GENERIC_CATEGORY_KEY, (String)SERVICEPROVIDER_TYPE_KEY);
        String serviceProviderClassName = null;
        serviceProviderClassName = serviceProviderOverrideClassName == null ? serviceProviderDefaultClassName : serviceProviderOverrideClassName;
        if (serviceProviderGenericClassName != null) {
            serviceProviderClassName = serviceProviderGenericClassName;
        }
        boolean sessionBean = true;
        if (serviceProviderClassName == null) {
            serviceProviderClassName = dataflowServiceProvider;
        } else if (serviceProviderDefaultType != null && !serviceProviderDefaultType.equalsIgnoreCase(SESSIONBEAN_TYPE)) {
            sessionBean = false;
        } else if (serviceProviderGenericClassName != null && serviceProviderGenericType != null && !serviceProviderGenericType.equalsIgnoreCase(SESSIONBEAN_TYPE)) {
            sessionBean = false;
        }
        try {
            NodeMgr.getUrlByNode(dataflowServiceProvider);
            serviceProviderClassName = dataflowServiceProvider;
            sessionBean = true;
        }
        catch (Exception exception) {}
        ServiceProvider spi = null;
        try {
            spi = sessionBean ? ServiceProviderUtil.getRemote(serviceProviderClassName) : (ServiceProvider)DynamicLoader.loadAndInstantiateClass((String)serviceProviderClassName);
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.SERVICEPROVIDER_FOR_SERVICE_COULD_NOT_BE_LOADED, (Throwable)ex);
        }
        return spi;
    }
}

