/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.statusnotifier;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.DynamicLoader;
import gov.epa.cdx.infrastructure.statusnotifier.StatusNotifierUtil;
import gov.epa.cdx.model.statusnotifier.StatusNotifier;

public class StatusNotifierFactory {
    private static LogInterface log;
    private static final String STATUSNOTIFIER_CATEGORY_KEY = "StatusNotifier";
    private static final String STATUSNOTIFIER_TYPE_KEY = "StatusNotifierType";
    private static final String STATUSNOTIFIER_SUFFIX_CATEGORY_KEY = "ExternalApplications";
    private static final String STATUSNOTIFIER_SUFFIX_TYPE_KEY = "StatusNotifierSuffix";
    private static final String SESSIONBEAN_TYPE = "SessionBean";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.statusnotifier.StatusNotifierFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static StatusNotifier getStatusNotifier(String dataflow) throws CDXException {
        String statusProviderDefaultClassName = CDXPropertyManager.getProperty((String)dataflow, (String)STATUSNOTIFIER_CATEGORY_KEY);
        String statusProviderDefaultType = CDXPropertyManager.getProperty((String)dataflow, (String)STATUSNOTIFIER_TYPE_KEY);
        String statusProviderSuffix = CDXPropertyManager.getProperty((String)STATUSNOTIFIER_SUFFIX_CATEGORY_KEY, (String)STATUSNOTIFIER_SUFFIX_TYPE_KEY, (String)".StatusNotifier");
        boolean sessionBean = true;
        if (statusProviderDefaultClassName == null) {
            statusProviderDefaultClassName = String.valueOf(dataflow) + statusProviderSuffix;
        } else if (statusProviderDefaultType != null && !statusProviderDefaultType.equalsIgnoreCase(SESSIONBEAN_TYPE)) {
            sessionBean = false;
        }
        StatusNotifier spi = null;
        try {
            spi = sessionBean ? StatusNotifierUtil.getRemote(statusProviderDefaultClassName) : (StatusNotifier)DynamicLoader.loadAndInstantiateClass((String)statusProviderDefaultClassName);
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.STATUSNOTIFIER_FOR_SERVICE_COULD_NOT_BE_LOADED, (Throwable)ex);
        }
        return spi;
    }
}

