/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.statusprovider;

import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.property.CDXPropertyManager;
import gov.epa.cdx.commons.util.DynamicLoader;
import gov.epa.cdx.infrastructure.statusprovider.StatusProviderUtil;
import gov.epa.cdx.model.statusprovider.StatusProvider;

public class StatusProviderFactory {
    private static LogInterface log;
    private static final String STATUSPROVIDER_CATEGORY_KEY = "StatusProvider";
    private static final String STATUSPROVIDER_TYPE_KEY = "StatusProviderType";
    private static final String STATUSPROVIDER_SUFFIX_CATEGORY_KEY = "ExternalApplications";
    private static final String STATUSPROVIDER_SUFFIX_TYPE_KEY = "StatusProviderSuffix";
    private static final String SESSIONBEAN_TYPE = "SessionBean";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.statusprovider.StatusProviderFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    public static StatusProvider getStatusProvider(String dataflow) throws CDXException {
        String statusProviderDefaultClassName = CDXPropertyManager.getProperty((String)dataflow, (String)STATUSPROVIDER_CATEGORY_KEY);
        String statusProviderDefaultType = CDXPropertyManager.getProperty((String)dataflow, (String)STATUSPROVIDER_TYPE_KEY);
        String statusProviderSuffix = CDXPropertyManager.getProperty((String)STATUSPROVIDER_SUFFIX_CATEGORY_KEY, (String)STATUSPROVIDER_SUFFIX_TYPE_KEY, (String)".StatusProvider");
        boolean sessionBean = true;
        if (statusProviderDefaultClassName == null) {
            statusProviderDefaultClassName = String.valueOf(dataflow) + statusProviderSuffix;
        } else if (statusProviderDefaultType != null && !statusProviderDefaultType.equalsIgnoreCase(SESSIONBEAN_TYPE)) {
            sessionBean = false;
        }
        StatusProvider spi = null;
        try {
            spi = sessionBean ? StatusProviderUtil.getRemote(statusProviderDefaultClassName) : (StatusProvider)DynamicLoader.loadAndInstantiateClass((String)statusProviderDefaultClassName);
        }
        catch (Exception ex) {
            throw new CDXException(CDXErrorCode.STATUSPROVIDER_FOR_SERVICE_COULD_NOT_BE_LOADED, (Throwable)ex);
        }
        return spi;
    }
}

