/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.transaction;

import gov.epa.cdx.aspects.qos.DataflowMonitoring;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.transaction.dao.TransactionDAO;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentStatusVO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.util.List;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;

public class TransactionMgr {
    protected static LogInterface log;
    static /* synthetic */ Class class$0;
    private static final JoinPoint.StaticPart ajc$tjp_0;

    static {
        Factory factory = new Factory("TransactionMgr.java", Class.forName("gov.epa.cdx.infrastructure.transaction.TransactionMgr"));
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("9-updateTransactionStatus-gov.epa.cdx.infrastructure.transaction.TransactionMgr-java.lang.String:gov.epa.cdx.model.transaction.Status:-transactionID:status:-gov.epa.cdx.commons.exception.CDXException:-void-"), 175);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.transaction.TransactionMgr");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
    }

    private TransactionMgr() {
    }

    public static TransactionVO create() throws CDXException {
        return TransactionMgr.create(null, null);
    }

    public static TransactionVO create(String transactionId, Status status) throws CDXException {
        log.debug((Object)"Enter TransactionMgr.createTransaction()");
        TransactionVO transactionVO = new TransactionVO();
        if (transactionId != null && !transactionId.equals("")) {
            transactionVO.setTransactionID(transactionId);
        } else {
            transactionVO.setTransactionID(GUID.getGUID());
        }
        if (status == null) {
            transactionVO.setStatus(Status.RECEIVED);
        } else {
            transactionVO.setStatus(status);
        }
        transactionVO.setCreatedBy("cdxadmin");
        TransactionDAO.insert(transactionVO);
        log.debug((Object)"Exit TransactionMgr.createTransaction()");
        return transactionVO;
    }

    public static TransactionVO getTransaction(String transactionID) throws CDXException {
        log.debug((Object)"Enter TransactionMgr.getTransaction()");
        TransactionVO transactionVO = TransactionDAO.load(transactionID);
        log.debug((Object)"Exit TransactionMgr.getTransaction()");
        return transactionVO;
    }

    public static List getTransactionHistoriesSinceDate(DataflowTypeVO dataflow, long changeDate, DocumentStatusVO status) throws CDXException {
        return TransactionDAO.getTransactionHistoriesSinceDate(dataflow, changeDate, status);
    }

    public static List getTransactionHistoriesByTransactionId(String transactionId) throws CDXException {
        return TransactionDAO.getTransactionHistoriesByTransactionId(transactionId);
    }

    public static boolean isValid(String transactionID) throws CDXException {
        log.debug((Object)"Enter TransactionMgr.isValid()");
        try {
            TransactionMgr.getTransactionStatus(transactionID);
            log.debug((Object)"Exit TransactionMgr.isValid() true");
            return true;
        }
        catch (CDXValidationException cDXValidationException) {
            log.debug((Object)"Exit TransactionMgr.isValid() false");
            return false;
        }
    }

    public static Status getTransactionStatus(String transactionID) throws CDXException {
        log.debug((Object)"Enter TransactionMgr.getTransactionStatus()");
        Status status = null;
        status = TransactionDAO.getStatus(transactionID);
        log.debug((Object)"Exit TransactionMgr.getTransactionStatus()");
        return status;
    }

    /*
     * WARNING - void declaration
     */
    public static void updateTransactionStatus(String string, Status status) throws CDXException {
        void status2;
        String transactionID;
        String string2 = string;
        Status status3 = status;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, null, null, (Object)string2, (Object)status3);
        log.debug((Object)"Enter TransactionMgr.updateTransactionStatus()");
        TransactionVO transactionVO = new TransactionVO();
        transactionVO.setTransactionID(transactionID);
        transactionVO.setStatus((Status)status2);
        transactionVO.setUpdatedBy("cdxadmin");
        TransactionDAO.update(transactionVO);
        log.debug((Object)"Exit TransactionMgr.updateTransactionStatus()");
        DataflowMonitoring.aspectOf().ajc$afterReturning$gov_epa_cdx_aspects_qos_DataflowMonitoring$2$d445941a(joinPoint);
    }
}

