/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.transaction;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.transaction.TransactionMgr;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TransactionTst
extends TestCase {
    public TransactionTst(String name) {
        super(name);
    }

    public void testEmptyCreate() {
        TransactionVO transactionVO = null;
        try {
            transactionVO = TransactionMgr.create();
            TransactionVO transactionVOFromDB = TransactionMgr.getTransaction(transactionVO.getTransactionID());
            Assert.assertEquals((String)Status.RECEIVED.toString(), (String)transactionVOFromDB.getStatus().toString());
            Assert.assertEquals((String)transactionVO.getTransactionID(), (String)transactionVOFromDB.getTransactionID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"Cannot create transaction");
        }
    }

    public void testCreate() {
        String guid = GUID.getGUID();
        try {
            TransactionMgr.create(guid, Status.RECEIVED);
            TransactionVO transactionVOFromDB = TransactionMgr.getTransaction(guid);
            Assert.assertEquals((String)Status.RECEIVED.toString(), (String)transactionVOFromDB.getStatus().toString());
            Assert.assertEquals((String)guid, (String)transactionVOFromDB.getTransactionID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"Cannot create transaction");
        }
    }

    public void testUpdate() {
        String guid = GUID.getGUID();
        try {
            TransactionMgr.create(guid, Status.RECEIVED);
            TransactionVO transactionVOFromDB = TransactionMgr.getTransaction(guid);
            Assert.assertEquals((String)Status.RECEIVED.toString(), (String)transactionVOFromDB.getStatus().toString());
            Assert.assertEquals((String)guid, (String)transactionVOFromDB.getTransactionID());
            TransactionMgr.updateTransactionStatus(transactionVOFromDB.getTransactionID(), Status.PROCESSED);
            TransactionVO transactionVOFromDBAfterUpdate = TransactionMgr.getTransaction(guid);
            Assert.assertEquals((String)Status.PROCESSED.toString(), (String)transactionVOFromDBAfterUpdate.getStatus().toString());
            Assert.assertEquals((String)guid, (String)transactionVOFromDBAfterUpdate.getTransactionID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"Couldnt update transaction");
        }
    }
}

