/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.transaction.dao;

import gov.epa.cdx.commons.basedao.dao.BaseDAO;
import gov.epa.cdx.commons.exception.CDXDAOException;
import gov.epa.cdx.commons.exception.CDXErrorCode;
import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.log.LogFactory;
import gov.epa.cdx.commons.log.LogInterface;
import gov.epa.cdx.infrastructure.transaction.dao.TransactionHistoryResultReader;
import gov.epa.cdx.infrastructure.util.ComponentLocator;
import gov.epa.cdx.model.dataflow.DataflowTypeVO;
import gov.epa.cdx.model.document.DocumentStatusVO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;

public class TransactionDAO {
    private static LogInterface log;
    private static String SELECT_SQL;
    private static String INSERT_SQL;
    private static String DELETE_SQL;
    private static String UPDATE_SQL;
    private static String SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_DATE_STATUS;
    private static String SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_DATE;
    private static String SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_STATUS;
    private static String SELECT_SQL_TRANSACTIONS_BY_TRANSACTION_ID;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("gov.epa.cdx.infrastructure.transaction.dao.TransactionDAO");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((String)clazz.getName());
        SELECT_SQL = "SELECT cdx.created_tm, cdx.creator_tx, cdx.trans_status_id FROM cdx_transactions cdx WHERE ((cdx.transaction_id = ?))";
        INSERT_SQL = "INSERT INTO cdx_transactions (transaction_id, creator_tx, trans_status_id) VALUES (?, ?, ?)";
        DELETE_SQL = "DELETE FROM cdx_transactions cdx WHERE ((cdx.transaction_id = ?))";
        UPDATE_SQL = "UPDATE cdx_transactions cdx SET trans_status_id = ? WHERE ((cdx.transaction_id = ?))";
        SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_DATE_STATUS = " SELECT cdx_documents.document_id, cdx_documents.dataflow_type_id, cdx_documents.document_name_tx, cdx_documents.validation_status_id, cdx_documents.document_type_id, cdx_transactions.transaction_id, cdx_transactions.trans_status_id, cdx_transactions.CREATED_TM  FROM cdx_documents, cdx_transactions  WHERE cdx_documents.transaction_id=cdx_transactions.transaction_id  AND ((cdx_documents.dataflow_type_id=?) AND (cdx_transactions.CREATED_TM) > ?) AND (cdx_documents.validation_status_id=?)  Order by cdx_transactions.CREATED_TM desc ";
        SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_DATE = " SELECT cdx_documents.document_id, cdx_documents.dataflow_type_id, cdx_documents.document_name_tx , cdx_documents.validation_status_id, cdx_documents.document_type_id, cdx_transactions.transaction_id, cdx_transactions.trans_status_id, cdx_transactions.CREATED_TM  FROM cdx_documents, cdx_transactions  WHERE cdx_documents.transaction_id=cdx_transactions.transaction_id  AND ((cdx_documents.dataflow_type_id=?) AND (cdx_transactions.CREATED_TM) > ?)   Order by cdx_transactions.CREATED_TM desc ";
        SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_STATUS = " SELECT cdx_documents.document_id, cdx_documents.dataflow_type_id, cdx_documents.document_name_tx , cdx_documents.validation_status_id, cdx_documents.document_type_id, cdx_transactions.transaction_id, cdx_transactions.trans_status_id, cdx_transactions.CREATED_TM  FROM cdx_documents, cdx_transactions  WHERE cdx_documents.transaction_id=cdx_transactions.transaction_id  AND ((cdx_documents.dataflow_type_id=?) AND (cdx_documents.validation_status_id=?))  Order by cdx_transactions.CREATED_TM desc ";
        SELECT_SQL_TRANSACTIONS_BY_TRANSACTION_ID = " SELECT cdx_documents.document_id, cdx_documents.dataflow_type_id, cdx_documents.document_name_tx , cdx_documents.validation_status_id, cdx_documents.document_type_id, cdx_transactions.transaction_id, cdx_transactions.trans_status_id, cdx_transactions.CREATED_TM  FROM cdx_documents, cdx_transactions  WHERE cdx_documents.transaction_id = cdx_transactions.transaction_id  AND cdx_transactions.transaction_id = ? ";
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TransactionVO load(String transactionId) throws CDXException {
        block13: {
            transactionVO = null;
            connection = null;
            pstmt = null;
            result = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(TransactionDAO.SELECT_SQL);
                    pstmt.setString(1, transactionId);
                    result = pstmt.executeQuery();
                    if (!result.next()) {
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_ID);
                    }
                    creator = result.getString("creator_tx");
                    transactionStatusID = result.getString("trans_status_id");
                    taskStartTime = result.getTimestamp("created_tm").getTime();
                    transactionVO = new TransactionVO();
                    transactionVO.setTransactionID(transactionId);
                    transactionVO.setCreatedBy(creator);
                    transactionVO.setCreatedTime(taskStartTime);
                    transactionVO.setStatus(Status.getStatusById((String)transactionStatusID));
                }
                catch (CDXDAOException e) {
                    TransactionDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    TransactionDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    TransactionDAO.log.error((Object)("Unable to get information for selected transactionID: " + transactionId), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    TransactionDAO.log.error((Object)("Exception happend inside TransactionDAO class, method: Load,  while trying to load information for transaction id:" + transactionId), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var10_12) {
                var9_13 = null;
                try {
                    result.close();
                    pstmt.close();
                }
                catch (Exception ex) {
                    TransactionDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var10_12;
            }
            {
                var9_14 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 259->275)] { 
lbl48:
            // 1 sources

            result.close();
            pstmt.close();
            break block13;
lbl51:
            // 1 sources

            catch (Exception ex) {
                TransactionDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
        return transactionVO;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void insert(TransactionVO transactionVO) throws CDXException {
        block13: {
            connection = null;
            pstmt = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(TransactionDAO.INSERT_SQL);
                    pstmt.setString(1, transactionVO.getTransactionID());
                    pstmt.setString(2, transactionVO.getCreatedBy());
                    pstmt.setString(3, transactionVO.getStatus().toString());
                    if (pstmt.executeUpdate() != 1) {
                        TransactionDAO.log.error((Object)("Transaction with this id already exists. TransactionID: " + transactionVO.getTransactionID()));
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_ID);
                    }
                }
                catch (CDXDAOException e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)("Unable to insert information for supplied transaction id :" + transactionVO.getTransactionID()), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)("Error happend inside TransactionDAO class, insert method,  for transactionID: " + transactionVO.getTransactionID()), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var5_7) {
                var4_8 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    TransactionDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var5_7;
            }
            {
                var4_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 244->253)] { 
lbl43:
            // 1 sources

            pstmt.close();
            break block13;
lbl45:
            // 1 sources

            catch (Exception ex) {
                TransactionDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void delete(String transactionId) throws CDXException {
        block13: {
            connection = null;
            pstmt = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(TransactionDAO.DELETE_SQL);
                    pstmt.setString(1, transactionId);
                    if (pstmt.executeUpdate() != 1) {
                        TransactionDAO.log.error((Object)("Transaction with this id does not exist. Transaction id: " + transactionId));
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_ID);
                    }
                }
                catch (CDXDAOException e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)("Unable to delete information for supplied transaction id :" + transactionId), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)("Error happend inside TransactionDAO class, delete method,  for transactionID: " + transactionId), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var5_7) {
                var4_8 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    TransactionDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var5_7;
            }
            {
                var4_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 207->216)] { 
lbl41:
            // 1 sources

            pstmt.close();
            break block13;
lbl43:
            // 1 sources

            catch (Exception ex) {
                TransactionDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void update(TransactionVO transactionVO) throws CDXException {
        block13: {
            connection = null;
            pstmt = null;
            try {
                try {
                    connection = BaseDAO.getConnection();
                    pstmt = connection.prepareStatement(TransactionDAO.UPDATE_SQL);
                    pstmt.setString(1, transactionVO.getStatus().toString());
                    pstmt.setString(2, transactionVO.getTransactionID());
                    if (pstmt.executeUpdate() != 1) {
                        TransactionDAO.log.error((Object)("Transaction with this id does not exist." + transactionVO.getTransactionID()));
                        throw new CDXValidationException(CDXErrorCode.INVALID_TRANSACTION_ID);
                    }
                }
                catch (CDXDAOException e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (CDXValidationException e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)"", (Throwable)e);
                    throw e;
                }
                catch (SQLException ex) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)("Unable to update information for supplied transaction id :" + transactionVO.getTransactionID()), (Throwable)ex);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)ex);
                }
                catch (Exception e) {
                    BaseDAO.rollback((Connection)connection);
                    TransactionDAO.log.error((Object)("Error happend inside transactionDAO class, update method,  for transactionID: " + transactionVO.getTransactionID()), (Throwable)e);
                    throw new CDXDAOException(CDXErrorCode.RUNTIME_ERROR, (Throwable)e);
                }
            }
            catch (Throwable var5_7) {
                var4_8 = null;
                try {
                    pstmt.close();
                }
                catch (Exception ex) {
                    TransactionDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
                }
                BaseDAO.closeConnection((Connection)connection);
                throw var5_7;
            }
            {
                var4_9 = null;
            }
            ** try [egrp 2[TRYBLOCK] [6 : 233->242)] { 
lbl42:
            // 1 sources

            pstmt.close();
            break block13;
lbl44:
            // 1 sources

            catch (Exception ex) {
                TransactionDAO.log.error((Object)"Could not close prepared statement", (Throwable)ex);
            }
        }
        BaseDAO.closeConnection((Connection)connection);
    }

    public static Status getStatus(String transaction) throws CDXException {
        TransactionVO transactionVO = TransactionDAO.load(transaction);
        return transactionVO.getStatus();
    }

    public static List getTransactionHistoriesByTransactionId(String transactionId) throws CDXException {
        JdbcTemplate jt = new JdbcTemplate(ComponentLocator.getInfrastructureDataSource());
        try {
            return jt.query(SELECT_SQL_TRANSACTIONS_BY_TRANSACTION_ID, new Object[]{transactionId}, new int[]{12}, (RowCallbackHandler)new TransactionHistoryResultReader());
        }
        catch (DataAccessException e) {
            log.error((Object)e);
            throw new CDXException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)e);
        }
    }

    public static List getTransactionHistoriesSinceDate(DataflowTypeVO dataflow, long changeDate, DocumentStatusVO status) throws CDXException {
        JdbcTemplate jt = new JdbcTemplate(ComponentLocator.getInfrastructureDataSource());
        List results = null;
        try {
            results = status != null ? (changeDate > 0L ? jt.query(SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_DATE_STATUS, new Object[]{dataflow.getDataflowType(), new Timestamp(changeDate), status.getId()}, new int[]{12, 93, 12}, (RowCallbackHandler)new TransactionHistoryResultReader()) : jt.query(SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_STATUS, new Object[]{dataflow.getDataflowType(), status.getId()}, new int[]{12, 12}, (RowCallbackHandler)new TransactionHistoryResultReader())) : jt.query(SELECT_SQL_TRANSACTIONS_META_DATA_BY_FLOW_DATE, new Object[]{dataflow.getDataflowType(), new Timestamp(changeDate)}, new int[]{12, 93}, (RowCallbackHandler)new TransactionHistoryResultReader());
            return results;
        }
        catch (DataAccessException e) {
            log.error((Object)e);
            throw new CDXException(CDXErrorCode.RUNTIME_SQL_ERROR, (Throwable)e);
        }
    }
}

