/*
 * Decompiled with CFR 0.152.
 */
package gov.epa.cdx.infrastructure.transaction.dao;

import gov.epa.cdx.commons.exception.CDXException;
import gov.epa.cdx.commons.exception.CDXValidationException;
import gov.epa.cdx.commons.util.GUID;
import gov.epa.cdx.infrastructure.transaction.dao.TransactionDAO;
import gov.epa.cdx.model.transaction.Status;
import gov.epa.cdx.model.transaction.TransactionVO;
import junit.framework.Assert;
import junit.framework.TestCase;

public class TransactionDAOTest
extends TestCase {
    public TransactionDAOTest() {
        super("TransactionDAOTest");
    }

    public TransactionDAOTest(String name) {
        super(name);
    }

    public void setUp() {
    }

    public void testLoad() {
        try {
            TransactionVO vo = new TransactionVO();
            vo.setCreatedBy("ddundua");
            vo.setTransactionID("testID");
            vo.setStatus(Status.RECEIVED);
            TransactionDAO.insert(vo);
            TransactionDAO.load("testID");
            TransactionDAO.delete("testID");
        }
        catch (CDXException daoException) {
            daoException.printStackTrace();
            Assert.fail((String)"DAO Exception occured");
        }
    }

    public void testLoadInvalid() {
        try {
            TransactionDAO.load("INVALIDID_PASSED_IN");
            Assert.fail((String)"exception Should have occured");
        }
        catch (CDXValidationException cDXValidationException) {
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"DAO Exception occured");
        }
    }

    public void testInsert() {
        TransactionVO vo = new TransactionVO();
        vo.setCreatedBy("ddundua");
        vo.setTransactionID("TestInsertId");
        vo.setStatus(Status.RECEIVED);
        try {
            try {
                TransactionDAO.delete(vo.getTransactionID());
            }
            catch (CDXException cDXException) {}
            TransactionDAO.insert(vo);
            TransactionDAO.delete(vo.getTransactionID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"DAO Exception occured");
        }
    }

    public void testManyInsert() {
        int i = 0;
        while (i < 50) {
            TransactionVO vo = new TransactionVO();
            vo.setCreatedBy("ddundua");
            vo.setTransactionID(GUID.getGUID());
            vo.setStatus(Status.RECEIVED);
            try {
                try {
                    TransactionDAO.delete(vo.getTransactionID());
                }
                catch (CDXException cDXException) {}
                TransactionDAO.insert(vo);
                TransactionDAO.delete(vo.getTransactionID());
            }
            catch (CDXException cDXException) {
                Assert.fail((String)"DAO Exception occured");
            }
            ++i;
        }
    }

    public void testUpdate() {
        TransactionVO vo = new TransactionVO();
        vo.setCreatedBy("ddundua");
        vo.setTransactionID("TestUpdateId");
        vo.setStatus(Status.RECEIVED);
        try {
            try {
                TransactionDAO.delete(vo.getTransactionID());
            }
            catch (CDXException cDXException) {}
            TransactionDAO.insert(vo);
            vo.setStatus(Status.FAILED);
            TransactionDAO.update(vo);
            TransactionDAO.delete(vo.getTransactionID());
        }
        catch (CDXException cDXException) {
            Assert.fail((String)"DAO Exception occured");
        }
    }
}

